/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.NewLiferayModuleProjectOp;
import com.liferay.ide.project.core.modules.ServiceCommand;
import com.liferay.ide.project.core.modules.ServiceContainer;
import com.liferay.ide.project.core.modules.ServiceWrapperCommand;
import java.util.Set;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class ServicePossibleValuesService
extends PossibleValuesService {
    private Listener listener;

    protected void initPossibleValuesService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ServicePossibleValuesService.this.refresh();
            }
        };
        this.op().property(NewLiferayModuleProjectOp.PROP_PROJECT_TEMPLATE_NAME).attach(this.listener);
    }

    protected void compute(Set<String> values) {
        NewLiferayModuleProjectOp op = this.op();
        String template = (String)op.getProjectTemplateName().content(true);
        IServer runningServer = null;
        IServer[] servers = ServerCore.getServers();
        if (template.equals("service-wrapper")) {
            IServer[] iServerArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                if (server.getServerType().getId().equals("com.liferay.ide.server.portal")) {
                    runningServer = server;
                    break;
                }
                ++n2;
            }
            try {
                ServiceContainer serviceWrapperList = new ServiceWrapperCommand(runningServer).execute();
                values.addAll(serviceWrapperList.getServiceList());
            }
            catch (Exception e) {
                ProjectCore.logError("Get service wrapper list error.", e);
            }
        } else if (template.equals("service")) {
            IServer[] iServerArray = servers;
            int n = servers.length;
            int n3 = 0;
            while (n3 < n) {
                IServer server = iServerArray[n3];
                if (server.getServerState() == 2 && server.getServerType().getId().equals("com.liferay.ide.server.portal")) {
                    runningServer = server;
                    break;
                }
                ++n3;
            }
            try {
                ServiceCommand serviceCommand = new ServiceCommand(runningServer);
                ServiceContainer allServices = serviceCommand.execute();
                values.addAll(allServices.getServiceList());
            }
            catch (Exception e) {
                ProjectCore.logError("Get services list error. ", e);
            }
        }
    }

    public void dispose() {
        if (this.listener != null) {
            this.op().property(NewLiferayModuleProjectOp.PROP_PROJECT_TEMPLATE_NAME).detach(this.listener);
            this.listener = null;
        }
        super.dispose();
    }

    private NewLiferayModuleProjectOp op() {
        return (NewLiferayModuleProjectOp)this.context(NewLiferayModuleProjectOp.class);
    }

    public Status problem(Value<?> value) {
        return Status.createOkStatus();
    }
}

