/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.templates.pollerprocessor;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.NewLiferayComponentOp;
import com.liferay.ide.project.core.modules.templates.AbstractLiferayComponentTemplate;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class NewLiferayComponentPollerProcessorOperation
extends AbstractLiferayComponentTemplate {
    private static final String POLLER_TEMPLATE_FILE = "pollerprocessor/pollerprocessor.ftl";
    private static final String POLLER_SUPER_CLASSES = "BasePollerProcessor";
    private static final String POLLER_PORTLET_SUPER_CLASSES = "MVCPortlet";
    private static final String POLLER_EXTENSION_CLASSES = "PollerProcessor.class";
    private static final String POLLER_PORTLET_EXTENSION_CLASSES = "Portlet.class";
    private static final String[] POLLER_PORTLET_PROPERTIES_LIST = new String[]{"com.liferay.portlet.css-class-wrapper=portlet-pollprocessor-blade", "com.liferay.portlet.display-category=category.sample", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.remoteable=true", "com.liferay.portlet.render-weight=50", "javax.portlet.expiration-cache=0", "javax.portlet.portlet.info.keywords=pollprocessor", "javax.portlet.security-role-ref=power-user,user"};

    private List<String> getPollerPortletImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("javax.portlet.Portlet");
        imports.add("com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet");
        imports.addAll(super.getImports());
        return imports;
    }

    private List<String> getPollerImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("com.liferay.portal.kernel.json.JSONFactoryUtil");
        imports.add("com.liferay.portal.kernel.json.JSONObject");
        imports.add("com.liferay.portal.kernel.log.Log");
        imports.add("com.liferay.portal.kernel.log.LogFactoryUtil");
        imports.add("com.liferay.portal.kernel.poller.BasePollerProcessor");
        imports.add("com.liferay.portal.kernel.poller.DefaultPollerResponse");
        imports.add("com.liferay.portal.kernel.poller.PollerProcessor");
        imports.add("com.liferay.portal.kernel.poller.PollerRequest");
        imports.add("com.liferay.portal.kernel.poller.PollerResponse");
        imports.add("java.util.Date");
        imports.addAll(super.getImports());
        return imports;
    }

    private List<String> getPollerProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        for (String property : super.getProperties()) {
            properties.add(property);
        }
        properties.add("javax.portlet.name=" + this.componentClassName + "Portlet");
        return properties;
    }

    private List<String> getPollerPortletProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.addAll(Arrays.asList(POLLER_PORTLET_PROPERTIES_LIST));
        for (String property : super.getProperties()) {
            properties.add(property);
        }
        properties.add("javax.portlet.init-param.template-path=/");
        properties.add("com.liferay.portlet.poller-processor-class=" + this.packageName + "." + this.componentClassName);
        properties.add("javax.portlet.display-name=" + this.componentClassName);
        properties.add("javax.portlet.portlet.info.short-title=" + this.componentClassName);
        properties.add("javax.portlet.portlet.info.title=" + this.componentClassName);
        properties.add("com.liferay.portlet.header-portlet-javascript=/" + this.componentClassName.toLowerCase() + "/js/main.js");
        properties.add("javax.portlet.init-param.view-template=/" + this.componentClassName.toLowerCase() + "/view.jsp");
        properties.add("javax.portlet.resource-bundle=content.Language");
        return properties;
    }

    private String getPollerExtensionClass() {
        return POLLER_EXTENSION_CLASSES;
    }

    private String getPollerPortletExtensionClass() {
        return POLLER_PORTLET_EXTENSION_CLASSES;
    }

    private String getPollerSuperClass() {
        return POLLER_SUPER_CLASSES;
    }

    private String getPollerPortletSuperClass() {
        return POLLER_PORTLET_SUPER_CLASSES;
    }

    @Override
    public void doExecute(NewLiferayComponentOp op, IProgressMonitor monitor) throws CoreException {
        try {
            this.initializeOperation(op);
            this.project = CoreUtil.getProject((String)this.projectName);
            if (this.project != null) {
                this.liferayProject = LiferayCore.create((Object)this.project);
                if (this.liferayProject != null) {
                    this.initFreeMarker();
                    IFile pollerClassFile = this.prepareClassFile(this.componentClassName);
                    this.doSourceCodeOperation(pollerClassFile, "poller");
                    IFile pollerPortletClassFile = this.prepareClassFile(String.valueOf(this.componentClassName) + "Portlet");
                    this.doSourceCodeOperation(pollerPortletClassFile, "pollerPortlet");
                    this.doMergeResourcesOperation();
                    this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
    }

    private Map<String, Object> getTemplateMap(String type) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        if (type.equals("poller")) {
            root.put("importlibs", this.getPollerImports());
            root.put("properties", this.getPollerProperties());
            root.put("classname", this.componentClassName);
            root.put("supperclass", this.getPollerSuperClass());
            root.put("extensionclass", this.getPollerExtensionClass());
        } else {
            root.put("importlibs", this.getPollerPortletImports());
            root.put("properties", this.getPollerPortletProperties());
            root.put("classname", String.valueOf(this.componentClassName) + "Portlet");
            root.put("supperclass", this.getPollerPortletSuperClass());
            root.put("extensionclass", this.getPollerPortletExtensionClass());
        }
        root.put("packagename", this.packageName);
        root.put("projectname", this.projectName);
        root.put("componenttype", this.templateName);
        return root;
    }

    @Override
    protected String getTemplateFile() {
        return POLLER_TEMPLATE_FILE;
    }

    private void doSourceCodeOperation(IFile srcFile, String type) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fos = new FileOutputStream(srcFile.getLocation().toFile());){
                Template temp = this.cfg.getTemplate(this.getTemplateFile());
                Map<String, Object> root = this.getTemplateMap(type);
                OutputStreamWriter out = new OutputStreamWriter(fos);
                temp.process(root, (Writer)out);
                fos.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TemplateException | IOException e) {
            throw new CoreException(ProjectCore.createErrorStatus((Exception)e));
        }
    }

    @Override
    protected void doMergeResourcesOperation() throws CoreException {
        try {
            IFile viewJsp;
            IFile initJsp;
            IFolder resourceFolder = this.liferayProject.getSourceFolder("resources");
            IFolder contentFolder = resourceFolder.getFolder("content");
            IFile languageProperties = contentFolder.getFile((IPath)new Path("Language.properties"));
            File languagePropertiesFile = languageProperties.getLocation().toFile();
            if (languagePropertiesFile.exists()) {
                String originContent = FileUtil.readContents((File)languagePropertiesFile, (boolean)true);
                URL sampleFileURL = this.getClass().getClassLoader().getResource("com/liferay/ide/project/core/modules/templates/pollerprocessor/poller-language.properties");
                String addContent = FileUtil.readContents((File)new File(FileLocator.toFileURL((URL)sampleFileURL).getFile()), (boolean)true);
                String totalContent = String.valueOf(originContent) + System.getProperty("line.separator") + addContent;
                FileUtil.writeFile((File)languagePropertiesFile, (byte[])totalContent.getBytes(), (String)this.projectName);
            } else {
                this.createSampleFile(languageProperties, "pollerprocessor/poller-language.properties");
            }
            IFolder metaFolder = resourceFolder.getFolder("META-INF/resources");
            IFile mainJs = metaFolder.getFile((IPath)new Path(String.valueOf(this.componentClassName.toLowerCase()) + "/js/main.js"));
            if (!mainJs.getLocation().toFile().exists()) {
                this.createSampleFile(mainJs, "pollerprocessor/poller-main.js");
            }
            if (!(initJsp = metaFolder.getFile((IPath)new Path(String.valueOf(this.componentClassName.toLowerCase()) + "/init.jsp"))).getLocation().toFile().exists()) {
                this.createSampleFile(initJsp, "pollerprocessor/poller-init.jsp");
            }
            if (!(viewJsp = metaFolder.getFile((IPath)new Path(String.valueOf(this.componentClassName.toLowerCase()) + "/view.jsp"))).getLocation().toFile().exists()) {
                this.createSampleFile(viewJsp, "pollerprocessor/poller-view.jsp", "/init.jsp", "/" + this.componentClassName.toLowerCase() + "/init.jsp");
            }
        }
        catch (Exception e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
    }

    @Override
    protected List<String[]> getComponentDependency() throws CoreException {
        List<String[]> componentDependency = super.getComponentDependency();
        componentDependency.add(new String[]{"javax.portlet", "portlet-api", "2.0"});
        return componentDependency;
    }
}

