/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.templates.portletinactioncommand;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.NewLiferayComponentOp;
import com.liferay.ide.project.core.modules.templates.AbstractLiferayComponentTemplate;
import com.liferay.ide.project.core.modules.templates.BndProperties;
import com.liferay.ide.project.core.modules.templates.BndPropertiesValue;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class NewLiferayComponentPortletActionCommandOperation
extends AbstractLiferayComponentTemplate {
    private static final String PORTLET_ACTION_COMMAND_TEMPLATE_FILE = "portletinactioncommand/portletactioncommand.ftl";
    private static final String PORTLET_SUPER_CLASSES = "FreeMarkerPortlet";
    private static final String PORTLET_ACTION_COMMAND_SUPER_CLASSES = "MVCActionCommand";
    private static final String PORTLET_EXTENSION_CLASSES = "Portlet.class";
    private static final String PORTLET_ACTION_COMMAND_EXTENSION_CLASSES = "MVCActionCommand.class";
    private static final String[] PORTLET_PROPERTIES_LIST = new String[]{"com.liferay.portlet.display-category=category.sample", "com.liferay.portlet.instanceable=true", "javax.portlet.init-param.template-path=/", "javax.portlet.security-role-ref=power-user,user"};

    private List<String> getPortletImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.addAll(super.getImports());
        imports.add("javax.portlet.Portlet");
        imports.add("com.liferay.util.bridges.freemarker.FreeMarkerPortlet");
        return imports;
    }

    private List<String> getPortletActionCommandImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("com.liferay.portal.kernel.log.Log");
        imports.add("com.liferay.portal.kernel.log.LogFactoryUtil");
        imports.add("com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand");
        imports.add("com.liferay.portal.kernel.servlet.SessionMessages");
        imports.add("com.liferay.portal.kernel.util.ParamUtil");
        imports.add("com.liferay.portal.kernel.util.StringPool");
        imports.add("javax.portlet.ActionRequest");
        imports.add("javax.portlet.ActionResponse");
        imports.add("javax.portlet.PortletException");
        imports.addAll(super.getImports());
        return imports;
    }

    private List<String> getPortletProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.addAll(Arrays.asList(PORTLET_PROPERTIES_LIST));
        for (String property : super.getProperties()) {
            properties.add(property);
        }
        properties.add("javax.portlet.display-name=" + this.componentNameWithoutTemplateName + " Portlet");
        properties.add("javax.portlet.init-param.view-template=/" + this.componentClassName.toLowerCase().toLowerCase() + "/view.ftl");
        properties.add("com.liferay.portlet.css-class-wrapper=portlet-" + this.componentNameWithoutTemplateName.toLowerCase());
        return properties;
    }

    private List<String> getPortletActionCommandProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("javax.portlet.name=blade_portlet_" + this.componentNameWithoutTemplateName + "Portlet");
        properties.add("mvc.command.name=" + this.componentNameWithoutTemplateName.toLowerCase());
        return properties;
    }

    private String getPortletExtensionClass() {
        return PORTLET_EXTENSION_CLASSES;
    }

    private String getPortletActionCommandExtensionClass() {
        return PORTLET_ACTION_COMMAND_EXTENSION_CLASSES;
    }

    private String getPortletSuperClass() {
        return PORTLET_SUPER_CLASSES;
    }

    private String getPortletActionCommandSuperClass() {
        return PORTLET_ACTION_COMMAND_SUPER_CLASSES;
    }

    @Override
    public void doExecute(NewLiferayComponentOp op, IProgressMonitor monitor) throws CoreException {
        try {
            this.initializeOperation(op);
            this.project = CoreUtil.getProject((String)this.projectName);
            if (this.project != null) {
                this.liferayProject = LiferayCore.create((Object)this.project);
                if (this.liferayProject != null) {
                    this.initFreeMarker();
                    IFile pollerClassFile = this.prepareClassFile(String.valueOf(this.componentNameWithoutTemplateName) + "Portlet");
                    this.doSourceCodeOperation(pollerClassFile, "portlet");
                    IFile pollerPortletClassFile = this.prepareClassFile(String.valueOf(this.componentNameWithoutTemplateName) + "ActionCommand");
                    this.doSourceCodeOperation(pollerPortletClassFile, "actionCommand");
                    op.setComponentClassName(String.valueOf(this.componentNameWithoutTemplateName) + "ActionCommand");
                    this.doMergeResourcesOperation();
                    this.doMergeBndOperation();
                    this.doMergeDependencyOperation();
                    this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
    }

    private Map<String, Object> getTemplateMap(String type) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        if (type.equals("portlet")) {
            root.put("importlibs", this.getPortletImports());
            root.put("properties", this.getPortletProperties());
            root.put("classname", String.valueOf(this.componentNameWithoutTemplateName) + "Portlet");
            root.put("supperclass", this.getPortletSuperClass());
            root.put("extensionclass", this.getPortletExtensionClass());
        } else {
            root.put("importlibs", this.getPortletActionCommandImports());
            root.put("properties", this.getPortletActionCommandProperties());
            root.put("classname", String.valueOf(this.componentNameWithoutTemplateName) + "ActionCommand");
            root.put("supperclass", this.getPortletActionCommandSuperClass());
            root.put("extensionclass", this.getPortletActionCommandExtensionClass());
        }
        root.put("packagename", this.packageName);
        root.put("projectname", this.projectName);
        root.put("componenttype", this.templateName);
        return root;
    }

    @Override
    protected String getTemplateFile() {
        return PORTLET_ACTION_COMMAND_TEMPLATE_FILE;
    }

    private void doSourceCodeOperation(IFile srcFile, String type) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fos = new FileOutputStream(srcFile.getLocation().toFile());){
                Template temp = this.cfg.getTemplate(this.getTemplateFile());
                Map<String, Object> root = this.getTemplateMap(type);
                OutputStreamWriter out = new OutputStreamWriter(fos);
                temp.process(root, (Writer)out);
                fos.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TemplateException | IOException e) {
            throw new CoreException(ProjectCore.createErrorStatus((Exception)e));
        }
    }

    @Override
    protected void doMergeResourcesOperation() throws CoreException {
        try {
            IFile viewFtl;
            IFolder resourceFolder = this.liferayProject.getSourceFolder("resources");
            IFolder metaFolder = resourceFolder.getFolder("META-INF/resources");
            IFile initFtl = metaFolder.getFile((IPath)new Path(String.valueOf(this.componentClassName.toLowerCase().toLowerCase()) + "/init.ftl"));
            if (!initFtl.getLocation().toFile().exists()) {
                this.createSampleFile(initFtl, "portletinactioncommand/portletactioncommand-init.ftl");
            }
            if (!(viewFtl = metaFolder.getFile((IPath)new Path(String.valueOf(this.componentClassName.toLowerCase().toLowerCase()) + "/view.ftl"))).getLocation().toFile().exists()) {
                this.createSampleFile(viewFtl, "portletinactioncommand/portletactionconmmand-view.ftl");
            }
        }
        catch (Exception e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
    }

    @Override
    protected List<String[]> getComponentDependency() throws CoreException {
        List<String[]> componentDependency = super.getComponentDependency();
        componentDependency.add(new String[]{"com.liferay.portal", "com.liferay.util.bridges", "2.0.0"});
        componentDependency.add(new String[]{"com.liferay.portal", "com.liferay.util.taglib", "2.0.0"});
        componentDependency.add(new String[]{"javax.portlet", "portlet-api", "2.0"});
        componentDependency.add(new String[]{"javax.servlet", "javax.servlet-api", "3.0.1"});
        return componentDependency;
    }

    @Override
    protected void setBndProperties(BndProperties bndProperty) {
        String formatedValue = "\\" + System.getProperty("line.separator") + "\t" + "@com.liferay.util.bridges-2.0.0.jar!/com/liferay/util/bridges/freemarker/FreeMarkerPortlet.class," + "\\" + System.getProperty("line.separator") + "\t" + "@com.liferay.util.taglib-2.0.0.jar!/META-INF/*.tld";
        String originalValue = "@com.liferay.util.bridges-2.0.0.jar!/com/liferay/util/bridges/freemarker/FreeMarkerPortlet.class,@com.liferay.util.taglib-2.0.0.jar!/META-INF/*.tld";
        bndProperty.addValue("-includeresource", new BndPropertiesValue(formatedValue, "@com.liferay.util.bridges-2.0.0.jar!/com/liferay/util/bridges/freemarker/FreeMarkerPortlet.class,@com.liferay.util.taglib-2.0.0.jar!/META-INF/*.tld"));
        bndProperty.addValue("-sources", new BndPropertiesValue("true"));
    }
}

