/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.upgrade.service;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.upgrade.CodeUpgradeOp;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;

public class SdkLocationValidationService
extends ValidationService {
    protected Status compute() {
        Status retval = Status.createOkStatus();
        int countPossibleWorkspaceSDKProjects = SDKUtil.countPossibleWorkspaceSDKProjects();
        if (countPossibleWorkspaceSDKProjects > 1) {
            return StatusBridge.create((IStatus)ProjectCore.createErrorStatus("This workspace has more than one SDK. "));
        }
        Path sdkLocation = (Path)this.op().getSdkLocation().content(true);
        if (sdkLocation == null || sdkLocation.isEmpty()) {
            return StatusBridge.create((IStatus)ProjectCore.createErrorStatus("This sdk location is empty "));
        }
        SDK sdk = SDKUtil.createSDKFromLocation((IPath)PathBridge.create((Path)sdkLocation));
        if (sdk != null) {
            IStatus status = sdk.validate(true);
            if (!status.isOK()) {
                return StatusBridge.create((IStatus)status);
            }
        } else {
            return StatusBridge.create((IStatus)ProjectCore.createErrorStatus("This sdk location is not correct"));
        }
        return retval;
    }

    private CodeUpgradeOp op() {
        return (CodeUpgradeOp)this.context(CodeUpgradeOp.class);
    }
}

