/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.workspace;

import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.workspace.ImportLiferayWorkspaceOp;
import org.eclipse.sapphire.DefaultValueService;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;

public class BundleUrlDefaultValueService
extends DefaultValueService {
    private FilteredListener<PropertyContentEvent> listener;

    protected void initDefaultValueService() {
        super.initDefaultValueService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                BundleUrlDefaultValueService.this.refresh();
            }
        };
        this.op().property(ImportLiferayWorkspaceOp.PROP_WORKSPACE_LOCATION).attach(this.listener);
    }

    protected String compute() {
        String bundleURL = null;
        Path path = (Path)this.op().getWorkspaceLocation().content();
        if (path == null) {
            return null;
        }
        String workspaceLocation = ((Path)this.op().getWorkspaceLocation().content()).toPortableString();
        String buildType = LiferayWorkspaceUtil.getWorkspaceType(workspaceLocation);
        if (buildType != null) {
            bundleURL = buildType.startsWith("gradle") ? LiferayWorkspaceUtil.getGradleProperty(workspaceLocation, "liferay.workspace.bundle.url", "https://cdn.lfrs.sl/releases.liferay.com/portal/7.0.3-ga4/liferay-ce-portal-tomcat-7.0-ga4-20170613175008905.zip") : "https://cdn.lfrs.sl/releases.liferay.com/portal/7.0.3-ga4/liferay-ce-portal-tomcat-7.0-ga4-20170613175008905.zip";
        }
        return bundleURL;
    }

    private ImportLiferayWorkspaceOp op() {
        return (ImportLiferayWorkspaceOp)this.context(ImportLiferayWorkspaceOp.class);
    }

    public void dispose() {
        this.op().property(ImportLiferayWorkspaceOp.PROP_WORKSPACE_LOCATION).detach(this.listener);
        super.dispose();
    }
}

