/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.workspace;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.workspace.ImportLiferayWorkspaceOp;
import com.liferay.ide.project.core.workspace.NewLiferayWorkspaceProjectProvider;
import com.liferay.ide.server.util.ServerUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;

public class ImportLiferayWorkspaceOpMethods {
    public static final Status execute(ImportLiferayWorkspaceOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Importing Liferay Workspace project...", 100);
        Status retval = null;
        try {
            op.setProjectProvider((String)op.getBuildType().content());
            NewLiferayWorkspaceProjectProvider provider = (NewLiferayWorkspaceProjectProvider)op.getProjectProvider().content(true);
            String location = ((org.eclipse.sapphire.modeling.Path)op.getWorkspaceLocation().content()).toOSString();
            LiferayWorkspaceUtil.clearWorkspace(location);
            boolean isInitBundle = (Boolean)op.getProvisionLiferayBundle().content();
            boolean isHasBundlesDir = (Boolean)op.getHasBundlesDir().content();
            String bundleUrl = (String)op.getBundleUrl().content(false);
            IStatus importStatus = isInitBundle && !isHasBundlesDir ? provider.importProject(location, monitor, true, bundleUrl) : provider.importProject(location, monitor, false, null);
            retval = StatusBridge.create((IStatus)importStatus);
            if (!retval.ok() || retval.exception() != null) {
                return retval;
            }
            if (isInitBundle || isHasBundlesDir) {
                String serverRuntimeName = (String)op.getServerName().content();
                IPath bundlesLocation = null;
                bundlesLocation = ((String)op.getBuildType().content()).equals("gradle-liferay-workspace") ? LiferayWorkspaceUtil.getHomeLocation(location) : new Path(location).append("bundles");
                if (bundlesLocation != null && bundlesLocation.toFile().exists()) {
                    ServerUtil.addPortalRuntimeAndServer((String)serverRuntimeName, (IPath)bundlesLocation, (IProgressMonitor)monitor);
                }
            }
        }
        catch (Exception e) {
            String msg = "import Liferay Workspace project error";
            ProjectCore.logError("import Liferay Workspace project error", e);
            retval = Status.createErrorStatus((String)"import Liferay Workspace project error", (Throwable)e);
        }
        return retval;
    }
}

