/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.workspace;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import com.liferay.ide.project.core.workspace.ImportLiferayWorkspaceOp;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ImportWorkspaceLocationValidationService
extends ValidationService {
    protected Status compute() {
        Status retval = Status.createOkStatus();
        try {
            if (LiferayWorkspaceUtil.hasWorkspace()) {
                return Status.createErrorStatus((String)LiferayWorkspaceUtil.hasLiferayWorkspaceMsg);
            }
        }
        catch (CoreException e) {
            return Status.createErrorStatus((String)LiferayWorkspaceUtil.multiWorkspaceErrorMsg);
        }
        Path currentProjectLocation = (Path)this.op().getWorkspaceLocation().content(true);
        if (currentProjectLocation != null && !currentProjectLocation.isEmpty()) {
            String currentPath = currentProjectLocation.toOSString();
            IStatus validPathStatus = ProjectImportUtil.validatePath(currentPath);
            if (!validPathStatus.isOK()) {
                return Status.createErrorStatus((String)validPathStatus.getMessage());
            }
            if (LiferayWorkspaceUtil.getWorkspaceType(currentPath) == null) {
                return Status.createErrorStatus((String)"Invalid Liferay Workspace");
            }
            String projectName = currentProjectLocation.lastSegment();
            if (CoreUtil.getProject((String)projectName).exists()) {
                return Status.createErrorStatus((String)"A project with that name already exists.");
            }
        }
        return retval;
    }

    private ImportLiferayWorkspaceOp op() {
        return (ImportLiferayWorkspaceOp)this.context(ImportLiferayWorkspaceOp.class);
    }
}

