/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.workspace;

import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.workspace.NewLiferayWorkspaceOp;
import com.liferay.ide.server.util.ServerUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;

public class NewLiferayWorkspaceOpMethods {
    public static final Status execute(NewLiferayWorkspaceOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Creating Liferay Workspace project...", 100);
        Status retval = null;
        try {
            String wsName = (String)op.getWorkspaceName().content();
            NewLiferayProjectProvider provider = (NewLiferayProjectProvider)op.getProjectProvider().content(true);
            IStatus status = provider.createNewProject(op, monitor);
            retval = StatusBridge.create((IStatus)status);
            if (!retval.ok()) {
                return retval;
            }
            String location = ((org.eclipse.sapphire.modeling.Path)op.getLocation().content()).append(wsName).toPortableString();
            boolean isInitBundle = (Boolean)op.getProvisionLiferayBundle().content();
            if (isInitBundle) {
                String serverRuntimeName = (String)op.getServerName().content();
                IPath bundlesLocation = null;
                bundlesLocation = op.getProjectProvider().text().equals("gradle-liferay-workspace") ? LiferayWorkspaceUtil.getHomeLocation(location) : new Path(location).append("bundles");
                if (bundlesLocation.toFile().exists()) {
                    ServerUtil.addPortalRuntimeAndServer((String)serverRuntimeName, (IPath)bundlesLocation, (IProgressMonitor)monitor);
                }
            }
        }
        catch (Exception e) {
            String msg = "Error creating Liferay Workspace project.";
            ProjectCore.logError("Error creating Liferay Workspace project.", e);
            return Status.createErrorStatus((String)"Error creating Liferay Workspace project.", (Throwable)e);
        }
        if (retval.ok()) {
            NewLiferayWorkspaceOpMethods.updateBuildPrefs(op);
        }
        return retval;
    }

    private static void updateBuildPrefs(NewLiferayWorkspaceOp op) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.liferay.ide.project.core");
            prefs.put("project-workspace-default-build-type-option", op.getProjectProvider().text());
            prefs.flush();
        }
        catch (Exception e) {
            String msg = "Error updating default workspace build type.";
            ProjectCore.logError("Error updating default workspace build type.", e);
        }
    }
}

