/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.Problem;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.upgrade.FileProblems;
import com.liferay.ide.project.core.upgrade.IgnoredProblemsContainer;
import com.liferay.ide.project.core.upgrade.MigrationProblems;
import com.liferay.ide.project.core.upgrade.UpgradeAssistantSettingsUtil;
import com.liferay.ide.project.ui.migration.MigrationProblemsContainer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class MigrationUtil {
    public static IResource getIResourceFromProblem(Problem problem) {
        return MigrationUtil.getIResourceFromFile(problem.file);
    }

    public static IResource getIResourceFromFileProblems(FileProblems problem) {
        return MigrationUtil.getIResourceFromFile(problem.getFile());
    }

    public static IResource getIResourceFromFile(File f) {
        IFile[] files;
        IFile retval = null;
        IFile[] iFileArray = files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(f.toURI());
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (file.exists()) {
                if (retval == null) {
                    if (CoreUtil.isLiferayProject((IProject)file.getProject())) {
                        retval = file;
                    }
                } else if (file.getFullPath().segmentCount() < retval.getFullPath().segmentCount()) {
                    retval = file;
                }
            } else {
                IPath path = file.getFullPath();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(path.segmentCount() - 1));
                if (project.exists()) {
                    retval = project;
                }
            }
            ++n2;
        }
        return retval;
    }

    public static IResource getResourceFromMigrationProblems(MigrationProblems problems) {
        String projectName = problems.getSuffix();
        IProject project = CoreUtil.getWorkspaceRoot().getProject(projectName);
        if (project.exists()) {
            return project;
        }
        return null;
    }

    public static List<Problem> getResolvedProblemsFromResource(IResource resource) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers("com.liferay.ide.project.core.MigrationProblemMarker", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                Problem problem = MigrationUtil.markerToProblem(marker);
                if (problem != null && problem.getStatus() == 1) {
                    problems.add(problem);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return problems;
    }

    public static Problem getProblemFromSelection(ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof Problem) {
            return (Problem)element;
        }
        return null;
    }

    public static List<Problem> getProblemsFromSelection(ISelection selection) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object element : ss) {
                if (!(element instanceof Problem)) continue;
                problems.add((Problem)element);
            }
        }
        return problems;
    }

    public static List<Problem> getProblemsFromResource(IResource resource) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers("com.liferay.ide.project.core.MigrationProblemMarker", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                Problem problem = MigrationUtil.markerToProblem(marker);
                if (problem != null) {
                    problems.add(problem);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return problems;
    }

    public static List<Problem> getProblemsFromTreeNode(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator iterator = ss.iterator();
            ArrayList<Problem> allProblems = new ArrayList<Problem>();
            while (iterator.hasNext()) {
                int n;
                int n2;
                FileProblems[] fileProblemsArray;
                Object element = iterator.next();
                if (element instanceof FileProblems) {
                    FileProblems fp = (FileProblems)element;
                    allProblems.addAll(fp.getProblems());
                    continue;
                }
                if (element instanceof MigrationProblems) {
                    MigrationProblems migrationProblems = (MigrationProblems)element;
                    fileProblemsArray = migrationProblems.getProblems();
                    n2 = fileProblemsArray.length;
                    n = 0;
                    while (n < n2) {
                        FileProblems fProblems = fileProblemsArray[n];
                        allProblems.addAll(fProblems.getProblems());
                        ++n;
                    }
                    continue;
                }
                if (!(element instanceof MigrationProblemsContainer)) continue;
                MigrationProblemsContainer migrationProblemsContainer = (MigrationProblemsContainer)element;
                fileProblemsArray = migrationProblemsContainer.getProblemsArray();
                n2 = fileProblemsArray.length;
                n = 0;
                while (n < n2) {
                    FileProblems migrationProblems = fileProblemsArray[n];
                    FileProblems[] fileProblemsArray2 = migrationProblems.getProblems();
                    int n3 = fileProblemsArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        FileProblems fProblems = fileProblemsArray2[n4];
                        allProblems.addAll(fProblems.getProblems());
                        ++n4;
                    }
                    ++n;
                }
            }
            HashSet hashSet = new HashSet(allProblems);
            allProblems.clear();
            allProblems.addAll(hashSet);
            return allProblems;
        }
        return null;
    }

    public static List<Problem> getCurrentProblemsFromTreeNode(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator iterator = ss.iterator();
            ArrayList<Problem> notIgnoreProblems = new ArrayList<Problem>();
            while (iterator.hasNext()) {
                int n;
                FileProblems[] fileProblemsArray;
                Object element = iterator.next();
                if (element instanceof FileProblems) {
                    FileProblems fp = (FileProblems)element;
                    for (Problem problem : fp.getProblems()) {
                        if (problem.getStatus() == 2) continue;
                        notIgnoreProblems.add(problem);
                    }
                    continue;
                }
                if (element instanceof MigrationProblems) {
                    MigrationProblems migrationProblems = (MigrationProblems)element;
                    fileProblemsArray = migrationProblems.getProblems();
                    n = fileProblemsArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileProblems fProblems = fileProblemsArray[n2];
                        for (Problem problem : fProblems.getProblems()) {
                            if (problem.getStatus() == 2) continue;
                            notIgnoreProblems.add(problem);
                        }
                        ++n2;
                    }
                    continue;
                }
                if (!(element instanceof MigrationProblemsContainer)) continue;
                MigrationProblemsContainer migrationProblemsContainer = (MigrationProblemsContainer)element;
                fileProblemsArray = migrationProblemsContainer.getProblemsArray();
                n = fileProblemsArray.length;
                int n3 = 0;
                while (n3 < n) {
                    FileProblems migrationProblems = fileProblemsArray[n3];
                    FileProblems[] fileProblemsArray2 = migrationProblems.getProblems();
                    int n4 = fileProblemsArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        FileProblems fProblems = fileProblemsArray2[n5];
                        for (Problem problem : fProblems.getProblems()) {
                            if (problem.getStatus() == 2) continue;
                            notIgnoreProblems.add(problem);
                        }
                        ++n5;
                    }
                    ++n3;
                }
            }
            HashSet hashSet = new HashSet(notIgnoreProblems);
            notIgnoreProblems.clear();
            notIgnoreProblems.addAll(hashSet);
            return notIgnoreProblems;
        }
        return null;
    }

    public static Problem markerToProblem(IMarker marker) {
        String title = marker.getAttribute("message", "");
        String summary = marker.getAttribute("migrationProblem.summary", "");
        String type = marker.getAttribute("migrationProblem.type", "");
        String ticket = marker.getAttribute("migrationProblem.ticket", "");
        int lineNumber = marker.getAttribute("lineNumber", 0);
        int startOffset = marker.getAttribute("charStart", 0);
        int endOffset = marker.getAttribute("charEnd", 0);
        String html = marker.getAttribute("migrationProblem.html", "");
        String autoCorrectContext = marker.getAttribute("migrationProblem.autoCorrectContext", "");
        int status = marker.getAttribute("migrationProblem.status", 0);
        long markerId = marker.getId();
        File file = new File(marker.getResource().getLocationURI());
        return new Problem(UUID.randomUUID().toString(), title, summary, type, ticket, file, lineNumber, startOffset, endOffset, html, autoCorrectContext, status, markerId);
    }

    public static void openEditor(Problem problem) {
        try {
            IResource resource = MigrationUtil.getIResourceFromProblem(problem);
            if (resource instanceof IFile) {
                IMarker marker = MigrationUtil.getMarker(problem);
                if (marker != null) {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker, (boolean)OpenStrategy.activateOnOpen());
                } else {
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)resource));
                    if (editor instanceof ITextEditor) {
                        ITextEditor textEditor = (ITextEditor)editor;
                        textEditor.selectAndReveal(problem.startOffset, problem.endOffset - problem.startOffset);
                    }
                }
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public static void openEditor(FileProblems problem) {
        try {
            IResource resource = MigrationUtil.getIResourceFromFileProblems(problem);
            if (resource instanceof IFile) {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)resource));
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public static void updateMigrationProblemToStore(Problem problem) {
        File file = problem.getFile();
        try {
            MigrationProblemsContainer container = (MigrationProblemsContainer)UpgradeAssistantSettingsUtil.getObjectFromStore(MigrationProblemsContainer.class);
            boolean found = false;
            MigrationProblems[] migrationProblemsArray = container.getProblemsArray();
            int n = migrationProblemsArray.length;
            int n2 = 0;
            while (n2 < n) {
                MigrationProblems mp = migrationProblemsArray[n2];
                FileProblems[] fileProblemsArray = mp.getProblems();
                int n3 = fileProblemsArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    FileProblems fileProblem = fileProblemsArray[n4];
                    if (fileProblem.getFile().equals(file)) {
                        int i = 0;
                        while (i < fileProblem.getProblems().size()) {
                            Problem p = (Problem)fileProblem.getProblems().get(i);
                            if (p.equals((Object)problem)) {
                                fileProblem.getProblems().set(i, problem);
                                found = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (found) break;
                    ++n4;
                }
                if (found) break;
                ++n2;
            }
            UpgradeAssistantSettingsUtil.setObjectToStore(MigrationProblemsContainer.class, (Object)container);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void problemToMarker(Problem problem, IMarker marker) throws CoreException {
        marker.setAttribute("message", (Object)problem.title);
        marker.setAttribute("migrationProblem.summary", (Object)problem.summary);
        marker.setAttribute("migrationProblem.type", (Object)problem.type);
        marker.setAttribute("migrationProblem.ticket", (Object)problem.ticket);
        marker.setAttribute("lineNumber", problem.lineNumber);
        marker.setAttribute("charStart", problem.startOffset);
        marker.setAttribute("charEnd", problem.endOffset);
        marker.setAttribute("migrationProblem.status", problem.status);
        marker.setAttribute("migrationProblem.html", (Object)problem.html);
        marker.setAttribute("migrationProblem.autoCorrectContext", (Object)problem.getAutoCorrectContext());
        marker.setAttribute("location", (Object)problem.file.getName());
        marker.setAttribute("severity", 2);
    }

    public static boolean removeMigrationProblems(MigrationProblems migrationProblems) {
        MigrationProblemsContainer container = MigrationUtil.getMigrationProblemsContainer();
        return MigrationUtil.removeProblemFromMigrationContainer(migrationProblems.getSuffix(), container);
    }

    public static boolean removeMigrationProblemsFromResource(IResource resource) {
        MigrationProblemsContainer container = MigrationUtil.getMigrationProblemsContainer();
        return MigrationUtil.removeProblemFromMigrationContainer(resource.getName(), container);
    }

    public static IMarker getMarker(Problem problem) {
        try {
            return MigrationUtil.getIResourceFromProblem(problem).findMarker(problem.markerId);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static MigrationProblemsContainer getMigrationProblemsContainer() {
        try {
            return (MigrationProblemsContainer)UpgradeAssistantSettingsUtil.getObjectFromStore(MigrationProblemsContainer.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IgnoredProblemsContainer getIgnoredProblemsContainer() {
        try {
            return (IgnoredProblemsContainer)UpgradeAssistantSettingsUtil.getObjectFromStore(IgnoredProblemsContainer.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean removeProblemFromMigrationContainer(String projectName, MigrationProblemsContainer container) {
        boolean isRemoved = false;
        if (container != null) {
            ArrayList<MigrationProblems> problems = new ArrayList<MigrationProblems>(Arrays.asList(container.getProblemsArray()));
            for (MigrationProblems mp : problems) {
                if (!mp.getSuffix().equals(projectName)) continue;
                problems.remove(mp);
                isRemoved = true;
                break;
            }
            try {
                if (problems.size() != 0) {
                    container.setProblemsArray(problems.toArray(new MigrationProblems[0]));
                    UpgradeAssistantSettingsUtil.setObjectToStore(MigrationProblemsContainer.class, (Object)container);
                } else {
                    UpgradeAssistantSettingsUtil.setObjectToStore(MigrationProblemsContainer.class, null);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return isRemoved;
    }
}

