/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.modules.fragment.action;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.modules.fragment.OverrideFilePath;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sapphire.ElementList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class OSGiBundleFileSelectionDialog
extends ElementTreeSelectionDialog {
    private static ElementList<OverrideFilePath> files;
    protected static String projectName;

    static {
        projectName = "";
    }

    public OSGiBundleFileSelectionDialog(Shell parent, ElementList<OverrideFilePath> currentFiles, String projectName) {
        super(parent, (ILabelProvider)new FileLabelProvider(), (ITreeContentProvider)new FileContentProvider());
        files = currentFiles;
        OSGiBundleFileSelectionDialog.projectName = projectName;
        this.setComparator(new ViewerComparator());
    }

    protected static class FileContentProvider
    implements ITreeContentProvider {
        private final Object[] EMPTY = new Object[0];

        protected FileContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.EMPTY;
        }

        public Object[] getElements(Object element) {
            File file2;
            HashSet<String> possibleValues = new HashSet<String>();
            if (element instanceof File && (file2 = (File)element).exists()) {
                try {
                    Object object = null;
                    Object var5_7 = null;
                    try (JarFile jar = new JarFile(file2);){
                        Enumeration<JarEntry> enu = jar.entries();
                        while (enu.hasMoreElements()) {
                            JarEntry entry = enu.nextElement();
                            String name = entry.getName();
                            if ((!name.startsWith("META-INF/resources/") || !name.endsWith(".jsp") && !name.endsWith(".jspf")) && !name.equals("portlet.properties") && !name.equals("resource-actions/default.xml")) continue;
                            possibleValues.add(name);
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            for (File file2 : files) {
                String currentFile = (String)file2.getValue().content();
                possibleValues.remove(currentFile);
            }
            if (projectName != null) {
                IProject project = CoreUtil.getProject((String)projectName);
                IFolder javaFolder = project.getFolder("src/main/java");
                IFolder resourceFolder = project.getFolder("src/main/resources");
                Iterator it = possibleValues.iterator();
                while (it.hasNext()) {
                    String v = (String)it.next();
                    if (resourceFolder.getFile(v).exists()) {
                        it.remove();
                    }
                    if (!javaFolder.getFile("portlet-ext.properties").exists() || !v.equals("portlet.properties")) continue;
                    it.remove();
                }
            }
            return possibleValues.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected static class FileLabelProvider
    extends LabelProvider {
        private final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

        protected FileLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.IMG_FILE;
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

