/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.pref;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.pref.AbstractValidationSettingsPage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ScrolledPageContent;

public class PluginValidationSettingsPage
extends AbstractValidationSettingsPage {
    public static final String PROJECT_UI_PROPERTIES_PAGE_ID = "com.liferay.ide.project.ui.propertyPage.validation";
    public static final String VALIDATION_ID = "com.liferay.ide.project.ui.pluginValidationSettingsPage";
    protected static final Map<Integer, Integer> ERROR_MAP = new HashMap<Integer, Integer>();
    protected static final int[] ERROR_VALUES = new int[]{1, 2, -1};
    protected static final String[] ERRORS = new String[]{Msgs.error, Msgs.warning, Msgs.ignore};
    protected static final String SETTINGS_SECTION_NAME = "PluginValidationSeverities";
    protected PixelConverter pixelConverter;

    static {
        ERROR_MAP.put(2, 0);
        ERROR_MAP.put(1, 1);
        ERROR_MAP.put(0, 2);
    }

    public void dispose() {
        this.storeSectionExpansionStates(this.getDialogSettings().addNewSection(SETTINGS_SECTION_NAME));
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }

    @Override
    public boolean performOk() {
        boolean result = super.performOk();
        this.storeValues();
        return result;
    }

    protected Combo createCombo(Composite parent, String label, String key) {
        return this.addComboBox(parent, label, key, ERROR_VALUES, ERRORS, 0);
    }

    @Override
    protected Control createCommonContents(Composite composite) {
        Composite page = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        page.setLayout((Layout)layout);
        this.pixelConverter = new PixelConverter((Control)composite);
        Composite content = this.createValidationSection(page);
        this.loadPreferences();
        this.restoreSectionExpansionStates(this.getDialogSettings().getSection(SETTINGS_SECTION_NAME));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.pixelConverter.convertHeightInCharsToPixels(20);
        content.setLayoutData((Object)gridData);
        return page;
    }

    protected Composite createValidationSection(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        pageContent.setLayoutData((Object)new GridData(1808));
        pageContent.setExpandHorizontal(true);
        pageContent.setExpandVertical(true);
        Composite body = pageContent.getBody();
        body.setLayout((Layout)layout);
        body.setBackground(parent.getBackground());
        GridData gd = new GridData(4, 2, true, false, 2, 1);
        gd.horizontalIndent = 0;
        Label description = new Label(body, 0);
        description.setText(Msgs.selectSeverityLevel);
        description.setFont(pageContent.getFont());
        description.setLayoutData((Object)gd);
        int columns = 3;
        ExpandableComposite twistie = this.createTwistie(body, Msgs.portletXMLDescriptor, columns);
        twistie.setBackground(parent.getBackground());
        Composite inner = this.createInnerComposite(parent, twistie, columns);
        this.createCombo(inner, Msgs.syntaxInvalid, "portlet-xml-syntax-invalid");
        this.createCombo(inner, Msgs.typeNotFound, "portlet-xml-type-not-found");
        this.createCombo(inner, Msgs.typeHierarchyIncorrect, "portlet-xml-type-hierarchy-incorrect");
        this.createCombo(inner, Msgs.resourceNotFound, "portlet-xml-resource-not-found");
        this.createCombo(inner, Msgs.referenceNotFound, "portlet-xml-reference-not-found");
        twistie = this.createTwistie(body, Msgs.serviceXMLDescriptor, columns);
        twistie.setBackground(parent.getBackground());
        inner = this.createInnerComposite(parent, twistie, columns);
        this.createCombo(inner, Msgs.syntaxInvalid, "service-xml-syntax-invalid");
        this.createCombo(inner, Msgs.typeNotFound, "service-xml-type-not-found");
        this.createCombo(inner, Msgs.typeHierarchyIncorrect, "service-xml-type-hierarchy-incorrect");
        this.createCombo(inner, Msgs.resourceNotFound, "service-xml-resource-not-found");
        this.createCombo(inner, Msgs.referenceNotFound, "service-xml-reference-not-found");
        twistie = this.createTwistie(body, Msgs.liferayPortletXMLDescriptor, columns);
        twistie.setBackground(parent.getBackground());
        inner = this.createInnerComposite(parent, twistie, columns);
        this.createCombo(inner, Msgs.syntaxInvalid, "liferay-portlet-xml-syntax-invalid");
        this.createCombo(inner, Msgs.typeNotFound, "liferay-portlet-xml-type-not-found");
        this.createCombo(inner, Msgs.typeHierarchyIncorrect, "liferay-portlet-xml-type-hierarchy-incorrect");
        this.createCombo(inner, Msgs.resourceNotFound, "liferay-portlet-xml-resource-not-found");
        this.createCombo(inner, Msgs.referenceNotFound, "liferay-portlet-xml-reference-not-found");
        twistie = this.createTwistie(body, Msgs.liferayHookXMLDescriptor, columns);
        twistie.setBackground(parent.getBackground());
        inner = this.createInnerComposite(parent, twistie, columns);
        this.createCombo(inner, Msgs.syntaxInvalid, "liferay-hook-xml-syntax-invalid");
        this.createCombo(inner, Msgs.typeNotFound, "liferay-hook-xml-type-not-found");
        this.createCombo(inner, Msgs.typeHierarchyIncorrect, "liferay-hook-xml-type-hierarchy-incorrect");
        this.createCombo(inner, Msgs.resourceNotFound, "liferay-hook-xml-resource-not-found");
        this.createCombo(inner, Msgs.referenceNotFound, "liferay-hook-xml-reference-not-found");
        twistie = this.createTwistie(body, Msgs.liferayDisplayXMLDescriptor, columns);
        twistie.setBackground(parent.getBackground());
        inner = this.createInnerComposite(parent, twistie, columns);
        this.createCombo(inner, Msgs.syntaxInvalid, "liferay-display-xml-syntax-invalid");
        this.createCombo(inner, Msgs.typeNotFound, "liferay-display-xml-type-not-found");
        this.createCombo(inner, Msgs.typeHierarchyIncorrect, "liferay-display-xml-type-hierarchy-incorrect");
        this.createCombo(inner, Msgs.resourceNotFound, "liferay-display-xml-resource-not-found");
        this.createCombo(inner, Msgs.referenceNotFound, "liferay-display-xml-reference-not-found");
        twistie = this.createTwistie(body, Msgs.liferayLayoutTemplatesDescriptor, columns);
        twistie.setBackground(parent.getBackground());
        inner = this.createInnerComposite(parent, twistie, columns);
        this.createCombo(inner, Msgs.syntaxInvalid, "liferay-layout-templates-xml-syntax-invalid");
        this.createCombo(inner, Msgs.typeNotFound, "liferay-layout-templates-xml-type-not-found");
        this.createCombo(inner, Msgs.typeHierarchyIncorrect, "liferay-layout-templates-xml-type-hierarchy-incorrect");
        this.createCombo(inner, Msgs.resourceNotFound, "liferay-layout-templates-xml-resource-not-found");
        this.createCombo(inner, Msgs.referenceNotFound, "liferay-layout-templates-xml-reference-not-found");
        twistie = this.createTwistie(body, Msgs.liferayJspFiles, columns);
        twistie.setBackground(parent.getBackground());
        inner = this.createInnerComposite(parent, twistie, columns);
        this.createCombo(inner, Msgs.syntaxInvalid, "liferay-jsp-syntax-value_invalid");
        this.createCombo(inner, Msgs.typeNotFound, "liferay-jsp-type-not-found");
        this.createCombo(inner, Msgs.typeHierarchyIncorrect, "liferay-jsp-hierarchy-incorrect");
        this.createCombo(inner, Msgs.methodNotFound, "liferay-jsp-method-not-found");
        this.createCombo(inner, Msgs.resourceNotFound, "liferya-jsp-resource-not-found");
        this.createCombo(inner, Msgs.referenceNotFound, "liferay-jsp-reference-not-found");
        this.createCombo(inner, Msgs.propertyNotFound, "liferay-jsp--property-not-found");
        this.createCombo(inner, Msgs.staticValueUndefined, "liferay-jsp-static-value-undefined");
        return parent;
    }

    protected void enableValues() {
    }

    protected IDialogSettings getDialogSettings() {
        return ProjectUI.getDefault().getDialogSettings();
    }

    @Override
    protected String getPreferenceNodeQualifier() {
        return "com.liferay.ide.project.core";
    }

    @Override
    protected String getPreferencePageID() {
        return VALIDATION_ID;
    }

    @Override
    protected String getProjectSettingsKey() {
        return "use-project-settings";
    }

    @Override
    protected String getPropertyPageID() {
        return PROJECT_UI_PROPERTIES_PAGE_ID;
    }

    protected String getQualifier() {
        return ProjectCore.getDefault().getBundle().getSymbolicName();
    }

    protected void initializeValues() {
    }

    protected boolean loadPreferences() {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                PluginValidationSettingsPage.this.initializeValues();
                PluginValidationSettingsPage.this.validateValues();
                PluginValidationSettingsPage.this.enableValues();
            }
        });
        return true;
    }

    @Override
    protected void performDefaults() {
        this.resetSeverities();
        super.performDefaults();
    }

    protected void validateValues() {
        String errorMessage = null;
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
    }

    private static class Msgs
    extends NLS {
        public static String typeNotFound;
        public static String typeHierarchyIncorrect;
        public static String referenceNotFound;
        public static String resourceNotFound;
        public static String syntaxInvalid;
        public static String propertyNotFound;
        public static String methodNotFound;
        public static String staticValueUndefined;
        public static String error;
        public static String ignore;
        public static String warning;
        public static String liferayDisplayXMLDescriptor;
        public static String liferayHookXMLDescriptor;
        public static String liferayLayoutTemplatesDescriptor;
        public static String liferayPortletXMLDescriptor;
        public static String portletXMLDescriptor;
        public static String serviceXMLDescriptor;
        public static String liferayJspFiles;
        public static String selectSeverityLevel;

        static {
            Msgs.initializeMessages((String)PluginValidationSettingsPage.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

