/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.upgrade.CodeUpgradeOp;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.dialog.JavaProjectSelectionDialog;
import com.liferay.ide.project.ui.upgrade.LiferayUpgradeCompare;
import com.liferay.ide.project.ui.wizard.ElementLabelProvider;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public abstract class AbstractLiferayTableViewCustomPart
extends FormComponentPart {
    protected Status retval = Status.createOkStatus();
    protected TableViewer tableViewer;
    private LiferayUpgradeElement[] tableViewElements;

    protected abstract boolean isNeedUpgrade(File var1);

    public static IPath getTempLocation(String prefix, String fileName) {
        return ProjectUI.getDefault().getStateLocation().append("tmp").append(String.valueOf(prefix) + "/" + System.currentTimeMillis() + (CoreUtil.isNullOrEmpty((String)fileName) ? "" : "/" + fileName));
    }

    protected abstract void createTempFile(File var1, File var2, String var3);

    protected abstract void doUpgrade(File var1, IProject var2);

    protected abstract IFile[] getAvaiableUpgradeFiles(IProject var1);

    protected abstract DelegatingStyledCellLabelProvider.IStyledLabelProvider getLableProvider();

    protected Status computeValidation() {
        return this.retval;
    }

    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        return new FormComponentPresentation(this, parent, composite){

            public void render() {
                Composite parent = SWTUtil.createComposite((Composite)this.composite(), (int)2, (int)2, (int)1808);
                AbstractLiferayTableViewCustomPart.this.tableViewer = new TableViewer(parent);
                AbstractLiferayTableViewCustomPart.this.tableViewer.setContentProvider((IContentProvider)new TableViewContentProvider());
                AbstractLiferayTableViewCustomPart.this.tableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider(AbstractLiferayTableViewCustomPart.this.getLableProvider()));
                AbstractLiferayTableViewCustomPart.this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                    public void doubleClick(DoubleClickEvent event) {
                        AbstractLiferayTableViewCustomPart.this.handleCompare((IStructuredSelection)event.getSelection());
                    }
                });
                Table table = AbstractLiferayTableViewCustomPart.this.tableViewer.getTable();
                GridData tableData = new GridData(4, 4, true, true, 1, 4);
                tableData.heightHint = 225;
                tableData.widthHint = 400;
                table.setLayoutData((Object)tableData);
                Button selectAllButton = new Button(parent, 0);
                selectAllButton.setText("Find...");
                selectAllButton.setLayoutData((Object)new GridData(4, 128, false, false));
                selectAllButton.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        AbstractLiferayTableViewCustomPart.this.handleFindEvent();
                    }
                });
                Button upgradeButton = new Button(parent, 0);
                upgradeButton.setText("Upgrade...");
                upgradeButton.setLayoutData((Object)new GridData(4, 128, false, false));
                upgradeButton.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        AbstractLiferayTableViewCustomPart.this.handleUpgradeEvent();
                    }
                });
            }
        };
    }

    private IPath createPreviewerFile(String projectName, IPath srcFilePath, String location) {
        IPath templateLocation = AbstractLiferayTableViewCustomPart.getTempLocation(projectName, srcFilePath.lastSegment());
        templateLocation.toFile().getParentFile().mkdirs();
        try {
            this.createTempFile(new File(location), templateLocation.toFile(), projectName);
        }
        catch (Exception e) {
            ProjectCore.logError((Throwable)e);
        }
        return templateLocation;
    }

    private List<LiferayUpgradeElement> getInitItemsList(List<IProject> projects, IProgressMonitor monitor) {
        ArrayList<LiferayUpgradeElement> tableViewElementList = new ArrayList<LiferayUpgradeElement>();
        Path sdkLocation = (Path)this.op().getNewLocation().content();
        String context = null;
        int count = projects.size();
        if (count <= 0) {
            return tableViewElementList;
        }
        int unit = 100 / count;
        monitor.beginTask("Find needed upgrade file......", 100);
        int i = 0;
        while (i < count) {
            IFile[] upgradeFiles;
            monitor.worked(i + 1 * unit);
            if (i == count - 1) {
                monitor.worked(100);
            }
            IProject project = projects.get(i);
            monitor.setTaskName("Finding needed upgrade file for " + project.getName());
            IFile[] iFileArray = upgradeFiles = this.getAvaiableUpgradeFiles(project);
            int n = upgradeFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile upgradeFilePath = iFileArray[n2];
                IPath filePath = upgradeFilePath.getLocation();
                if (this.isNeedUpgrade(filePath.toFile())) {
                    String projectLocation = filePath.makeRelativeTo(PathBridge.create((Path)sdkLocation)).toPortableString();
                    context = String.valueOf(filePath.lastSegment()) + " (" + project.getName() + " - Location: " + projectLocation + ")";
                    LiferayUpgradeElement tableViewElement = new LiferayUpgradeElement(project.getName(), context, filePath.toPortableString(), filePath.lastSegment());
                    tableViewElementList.add(tableViewElement);
                }
                ++n2;
            }
            ++i;
        }
        return tableViewElementList;
    }

    protected List<IProject> getSelectedProjects() {
        Object[] selectedProjects;
        ArrayList<IProject> projects = new ArrayList<IProject>();
        JavaProjectSelectionDialog dialog = new JavaProjectSelectionDialog(Display.getCurrent().getActiveShell());
        if (dialog.open() == 0 && (selectedProjects = dialog.getResult()) != null) {
            Object[] objectArray = selectedProjects;
            int n = selectedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object project = objectArray[n2];
                if (project instanceof IJavaProject) {
                    IJavaProject p = (IJavaProject)project;
                    projects.add(p.getProject());
                }
                ++n2;
            }
        }
        return projects;
    }

    private void handleCompare(IStructuredSelection selection) {
        LiferayUpgradeElement descriptorElement = (LiferayUpgradeElement)selection.getFirstElement();
        String projectName = descriptorElement.name;
        String itemName = descriptorElement.itemName;
        String srcFileLocation = descriptorElement.location;
        IPath srcFileIPath = PathBridge.create((Path)new Path(srcFileLocation));
        IPath createPreviewerFile = this.createPreviewerFile(projectName, srcFileIPath, srcFileLocation);
        LiferayUpgradeCompare lifeayDescriptorUpgradeCompre = new LiferayUpgradeCompare(srcFileIPath, createPreviewerFile, itemName);
        lifeayDescriptorUpgradeCompre.openCompareEditor();
    }

    private void handleFindEvent() {
        final List<IProject> projects = this.getSelectedProjects();
        try {
            WorkspaceJob workspaceJob = new WorkspaceJob("Find needed upgrade files......"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    List tableViewElementList = AbstractLiferayTableViewCustomPart.this.getInitItemsList(projects, monitor);
                    AbstractLiferayTableViewCustomPart.this.tableViewElements = tableViewElementList.toArray(new LiferayUpgradeElement[tableViewElementList.size()]);
                    UIUtil.async((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).AbstractLiferayTableViewCustomPart.this.tableViewer.setInput((Object)AbstractLiferayTableViewCustomPart.this.tableViewElements);
                        }
                    });
                    return StatusBridge.create((Status)Status.createOkStatus());
                }
            };
            workspaceJob.setUser(true);
            workspaceJob.schedule();
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }

    private void handleUpgradeEvent() {
        try {
            WorkspaceJob workspaceJob = new WorkspaceJob("Find needed upgrade files......"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    int count = AbstractLiferayTableViewCustomPart.this.tableViewElements.length;
                    if (count <= 0) {
                        return StatusBridge.create((Status)Status.createOkStatus());
                    }
                    int unit = 100 / count;
                    monitor.beginTask("Start to upgrade files.....", 100);
                    int i = 0;
                    while (i < count) {
                        monitor.worked(i + 1 * unit);
                        if (i == count - 1) {
                            monitor.worked(100);
                        }
                        final LiferayUpgradeElement tableViewElement = AbstractLiferayTableViewCustomPart.this.tableViewElements[i];
                        String srcFileLocation = tableViewElement.location;
                        String projectName = tableViewElement.name;
                        monitor.setTaskName("Upgrading files for " + projectName);
                        try {
                            IProject project = ProjectUtil.getProject((String)projectName);
                            AbstractLiferayTableViewCustomPart.this.doUpgrade(new File(srcFileLocation), project);
                            if (project != null) {
                                project.refreshLocal(2, monitor);
                            }
                            final int loopNum = i;
                            UIUtil.async((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    tableViewElement.context = String.valueOf(tableViewElement.context) + "( Finished )";
                                    ((AbstractLiferayTableViewCustomPart)(this).AbstractLiferayTableViewCustomPart.this).tableViewElements[loopNum] = tableViewElement;
                                    (this).AbstractLiferayTableViewCustomPart.this.tableViewer.setInput((Object)AbstractLiferayTableViewCustomPart.this.tableViewElements);
                                    (this).AbstractLiferayTableViewCustomPart.this.tableViewer.refresh();
                                }
                            });
                        }
                        catch (Exception e) {
                            ProjectCore.logError((String)"Error upgrade files...... ", (Exception)e);
                        }
                        ++i;
                    }
                    return StatusBridge.create((Status)Status.createOkStatus());
                }
            };
            workspaceJob.setUser(true);
            workspaceJob.schedule();
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }

    private CodeUpgradeOp op() {
        return (CodeUpgradeOp)this.getLocalModelElement().nearest(CodeUpgradeOp.class);
    }

    public class LiferayUpgradeElement {
        public String name;
        public String context;
        public final String location;
        public final String itemName;

        public LiferayUpgradeElement(String name, String context, String location, String itemName) {
            this.context = context;
            this.name = name;
            this.location = location;
            this.itemName = itemName;
        }
    }

    protected abstract class LiferayUpgradeTabeViewLabelProvider
    extends ElementLabelProvider
    implements IColorProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private String GREY_COLOR;
        private final ColorRegistry COLOR_REGISTRY = JFaceResources.getColorRegistry();
        protected StyledString.Styler GREYED_STYLER;

        public LiferayUpgradeTabeViewLabelProvider() {
            this.COLOR_REGISTRY.put(this.GREY_COLOR, new RGB(128, 128, 128));
            this.GREYED_STYLER = StyledString.createColorRegistryStyler((String)this.GREY_COLOR, null);
        }

        public LiferayUpgradeTabeViewLabelProvider(String greyColorName) {
            this.GREY_COLOR = greyColorName;
        }

        @Override
        public Color getForeground(Object element) {
            String srcLableString;
            if (element instanceof LiferayUpgradeElement && (srcLableString = ((LiferayUpgradeElement)element).context).contains("Finished")) {
                return Display.getCurrent().getSystemColor(9);
            }
            return Display.getCurrent().getSystemColor(2);
        }

        @Override
        public StyledString getStyledText(Object element) {
            if (element instanceof LiferayUpgradeElement) {
                String srcLableString = ((LiferayUpgradeElement)element).context;
                String elementName = ((LiferayUpgradeElement)element).name;
                StyledString styled = new StyledString(elementName);
                return StyledCellLabelProvider.styleDecoratedString((String)srcLableString, (StyledString.Styler)this.GREYED_STYLER, (StyledString)styled);
            }
            return new StyledString(((LiferayUpgradeElement)element).context);
        }
    }

    protected class TableViewContentProvider
    implements IStructuredContentProvider {
        protected TableViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof LiferayUpgradeElement[]) {
                return (LiferayUpgradeElement[])inputElement;
            }
            return new Object[]{inputElement};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

