/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.action;

import com.liferay.ide.core.ILiferayProjectImporter;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.IOUtil;
import com.liferay.ide.core.util.ZipUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.BladeCLI;
import com.liferay.ide.project.core.modules.BladeCLIException;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.upgrade.action.BaseActionHandler;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;

public class ImportProjectActionHandler
extends BaseActionHandler {
    private static String newPath = "";

    protected Object run(final Presentation context) {
        final String layout = (String)this.op(context).getLayout().content();
        final IPath location = PathBridge.create((org.eclipse.sapphire.modeling.Path)((org.eclipse.sapphire.modeling.Path)this.op(context).getSdkLocation().content()));
        final String projectName = (String)this.op(context).getProjectName().content();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ImportProjectActionHandler.this.copyNewSDK(location, monitor);
                        ImportProjectActionHandler.this.clearWorkspaceSDKAndProjects(location, monitor);
                        if (layout.equals("Use plugin sdk in liferay workspace")) {
                            ImportProjectActionHandler.this.createLiferayWorkspace(location, monitor);
                            newPath = ImportProjectActionHandler.this.renameProjectFolder(location, projectName, monitor);
                            ILiferayProjectImporter importer = LiferayCore.getImporter((String)"gradle");
                            importer.importProjects(newPath, monitor);
                            ImportProjectActionHandler.this.importSDKProject(new Path(newPath).append("plugins-sdk"), monitor);
                        } else {
                            String serverName = (String)ImportProjectActionHandler.this.op(context).getLiferayServerName().content();
                            IServer server = ServerUtil.getServer((String)serverName);
                            IPath serverPath = server.getRuntime().getLocation();
                            SDK sdk = new SDK(location);
                            sdk.addOrUpdateServerProperties(serverPath);
                            newPath = ImportProjectActionHandler.this.renameProjectFolder(location, projectName, monitor);
                            sdk = SDKUtil.createSDKFromLocation((IPath)new Path(newPath));
                            SDKUtil.openAsProject((SDK)sdk, (IProgressMonitor)monitor);
                            ImportProjectActionHandler.this.importSDKProject(sdk.getLocation(), monitor);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.op(context).setNewLocation(newPath);
        newPath = "";
        return null;
    }

    private void clearWorkspaceSDKAndProjects(IPath targetSDKLocation, IProgressMonitor monitor) throws CoreException {
        IProject sdkProject = SDKUtil.getWorkspaceSDKProject();
        if (sdkProject != null && sdkProject.getLocation().equals((Object)targetSDKLocation)) {
            IProject[] projects;
            IProject[] iProjectArray = projects = ProjectUtil.getAllPluginsSDKProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                project.delete(false, true, monitor);
                ++n2;
            }
            sdkProject.delete(false, true, monitor);
        }
    }

    private void copyNewSDK(IPath targetSDKLocation, IProgressMonitor monitor) throws IOException {
        URL sdkZipUrl = Platform.getBundle((String)"com.liferay.ide.project.ui").getEntry("resources/sdk70ga2.zip");
        File sdkZipFile = new File(FileLocator.toFileURL((URL)sdkZipUrl).getFile());
        IPath stateLocation = ProjectCore.getDefault().getStateLocation();
        File stateDir = stateLocation.toFile();
        ZipUtil.unzip((File)sdkZipFile, (File)stateDir);
        IOUtil.copyDirToDir((File)new File(stateDir, "com.liferay.portal.plugins.sdk-7.0"), (File)targetSDKLocation.toFile());
    }

    private void createLiferayWorkspace(IPath targetSDKLocation, IProgressMonitor monitor) throws BladeCLIException {
        StringBuilder sb = new StringBuilder();
        sb.append("-b ");
        sb.append("\"" + targetSDKLocation.toFile().getAbsolutePath() + "\" ");
        sb.append("init");
        BladeCLI.execute((String)sb.toString());
    }

    private String renameProjectFolder(IPath targetSDKLocation, String newName, IProgressMonitor monitor) {
        if (newName == null || newName.equals("")) {
            return targetSDKLocation.toString();
        }
        File newFolder = targetSDKLocation.removeLastSegments(1).append(newName).toFile();
        targetSDKLocation.toFile().renameTo(newFolder);
        return newFolder.toPath().toString();
    }

    private void importSDKProject(IPath targetSDKLocation, IProgressMonitor monitor) {
        ArrayList eclipseProjectFiles = new ArrayList();
        ArrayList liferayProjectDirs = new ArrayList();
        if (ProjectUtil.collectSDKProjectsFromDirectory(eclipseProjectFiles, liferayProjectDirs, (File)targetSDKLocation.toFile(), null, (boolean)true, (IProgressMonitor)monitor)) {
            IProject importProject2;
            for (File project : liferayProjectDirs) {
                try {
                    importProject2 = ProjectImportUtil.importProject((IPath)new Path(project.getPath()), (IProgressMonitor)monitor, null);
                    if (!ProjectUtil.isExtProject((IProject)importProject2) && !ProjectUtil.isThemeProject((IProject)importProject2) && !importProject2.getName().startsWith("resources-importer-web")) continue;
                    importProject2.delete(false, true, monitor);
                }
                catch (CoreException importProject2) {
                    // empty catch block
                }
            }
            for (File project : eclipseProjectFiles) {
                try {
                    importProject2 = ProjectImportUtil.importProject((IPath)new Path(project.getParent()), (IProgressMonitor)monitor, null);
                    if (!ProjectUtil.isExtProject((IProject)importProject2) && !ProjectUtil.isThemeProject((IProject)importProject2) && !importProject2.getName().startsWith("resources-importer-web")) continue;
                    importProject2.delete(false, true, monitor);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }
}

