/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.util.ValidationUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.dialog.JavaProjectSelectionDialog;
import com.liferay.ide.project.ui.upgrade.LiferayUpgradeCompare;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.project.ui.upgrade.animated.PageValidateEvent;
import com.liferay.ide.project.ui.upgrade.animated.UpgradeView;
import com.liferay.ide.project.ui.wizard.ElementLabelProvider;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ValuePropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractLiferayTableViewCustomPart
extends Page {
    protected Status retval = Status.createOkStatus();
    protected TableViewer tableViewer;
    private LiferayUpgradeElement[] tableViewElements;

    public AbstractLiferayTableViewCustomPart(Composite parent, int style, LiferayUpgradeDataModel dataModel, String pageId, boolean hasFinishAndSkipAction) {
        super(parent, style, dataModel, pageId, hasFinishAndSkipAction);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData descData = new GridData(1808);
        descData.grabExcessVerticalSpace = true;
        descData.grabExcessHorizontalSpace = true;
        this.setLayoutData(descData);
        this.tableViewer = new TableViewer((Composite)this);
        this.tableViewer.setContentProvider((IContentProvider)new TableViewContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider(this.getLableProvider()));
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractLiferayTableViewCustomPart.this.handleCompare((IStructuredSelection)event.getSelection());
            }
        });
        Table table = this.tableViewer.getTable();
        GridData tableData = new GridData(1808);
        tableData.grabExcessVerticalSpace = true;
        tableData.grabExcessHorizontalSpace = true;
        tableData.horizontalAlignment = 4;
        table.setLayoutData((Object)tableData);
        Composite buttonContainer = new Composite((Composite)this, 0);
        buttonContainer.setLayout((Layout)new GridLayout(1, false));
        buttonContainer.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        Button upgradeButton = new Button(buttonContainer, 0);
        upgradeButton.setText("Upgrade...");
        upgradeButton.setLayoutData((Object)new GridData(4, 128, false, false));
        upgradeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractLiferayTableViewCustomPart.this.handleUpgradeEvent();
            }
        });
        dataModel.getImportFinished().attach((org.eclipse.sapphire.Listener)new LiferayUpgradeValidationListener());
    }

    protected abstract boolean isNeedUpgrade(File var1);

    public static IPath getTempLocation(String prefix, String fileName) {
        return ProjectUI.getDefault().getStateLocation().append("tmp").append(String.valueOf(prefix) + "/" + System.currentTimeMillis() + (CoreUtil.isNullOrEmpty((String)fileName) ? "" : "/" + fileName));
    }

    protected abstract void createTempFile(File var1, File var2, String var3);

    protected abstract void doUpgrade(File var1, IProject var2);

    protected abstract IFile[] getAvaiableUpgradeFiles(IProject var1);

    protected abstract DelegatingStyledCellLabelProvider.IStyledLabelProvider getLableProvider();

    private IPath createPreviewerFile(String projectName, IPath srcFilePath, String location) {
        IPath templateLocation = AbstractLiferayTableViewCustomPart.getTempLocation(projectName, srcFilePath.lastSegment());
        templateLocation.toFile().getParentFile().mkdirs();
        try {
            this.createTempFile(new File(location), templateLocation.toFile(), projectName);
        }
        catch (Exception e) {
            ProjectCore.logError((Throwable)e);
        }
        return templateLocation;
    }

    private List<LiferayUpgradeElement> getInitItemsList(List<IProject> projects, IProgressMonitor monitor) {
        ArrayList<LiferayUpgradeElement> tableViewElementList = new ArrayList<LiferayUpgradeElement>();
        String context = null;
        int count = projects.size();
        if (count <= 0) {
            return tableViewElementList;
        }
        int unit = 100 / count;
        monitor.beginTask("Find needed upgrade file......", 100);
        int i = 0;
        while (i < count) {
            IFile[] upgradeFiles;
            monitor.worked(i + 1 * unit);
            if (i == count - 1) {
                monitor.worked(100);
            }
            IProject project = projects.get(i);
            monitor.setTaskName("Finding needed upgrade file for " + project.getName());
            IFile[] iFileArray = upgradeFiles = this.getAvaiableUpgradeFiles(project);
            int n = upgradeFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile upgradeFilePath = iFileArray[n2];
                IPath filePath = upgradeFilePath.getLocation();
                if (!ValidationUtil.isProjectTargetDirFile((File)filePath.toFile()) && this.isNeedUpgrade(filePath.toFile())) {
                    String projectLocation = filePath.makeRelativeTo(project.getLocation()).toPortableString();
                    context = String.valueOf(filePath.lastSegment()) + " (" + project.getName() + " - Location: " + projectLocation + ")";
                    LiferayUpgradeElement tableViewElement = new LiferayUpgradeElement(project.getName(), context, filePath.toPortableString(), filePath.lastSegment());
                    tableViewElementList.add(tableViewElement);
                }
                ++n2;
            }
            ++i;
        }
        i = 0;
        while (i < tableViewElementList.size() - 1) {
            int j = tableViewElementList.size() - 1;
            while (j > i) {
                if (((LiferayUpgradeElement)tableViewElementList.get((int)j)).location.equals(((LiferayUpgradeElement)tableViewElementList.get((int)i)).location)) {
                    tableViewElementList.remove(j);
                }
                --j;
            }
            ++i;
        }
        return tableViewElementList;
    }

    protected List<IProject> getSelectedProjects() {
        Object[] selectedProjects;
        ArrayList<IProject> projects = new ArrayList<IProject>();
        JavaProjectSelectionDialog dialog = new JavaProjectSelectionDialog(Display.getCurrent().getActiveShell());
        if (dialog.open() == 0 && (selectedProjects = dialog.getResult()) != null) {
            Object[] objectArray = selectedProjects;
            int n = selectedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object project = objectArray[n2];
                if (project instanceof IJavaProject) {
                    IJavaProject p = (IJavaProject)project;
                    projects.add(p.getProject());
                }
                ++n2;
            }
        }
        return projects;
    }

    private void handleCompare(IStructuredSelection selection) {
        LiferayUpgradeElement descriptorElement = (LiferayUpgradeElement)selection.getFirstElement();
        String projectName = descriptorElement.name;
        String itemName = descriptorElement.itemName;
        String srcFileLocation = descriptorElement.location;
        IPath srcFileIPath = PathBridge.create((Path)new Path(srcFileLocation));
        IPath createPreviewerFile = this.createPreviewerFile(projectName, srcFileIPath, srcFileLocation);
        LiferayUpgradeCompare lifeayDescriptorUpgradeCompre = new LiferayUpgradeCompare(srcFileIPath, createPreviewerFile, itemName);
        lifeayDescriptorUpgradeCompre.openCompareEditor();
    }

    private List<IProject> getAvaiableProject(IProject[] projectArrys) {
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        IProject[] iProjectArray = projectArrys;
        int n = projectArrys.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (CoreUtil.isLiferayProject((IProject)project) && !LiferayWorkspaceUtil.isValidWorkspace((IProject)project) && (ProjectUtil.isHookProject((IProject)project) || ProjectUtil.isLayoutTplProject((IProject)project) || ProjectUtil.isWebProject((IProject)project) || ProjectUtil.isPortletProject((IProject)project))) {
                projectList.add(project);
            }
            ++n2;
        }
        return projectList;
    }

    private void handleFindEvent() {
        IProject[] projectArrys = CoreUtil.getAllProjects();
        final List<IProject> projectList = this.getAvaiableProject(projectArrys);
        try {
            WorkspaceJob workspaceJob = new WorkspaceJob("Find needed upgrade files......"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    List tableViewElementList = AbstractLiferayTableViewCustomPart.this.getInitItemsList(projectList, monitor);
                    AbstractLiferayTableViewCustomPart.this.tableViewElements = tableViewElementList.toArray(new LiferayUpgradeElement[tableViewElementList.size()]);
                    UIUtil.async((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String message = "ok";
                            (this).AbstractLiferayTableViewCustomPart.this.tableViewer.setInput((Object)AbstractLiferayTableViewCustomPart.this.tableViewElements);
                            if (AbstractLiferayTableViewCustomPart.this.tableViewElements.length < 1) {
                                message = "No file needs to be upgraded";
                            }
                            PageValidateEvent pe = new PageValidateEvent();
                            pe.setMessage(message);
                            pe.setType(PageValidateEvent.WARNING);
                            AbstractLiferayTableViewCustomPart.this.triggerValidationEvent(pe);
                        }
                    });
                    return StatusBridge.create((Status)Status.createOkStatus());
                }
            };
            workspaceJob.setUser(true);
            workspaceJob.schedule();
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }

    private void handleUpgradeEvent() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int count;
                    int n = count = AbstractLiferayTableViewCustomPart.this.tableViewElements != null ? AbstractLiferayTableViewCustomPart.this.tableViewElements.length : 0;
                    if (count == 0) {
                        UIUtil.async((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                String message = "No files that need to be upgraded were found.";
                                PageValidateEvent pe = new PageValidateEvent();
                                pe.setMessage(message);
                                pe.setType(PageValidateEvent.WARNING);
                                AbstractLiferayTableViewCustomPart.this.triggerValidationEvent(pe);
                            }
                        });
                        return;
                    }
                    int unit = 100 / count;
                    monitor.beginTask("Start to upgrade files.....", 100);
                    int i = 0;
                    while (i < count) {
                        monitor.worked(i + 1 * unit);
                        if (i == count - 1) {
                            monitor.worked(100);
                        }
                        final LiferayUpgradeElement tableViewElement = AbstractLiferayTableViewCustomPart.this.tableViewElements[i];
                        String srcFileLocation = tableViewElement.location;
                        String projectName = tableViewElement.name;
                        String context = tableViewElement.context;
                        monitor.setTaskName("Upgrading files for " + projectName);
                        if (!context.contains("Finished")) {
                            try {
                                IProject project = ProjectUtil.getProject((String)projectName);
                                AbstractLiferayTableViewCustomPart.this.doUpgrade(new File(srcFileLocation), project);
                                if (project != null) {
                                    project.refreshLocal(2, monitor);
                                }
                                final int loopNum = i;
                                UIUtil.async((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        tableViewElement.context = String.valueOf(tableViewElement.context) + "( Finished )";
                                        ((AbstractLiferayTableViewCustomPart)(this).AbstractLiferayTableViewCustomPart.this).tableViewElements[loopNum] = tableViewElement;
                                        (this).AbstractLiferayTableViewCustomPart.this.tableViewer.setInput((Object)AbstractLiferayTableViewCustomPart.this.tableViewElements);
                                        (this).AbstractLiferayTableViewCustomPart.this.tableViewer.refresh();
                                    }
                                });
                            }
                            catch (Exception e) {
                                ProjectCore.logError((String)"Error upgrade files...... ", (Exception)e);
                            }
                        }
                        ++i;
                    }
                }
            });
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }

    @Override
    public void onSelectionChanged(int targetSelection) {
        Page selectedPage = UpgradeView.getPage(targetSelection);
        String selectedPageId = selectedPage.getPageId();
        if (!selectedPageId.equals(this.getPageId())) {
            return;
        }
        this.handleFindEvent();
    }

    public class LiferayUpgradeElement {
        public String name;
        public String context;
        public final String location;
        public final String itemName;

        public LiferayUpgradeElement(String name, String context, String location, String itemName) {
            this.context = context;
            this.name = name;
            this.location = location;
            this.itemName = itemName;
        }
    }

    protected abstract class LiferayUpgradeTabeViewLabelProvider
    extends ElementLabelProvider
    implements IColorProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private String GREY_COLOR;
        private final ColorRegistry COLOR_REGISTRY = JFaceResources.getColorRegistry();
        protected StyledString.Styler GREYED_STYLER;

        public LiferayUpgradeTabeViewLabelProvider() {
            this.COLOR_REGISTRY.put(this.GREY_COLOR, new RGB(128, 128, 128));
            this.GREYED_STYLER = StyledString.createColorRegistryStyler((String)this.GREY_COLOR, null);
        }

        public LiferayUpgradeTabeViewLabelProvider(String greyColorName) {
            this.GREY_COLOR = greyColorName;
        }

        @Override
        public Color getForeground(Object element) {
            String srcLableString;
            if (element instanceof LiferayUpgradeElement && (srcLableString = ((LiferayUpgradeElement)element).context).contains("Finished")) {
                return Display.getCurrent().getSystemColor(9);
            }
            return Display.getCurrent().getSystemColor(2);
        }

        @Override
        public StyledString getStyledText(Object element) {
            if (element instanceof LiferayUpgradeElement) {
                String srcLableString = ((LiferayUpgradeElement)element).context;
                String elementName = ((LiferayUpgradeElement)element).name;
                StyledString styled = new StyledString(elementName);
                return StyledCellLabelProvider.styleDecoratedString((String)srcLableString, (StyledString.Styler)this.GREYED_STYLER, (StyledString)styled);
            }
            return new StyledString(((LiferayUpgradeElement)element).context);
        }
    }

    private class LiferayUpgradeValidationListener
    extends org.eclipse.sapphire.Listener {
        private LiferayUpgradeValidationListener() {
        }

        public void handle(org.eclipse.sapphire.Event event) {
            ValuePropertyContentEvent propertyEvetn;
            Property property;
            if (event instanceof ValuePropertyContentEvent && (property = (propertyEvetn = (ValuePropertyContentEvent)event).property()).name().equals("ImportFinished")) {
                AbstractLiferayTableViewCustomPart.this.handleFindEvent();
            }
        }
    }

    protected class TableViewContentProvider
    implements IStructuredContentProvider {
        protected TableViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof LiferayUpgradeElement[]) {
                return (LiferayUpgradeElement[])inputElement;
            }
            return new Object[]{inputElement};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

