/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.SearchFilesVisitor;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.upgrade.animated.AbstractLiferayTableViewCustomPart;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.ui.util.SWTUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DescriptorsPage
extends AbstractLiferayTableViewCustomPart {
    private static final String[][] DESCRIPTORS_AND_IMAGES = new String[][]{{"liferay-portlet.xml", "/icons/e16/portlet.png"}, {"liferay-display.xml", "/icons/e16/liferay_display_xml.png"}, {"service.xml", "/icons/e16/service.png"}, {"liferay-hook.xml", "/icons/e16/hook.png"}, {"liferay-layout-templates.xml", "/icons/e16/layout.png"}, {"liferay-look-and-feel.xml", "/icons/e16/theme.png"}, {"liferay-portlet-ext.xml", "/icons/e16/ext.png"}};
    private static final String PUBLICID_REGREX = "-\\//(?:[a-z][a-z]+)\\//(?:[a-z][a-z]+)[\\s+(?:[a-z][a-z0-9_]*)]*\\s+(\\d\\.\\d\\.\\d)\\//(?:[a-z][a-z]+)";
    private static final String SYSTEMID_REGREX = "^http://www.liferay.com/dtd/[-A-Za-z0-9+&@#/%?=~_()]*(\\d_\\d_\\d).dtd";

    public DescriptorsPage(Composite parent, int style, LiferayUpgradeDataModel dataModel) {
        super(parent, style, dataModel, DESCRIPTORS_PAGE_ID, true);
    }

    @Override
    public void createSpecialDescriptor(Composite parent, int style) {
        String descriptor = "This step upgrades descriptor XML DTD versions from 6.2 to 7.0 and deletes the wap-template-path \ntag from liferay-layout-template.xml files.\nDouble click the file in the list. It will popup a comparison page which shows the differences\nbetween your original source file and the upgrade preview file.";
        String url = "";
        Link link = SWTUtil.createHyperLink((Composite)this, (int)style, (String)"This step upgrades descriptor XML DTD versions from 6.2 to 7.0 and deletes the wap-template-path \ntag from liferay-layout-template.xml files.\nDouble click the file in the list. It will popup a comparison page which shows the differences\nbetween your original source file and the upgrade preview file.", (int)1, (String)url);
        link.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
    }

    @Override
    public String getPageTitle() {
        return "Upgrade Descriptor Files";
    }

    @Override
    public int getGridLayoutCount() {
        return 2;
    }

    @Override
    protected void createTempFile(File srcFile, File templateFile, String projectName) {
        SAXBuilder builder = new SAXBuilder(false);
        builder.setValidation(false);
        builder.setFeature("http://xml.org/sax/features/validation", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileInputStream ivyInput = new FileInputStream(srcFile);){
                Document doc = builder.build((InputStream)ivyInput);
                DocType docType = doc.getDocType();
                if (docType != null) {
                    String publicId = docType.getPublicID();
                    String newPublicId = this.getNewDoctTypeSetting(publicId, "7.0.0", PUBLICID_REGREX);
                    docType.setPublicID(newPublicId);
                    String systemId = docType.getSystemID();
                    String newSystemId = this.getNewDoctTypeSetting(systemId, "7_0_0", SYSTEMID_REGREX);
                    docType.setSystemID(newSystemId);
                }
                this.removeLayoutWapNode(srcFile, doc);
                if (templateFile.exists()) {
                    templateFile.delete();
                }
                templateFile.createNewFile();
                this.saveXML(templateFile, doc);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | JDOMException e) {
            ProjectCore.logError((Throwable)e);
        }
    }

    @Override
    protected void doUpgrade(File srcFile, IProject project) {
        SAXBuilder builder = new SAXBuilder(false);
        builder.setValidation(false);
        builder.setFeature("http://xml.org/sax/features/validation", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream ivyInput = new FileInputStream(srcFile);){
                Document doc = builder.build((InputStream)ivyInput);
                DocType docType = doc.getDocType();
                if (docType != null) {
                    String publicId = docType.getPublicID();
                    String newPublicId = this.getNewDoctTypeSetting(publicId, "7.0.0", PUBLICID_REGREX);
                    docType.setPublicID(newPublicId);
                    String systemId = docType.getSystemID();
                    String newSystemId = this.getNewDoctTypeSetting(systemId, "7_0_0", SYSTEMID_REGREX);
                    docType.setSystemID(newSystemId);
                }
                this.removeLayoutWapNode(srcFile, doc);
                this.saveXML(srcFile, doc);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }

    @Override
    protected IFile[] getAvaiableUpgradeFiles(IProject project) {
        ArrayList files = new ArrayList();
        String[][] stringArray = DESCRIPTORS_AND_IMAGES;
        int n = DESCRIPTORS_AND_IMAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String[] descriptors = stringArray[n2];
            String searchName = descriptors[0];
            List searchFiles = new SearchFilesVisitor().searchFiles((IResource)project, searchName);
            files.addAll(searchFiles);
            ++n2;
        }
        return files.toArray(new IFile[files.size()]);
    }

    @Override
    protected DelegatingStyledCellLabelProvider.IStyledLabelProvider getLableProvider() {
        return new AbstractLiferayTableViewCustomPart.LiferayUpgradeTabeViewLabelProvider(this, "Upgrade Descriptors"){

            @Override
            public Image getImage(Object element) {
                if (element instanceof AbstractLiferayTableViewCustomPart.LiferayUpgradeElement) {
                    String itemName = ((AbstractLiferayTableViewCustomPart.LiferayUpgradeElement)element).itemName;
                    return this.getImageRegistry().get(itemName);
                }
                return null;
            }

            @Override
            protected void initalizeImageRegistry(ImageRegistry imageRegistry) {
                String[][] stringArray = DESCRIPTORS_AND_IMAGES;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] descriptorsAndImages = stringArray[n2];
                    String descName = descriptorsAndImages[0];
                    String descImage = descriptorsAndImages[1];
                    imageRegistry.put(descName, ProjectUI.imageDescriptorFromPlugin((String)"com.liferay.ide.project.ui", (String)descImage));
                    ++n2;
                }
            }
        };
    }

    private String getNewDoctTypeSetting(String doctypeSetting, String newValue, String regrex) {
        String newDoctTypeSetting = null;
        Pattern p = Pattern.compile(regrex, 34);
        Matcher m = p.matcher(doctypeSetting);
        if (m.find()) {
            String oldVersionString = m.group(m.groupCount());
            newDoctTypeSetting = doctypeSetting.replace(oldVersionString, newValue);
        }
        return newDoctTypeSetting;
    }

    private String getOldVersion(String sourceDTDVersion, String regrex) {
        if (sourceDTDVersion == null) {
            return null;
        }
        Pattern p = Pattern.compile(regrex, 34);
        Matcher m = p.matcher(sourceDTDVersion);
        if (m.find()) {
            String oldVersionString = m.group(m.groupCount());
            return oldVersionString;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isNeedUpgrade(File srcFile) {
        SAXBuilder builder = new SAXBuilder(false);
        builder.setValidation(false);
        builder.setFeature("http://xml.org/sax/features/validation", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream ivyInput = new FileInputStream(srcFile);){
                Document doc = builder.build((InputStream)ivyInput);
                DocType docType = doc.getDocType();
                if (docType == null) return false;
                String publicId = docType.getPublicID();
                String oldPublicIdVersion = this.getOldVersion(publicId, PUBLICID_REGREX);
                String systemId = docType.getSystemID();
                String oldSystemIdVersion = this.getOldVersion(systemId, SYSTEMID_REGREX);
                if (publicId == null || oldPublicIdVersion.equals("7.0.0")) {
                    if (systemId == null) return false;
                    if (oldSystemIdVersion.equals("7_0_0")) return false;
                }
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
        return false;
    }

    private void removeLayoutWapNode(File srcFile, Document doc) {
        if (srcFile.getName().equals("liferay-layout-templates.xml")) {
            Element itemRem = null;
            Element elementRoot = doc.getRootElement();
            List customers = elementRoot.getChildren("custom");
            for (Element customerElement : customers) {
                List layoutElements = customerElement.getChildren("layout-template");
                for (Element layoutElement : layoutElements) {
                    List wapElements = layoutElement.getChildren("wap-template-path");
                    Iterator wapIterator = wapElements.iterator();
                    while (wapIterator.hasNext()) {
                        Element removeItem = (Element)wapIterator.next();
                        wapIterator.remove();
                        itemRem = removeItem;
                    }
                }
            }
            elementRoot.removeContent(itemRem);
        }
    }

    private void saveXML(File templateFile, Document doc) {
        XMLOutputter out = new XMLOutputter();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fos = new FileOutputStream(templateFile);){
                Format fm = Format.getPrettyFormat();
                out.setFormat(fm);
                out.output(doc, (OutputStream)fos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }
}

