/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.project.ui.upgrade.animated.AbstractCanvas;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.project.ui.upgrade.animated.PageAction;
import com.liferay.ide.project.ui.upgrade.animated.PageActionEvent;
import com.liferay.ide.project.ui.upgrade.animated.PageNavigateEvent;
import com.liferay.ide.project.ui.upgrade.animated.PageValidateEvent;
import com.liferay.ide.project.ui.upgrade.animated.SelectionChangedListener;
import com.liferay.ide.project.ui.upgrade.animated.UpgradeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class GearControl
extends AbstractCanvas
implements UpgradeView.PageNavigatorListener,
UpgradeView.PageActionListener,
UpgradeView.PageValidationListener {
    private float angle;
    private final int BORDER = 20;
    private Display display;
    private Image errorImage;
    private Image warningImage;
    private Map<String, PageValidateEvent> validationMessageMap = new HashMap<String, PageValidateEvent>();
    private final Color[] gearBackground = new Color[2];
    private final Color[] gearForeground = new Color[2];
    private int gearMaxNumber = 10;
    private final Path[] gearPaths = new Path[this.gearMaxNumber];
    private final Point[] tooltipPoints = new Point[this.gearMaxNumber];
    private Color DARK_GRAY;
    private Color GRAY;
    private Color WHITE;
    private Color tooltipColor;
    private int hover = -1;
    private boolean needRedraw = false;
    private Font numberFont;
    private int oldHover = -1;
    private int oldSelection = -1;
    private boolean overflow;
    private final double RADIAN = Math.PI / 180;
    private float radius;
    private int selection;
    private final List<SelectionChangedListener> selectionChangedListeners = Collections.synchronizedList(new ArrayList());
    private float speed;
    private long startAnimation;
    private final int TEETH = 8;
    private final float ANGLE = 45.0f;
    private Font tooltipFont;

    public GearControl(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.init();
        this.scheduleRun();
    }

    public void addSelectionChangedListener(SelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    private Path drawGear(GC gc, Display display, double cx, double cy, double outerR, double innerR, float angleOffset) {
        double radian2 = 0.39269908169872414;
        double radian3 = 0.06;
        Path path = new Path((Device)display);
        int i = 0;
        while (i < 8) {
            double radian = (double)((float)i * 45.0f + angleOffset) * (Math.PI / 180);
            double x = cx + outerR * Math.cos(radian);
            double y = cy - outerR * Math.sin(radian);
            if (i == 0) {
                path.moveTo((float)((int)x), (float)((int)y));
            }
            double r1 = radian + radian3;
            double r3 = radian + radian2;
            double r2 = r3 - radian3;
            double r4 = r3 + radian2;
            x = cx + innerR * Math.cos(r1);
            y = cy - innerR * Math.sin(r1);
            path.lineTo((float)((int)x), (float)((int)y));
            x = cx + innerR * Math.cos(r2);
            y = cy - innerR * Math.sin(r2);
            path.lineTo((float)((int)x), (float)((int)y));
            x = cx + outerR * Math.cos(r3);
            y = cy - outerR * Math.sin(r3);
            path.lineTo((float)((int)x), (float)((int)y));
            x = cx + outerR * Math.cos(r4);
            y = cy - outerR * Math.sin(r4);
            path.lineTo((float)((int)x), (float)((int)y));
            ++i;
        }
        path.close();
        gc.fillPath(path);
        gc.drawPath(path);
        return path;
    }

    public final int getSelection() {
        return this.selection;
    }

    @Override
    protected void init() {
        super.init();
        this.display = this.getDisplay();
        this.errorImage = JFaceResources.getImage((String)"dialog_message_error_image");
        this.warningImage = JFaceResources.getImage((String)"dialog_messasge_warning_image");
        this.WHITE = this.display.getSystemColor(1);
        this.GRAY = this.display.getSystemColor(15);
        this.DARK_GRAY = this.display.getSystemColor(16);
        Font initialFont = this.getFont();
        FontData[] fontData = initialFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(16);
            fontData[i].setStyle(1);
            ++i;
        }
        this.baseFont = new Font((Device)this.display, fontData);
        this.numberFont = this.createFont(24);
        this.tooltipFont = this.createFont(24);
        this.radius = 32.0f;
        this.setSize((int)((float)(this.gearMaxNumber * 2) * this.radius), (int)(2.0f * this.radius));
        this.gearBackground[0] = this.createColor(169, 171, 202);
        this.gearForeground[0] = this.createColor(140, 132, 171);
        this.gearBackground[1] = this.createColor(247, 148, 30);
        this.gearForeground[1] = this.createColor(207, 108, 0);
        this.tooltipColor = this.createColor(253, 232, 206);
    }

    @Override
    protected boolean needRedraw() {
        boolean retVal = false;
        if (this.needRedraw) {
            this.needRedraw = false;
            retVal = true;
        }
        if (this.overflow) {
            this.overflow = false;
            retVal = true;
        }
        if (this.hover != this.oldHover) {
            retVal = true;
        }
        if (this.speed >= 45.0f) {
            this.startAnimation = 0L;
            return retVal;
        }
        long now = this.currentTime;
        if (this.startAnimation == 0L) {
            this.startAnimation = now;
        }
        long timeSinceStart = now - this.startAnimation;
        this.speed = (float)timeSinceStart * 45.0f / 400.0f;
        this.angle += this.speed;
        return true;
    }

    @Override
    protected void onMouseDown(int x, int y) {
        if (x != Integer.MIN_VALUE && y != Integer.MIN_VALUE) {
            GC gc = new GC((Drawable)this);
            int i = 0;
            while (i < this.gearPaths.length) {
                Path path = this.gearPaths[i];
                if (path != null && path.contains((float)x, (float)y, gc, false) && i != this.getSelection()) {
                    this.setSelection(i);
                }
                ++i;
            }
        }
    }

    @Override
    protected void onMouseMove(int x, int y) {
        if (x != Integer.MIN_VALUE && y != Integer.MIN_VALUE) {
            GC gc = new GC((Drawable)this);
            int number = UpgradeView.getPageNumber();
            int i = 0;
            while (i < number) {
                Path path = this.gearPaths[i];
                if (path != null && path.contains((float)x, (float)y, gc, false)) {
                    if (i != this.hover) {
                        this.hover = i;
                    }
                    return;
                }
                ++i;
            }
        }
        this.hover = -1;
    }

    @Override
    public void onPageAction(PageActionEvent event) {
        int targetPageIndex = event.getTargetPageIndex();
        this.needRedraw = true;
        if (targetPageIndex != -1) {
            this.setSelection(targetPageIndex);
        }
    }

    @Override
    public void onPageNavigate(PageNavigateEvent event) {
        this.setSelection(event.getTargetPage());
    }

    @Override
    public void onValidation(PageValidateEvent event) {
        String pageId = event.getPageId();
        this.validationMessageMap.put(pageId, event);
        Page page = UpgradeView.getPage(this.selection);
        if (page.getPageId().equals(pageId)) {
            this.needRedraw = true;
        }
    }

    @Override
    protected void paint(GC gc) {
        gc.setFont(this.getBaseFont());
        gc.setLineWidth(3);
        gc.setAntialias(1);
        int alpha = Math.min((int)(255.0f * this.speed / 45.0f), 255);
        int number = UpgradeView.getPageNumber();
        int i = 0;
        while (i < number) {
            this.tooltipPoints[i] = this.paintGear(gc, i, alpha);
            ++i;
        }
        if (this.hover >= 0 && this.hover < this.tooltipPoints.length) {
            Point point = this.tooltipPoints[this.hover];
            String title = UpgradeView.getPage(this.hover).getTitle();
            gc.setFont(this.tooltipFont);
            gc.setForeground(this.DARK_GRAY);
            gc.setBackground(this.tooltipColor);
            Rectangle rectangle = GearControl.drawText(gc, point.x, point.y + 14, title, 2);
            gc.setForeground(this.GRAY);
            gc.setLineWidth(1);
            gc.drawRectangle(rectangle);
        }
        this.paintValidationMessage(gc);
        this.oldHover = this.hover;
    }

    private void paintValidationMessage(GC gc) {
        String message;
        Page page = UpgradeView.getPage(this.selection);
        String pageId = page.getPageId();
        PageValidateEvent event = this.validationMessageMap.get(pageId);
        if (event != null && (message = event.getMessage()) != null && !message.equals("ok")) {
            if (event.getType().equals(PageValidateEvent.ERROR)) {
                this.drawImage(gc, this.errorImage, 30, 130);
            } else {
                this.drawImage(gc, this.warningImage, 30, 130);
            }
            gc.setBackground(this.tooltipColor);
            gc.setForeground(this.DARK_GRAY);
            gc.setLineWidth(1);
            Rectangle rectangle = this.drawTextNotCenter(gc, 40, 120, message, 2);
            gc.drawRectangle(rectangle);
        }
    }

    private Point paintBadge(GC gc, double x, double y, double outerR, int i, int alpha) {
        if (this.selection >= this.gearMaxNumber) {
            gc.setAlpha(255 - alpha);
        } else if (this.oldSelection >= this.gearMaxNumber) {
            gc.setAlpha(alpha);
        }
        Image badgeImage = null;
        Page page = UpgradeView.getPage(i);
        PageAction pageAction = page.getSelectedAction();
        if (pageAction != null) {
            badgeImage = pageAction.getBageImage();
        }
        if (badgeImage != null) {
            gc.drawImage(badgeImage, (int)(x - (double)(badgeImage.getBounds().width / 2)), (int)(y - outerR - 12.0));
            gc.setAlpha(255);
        }
        return new Point((int)x, (int)(y + outerR));
    }

    private Point paintGear(GC gc, int i, int alpha) {
        double offset = (float)(2 * i) * this.radius;
        double x = (double)(20.0f + this.radius) + offset;
        double y = 20.0f + this.radius;
        double r2 = (double)this.radius * (double)0.8f;
        double r3 = (double)this.radius * 0.5;
        int selected = 0;
        double factor = 1.0;
        if (i == this.oldSelection) {
            if (this.speed < 22.5f) {
                selected = 1;
            }
        } else if (i == this.selection) {
            if (this.speed >= 22.5f) {
                selected = 1;
                factor += (double)(45.0f - this.speed) * 0.02;
            } else {
                factor += (double)this.speed * 0.02;
            }
        }
        boolean hovered = false;
        if (i == this.hover) {
            factor += 0.1;
            this.oldHover = this.hover;
            if (selected == 0) {
                hovered = true;
            }
        }
        double outerR = factor * (double)this.radius;
        double innerR = factor * r2;
        float angleOffset = (this.angle + (float)i * 45.0f) * (float)(i % 2 == 1 ? -1 : 1) / 7.0f;
        gc.setForeground(hovered ? this.DARK_GRAY : this.gearForeground[selected]);
        gc.setBackground(hovered ? this.GRAY : this.gearBackground[selected]);
        if (outerR < 32.0) {
            outerR = 32.0;
        }
        if (innerR < 25.0) {
            innerR = 25.6f;
        }
        Path path = this.drawGear(gc, this.display, x, y, outerR, innerR, angleOffset);
        if (this.gearPaths[i] != null) {
            this.gearPaths[i].dispose();
        }
        this.gearPaths[i] = path;
        int ovalX = (int)(x - factor * r3);
        int ovalY = (int)(y - factor * r3);
        int ovalR = (int)(2.0 * factor * r3);
        gc.setBackground(this.WHITE);
        gc.fillOval(ovalX, ovalY, ovalR, ovalR);
        gc.drawOval(ovalX, ovalY, ovalR, ovalR);
        if (i < this.gearMaxNumber) {
            String number = Integer.toString(i + 1);
            gc.setForeground(selected == 1 ? this.gearForeground[1] : this.GRAY);
            gc.setFont(this.numberFont);
            GearControl.drawText(gc, x, y - 1.0, number);
        }
        return this.paintBadge(gc, x, y, outerR, i, alpha);
    }

    public void restart() {
        this.angle = 0.0f;
        this.speed = 0.0f;
    }

    public final void setSelection(int selection) {
        this.hover = -1;
        this.oldHover = -1;
        if (selection < 0) {
            selection = 0;
            this.overflow = true;
        } else if (selection > this.gearMaxNumber - 1) {
            selection = this.gearMaxNumber - 1;
            this.overflow = true;
        }
        if (this.overflow) {
            this.overflow = false;
            while (this.needRedraw()) {
            }
            this.overflow = true;
            return;
        }
        this.oldSelection = this.selection;
        this.selection = selection;
        for (SelectionChangedListener listener : this.selectionChangedListeners) {
            listener.onSelectionChanged(selection);
        }
        this.restart();
    }
}

