/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.ImportLiferayModuleProjectOpMethods;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;
import org.osgi.framework.Version;

public class ProjectLocationValidationService
extends ValidationService {
    protected Status compute() {
        Status retval = Status.createOkStatus();
        int countPossibleWorkspaceSDKProjects = SDKUtil.countPossibleWorkspaceSDKProjects();
        if (countPossibleWorkspaceSDKProjects > 1) {
            return StatusBridge.create((IStatus)ProjectCore.createErrorStatus((String)"This workspace has more than one SDK."));
        }
        Path location = (Path)this.op().getSdkLocation().content(true);
        if (location == null || location.isEmpty()) {
            return StatusBridge.create((IStatus)ProjectCore.createErrorStatus((String)"Liferay Plugins SDK or Maven location is empty."));
        }
        SDK sdk = SDKUtil.createSDKFromLocation((IPath)PathBridge.create((Path)location));
        if (sdk != null) {
            Version sdkVersion;
            int result;
            IStatus status = sdk.validate(true);
            if (!status.isOK()) {
                return StatusBridge.create((IStatus)status);
            }
            if (this.isInLiferayWorkspace(location)) {
                return StatusBridge.create((IStatus)ProjectCore.createErrorStatus((String)"sdk project is already in a Liferay workspace"));
            }
            String version = sdk.getVersion();
            if (version != null && (result = (sdkVersion = new Version(version)).compareTo(new Version("6.1.0"))) < 0) {
                return StatusBridge.create((IStatus)ProjectCore.createErrorStatus((String)"This tool doesn't support 6.0.x."));
            }
        } else if (!ImportLiferayModuleProjectOpMethods.getBuildType((String)location.removeFileExtension().toPortableString()).getMessage().equals("maven")) {
            return StatusBridge.create((IStatus)ProjectCore.createErrorStatus((String)"Plugins SDK or Maven location is not valid."));
        }
        return retval;
    }

    private LiferayUpgradeDataModel op() {
        return (LiferayUpgradeDataModel)this.context(LiferayUpgradeDataModel.class);
    }

    private boolean isInLiferayWorkspace(Path location) {
        boolean retVal = false;
        File projectDir = location.toFile();
        File parent = projectDir.getParentFile();
        while (parent != null) {
            if (LiferayWorkspaceUtil.isValidWorkspaceLocation((String)parent.getAbsolutePath())) {
                retVal = true;
            }
            parent = parent.getParentFile();
        }
        return retVal;
    }
}

