/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.project.core.upgrade.UpgradeAssistantSettingsUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.migration.MigrationProblemsContainer;
import com.liferay.ide.project.ui.upgrade.CustomJspConverter;
import com.liferay.ide.project.ui.upgrade.animated.BuildPage;
import com.liferay.ide.project.ui.upgrade.animated.BuildServicePage;
import com.liferay.ide.project.ui.upgrade.animated.CustomJspPage;
import com.liferay.ide.project.ui.upgrade.animated.DescriptorsPage;
import com.liferay.ide.project.ui.upgrade.animated.FindBreakingChangesPage;
import com.liferay.ide.project.ui.upgrade.animated.GearControl;
import com.liferay.ide.project.ui.upgrade.animated.InitConfigureProjectPage;
import com.liferay.ide.project.ui.upgrade.animated.LayoutTemplatePage;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.project.ui.upgrade.animated.NavigatorControl;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.project.ui.upgrade.animated.PageAction;
import com.liferay.ide.project.ui.upgrade.animated.PageActionEvent;
import com.liferay.ide.project.ui.upgrade.animated.PageNavigateEvent;
import com.liferay.ide.project.ui.upgrade.animated.PageValidateEvent;
import com.liferay.ide.project.ui.upgrade.animated.SelectionChangedListener;
import com.liferay.ide.project.ui.upgrade.animated.SummaryPage;
import com.liferay.ide.project.ui.upgrade.animated.UpgradePomPage;
import com.liferay.ide.project.ui.upgrade.animated.UpgradeSettingsUtil;
import com.liferay.ide.project.ui.upgrade.animated.WelcomePage;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ValuePropertyContentEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class UpgradeView
extends ViewPart
implements SelectionChangedListener {
    public static final String ID = "com.liferay.ide.project.ui.upgradeView";
    private static LiferayUpgradeDataModel dataModel;
    private static List<Page> currentPageList;
    private static List<Page> staticPageList;
    private static Composite pagesSwitchControler;
    private static Page[] pages;

    static {
        currentPageList = new ArrayList<Page>();
        staticPageList = new ArrayList<Page>();
        pagesSwitchControler = null;
        pages = null;
    }

    private LiferayUpgradeDataModel createUpgradeModel() {
        return (LiferayUpgradeDataModel)LiferayUpgradeDataModel.TYPE.instantiate();
    }

    public UpgradeView() {
        dataModel = this.createUpgradeModel();
        dataModel.attach(new LiferayUpgradeStoreListener(), "*");
        UpgradeSettingsUtil.init(dataModel);
    }

    public static void addPage(String pageid) {
        Page targetPage = null;
        for (Page page : staticPageList) {
            if (!page.getPageId().equals(pageid)) continue;
            targetPage = page;
            break;
        }
        if (targetPage != null) {
            currentPageList.add(targetPage);
        }
    }

    public static void resumePages() {
        dataModel.setHasMavenProject(true);
        dataModel.setHasExt(true);
        dataModel.setHasHook(true);
        dataModel.setHasLayout(true);
        dataModel.setHasPortlet(true);
        dataModel.setHasServiceBuilder(true);
        dataModel.setHasTheme(true);
        dataModel.setHasWeb(true);
        dataModel.setConvertLiferayWorkspace(false);
        currentPageList.clear();
        currentPageList.addAll(staticPageList);
        pages = currentPageList.toArray(new Page[0]);
    }

    public static void resetPages() {
        currentPageList.clear();
        UpgradeView.addPage(Page.WELCOME_PAGE_ID);
        UpgradeView.addPage(Page.INIT_CONFIGURE_PROJECT_PAGE_ID);
        boolean hasMavenProject = (Boolean)dataModel.getHasMavenProject().content();
        boolean hasPortlet = (Boolean)dataModel.getHasPortlet().content();
        boolean hasServiceBuilder = (Boolean)dataModel.getHasServiceBuilder().content();
        boolean hasHook = (Boolean)dataModel.getHasHook().content();
        boolean hasLayout = (Boolean)dataModel.getHasLayout().content();
        if (hasMavenProject) {
            UpgradeView.addPage(Page.UPGRADE_POM_PAGE_ID);
        }
        if (hasPortlet || hasHook || hasServiceBuilder) {
            UpgradeView.addPage(Page.FINDBREACKINGCHANGES_PAGE_ID);
        }
        if (hasPortlet || hasHook || hasServiceBuilder || hasLayout) {
            UpgradeView.addPage(Page.DESCRIPTORS_PAGE_ID);
        }
        if (hasServiceBuilder) {
            UpgradeView.addPage(Page.BUILDSERVICE_PAGE_ID);
        }
        if (hasLayout) {
            UpgradeView.addPage(Page.LAYOUTTEMPLATE_PAGE_ID);
        }
        if (hasHook) {
            UpgradeView.addPage(Page.CUSTOMJSP_PAGE_ID);
        }
        if (hasPortlet || hasHook || hasServiceBuilder || hasLayout) {
            UpgradeView.addPage(Page.BUILD_PAGE_ID);
            UpgradeView.addPage(Page.SUMMARY_PAGE_ID);
        }
        Page[] pageArray = pages = currentPageList.toArray(new Page[0]);
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            Page page = pageArray[n2];
            String pageActionName = UpgradeSettingsUtil.getProperty(page.getPageId());
            if (pageActionName != null) {
                PageAction pageAction = page.getSelectedAction(pageActionName);
                page.setSelectedAction(pageAction);
            }
            ++n2;
        }
    }

    public static int getPageNumber() {
        return pages.length;
    }

    public void setSelectPage(int i) {
        StackLayout stackLayout = (StackLayout)pagesSwitchControler.getLayout();
        stackLayout.topControl = pages[i];
        pagesSwitchControler.layout();
    }

    public static Page getPage(int i) {
        if (i < 0 || i > pages.length - 1) {
            return null;
        }
        return pages[i];
    }

    public static <T> T getPage(String pageId, Class<T> clazz) {
        Page[] pageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            Page page = pageArray[n2];
            if (page.getPageId().equals(pageId)) {
                return (T)page;
            }
            ++n2;
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 0x20000300);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite container = SWTUtil.createComposite((Composite)scrolledComposite, (int)1, (int)0, (int)1808);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData grData = new GridData(1808);
        grData.grabExcessVerticalSpace = true;
        grData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)grData);
        GearControl gear = new GearControl(composite, 0);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 400;
        gridData.heightHint = 150;
        gear.setLayoutData(gridData);
        gear.setBackground(parent.getBackground());
        StackLayout stackLayout = new StackLayout();
        pagesSwitchControler = new Composite(composite, 2048);
        pagesSwitchControler.setLayout((Layout)stackLayout);
        GridData containerData = new GridData(1808);
        containerData.grabExcessHorizontalSpace = true;
        containerData.grabExcessVerticalSpace = true;
        containerData.grabExcessHorizontalSpace = true;
        pagesSwitchControler.setLayoutData((Object)containerData);
        int pageIndex = 0;
        WelcomePage welcomePage = new WelcomePage(pagesSwitchControler, 0, dataModel);
        welcomePage.setIndex(pageIndex++);
        welcomePage.setTitle("Welcome");
        welcomePage.setBackPage(false);
        welcomePage.addPageNavigateListener(gear);
        InitConfigureProjectPage initConfigureProjectPage = new InitConfigureProjectPage(pagesSwitchControler, 0, dataModel);
        initConfigureProjectPage.setIndex(pageIndex++);
        initConfigureProjectPage.setTitle("Select project(s) to upgrade");
        initConfigureProjectPage.addPageNavigateListener(gear);
        initConfigureProjectPage.addPageValidationListener(gear);
        initConfigureProjectPage.setNextPage(false);
        UpgradePomPage upgradePomPage = new UpgradePomPage(pagesSwitchControler, 0, dataModel);
        upgradePomPage.setIndex(pageIndex++);
        upgradePomPage.setTitle("Upgrade POM Files");
        upgradePomPage.addPageValidationListener(gear);
        FindBreakingChangesPage findBreakingChangesPage = new FindBreakingChangesPage(pagesSwitchControler, 0, dataModel);
        findBreakingChangesPage.setIndex(pageIndex++);
        findBreakingChangesPage.setTitle("Find Breaking Changes");
        DescriptorsPage descriptorsPage = new DescriptorsPage(pagesSwitchControler, 0, dataModel);
        descriptorsPage.setIndex(pageIndex++);
        descriptorsPage.setTitle("Update Descriptor Files");
        descriptorsPage.addPageValidationListener(gear);
        BuildServicePage buildServicePage = new BuildServicePage(pagesSwitchControler, 0, dataModel);
        buildServicePage.setIndex(pageIndex++);
        buildServicePage.setTitle("Build Services");
        LayoutTemplatePage layoutTemplatePage = new LayoutTemplatePage(pagesSwitchControler, 0, dataModel);
        layoutTemplatePage.setIndex(pageIndex++);
        layoutTemplatePage.setTitle("Layout Templates");
        layoutTemplatePage.addPageValidationListener(gear);
        CustomJspPage customJspPage = new CustomJspPage(pagesSwitchControler, 0, dataModel);
        customJspPage.setIndex(pageIndex++);
        customJspPage.setTitle("Custom Jsp");
        customJspPage.addPageValidationListener(gear);
        BuildPage buildPage = new BuildPage(pagesSwitchControler, 0, dataModel);
        buildPage.setIndex(pageIndex++);
        buildPage.setTitle("Build");
        SummaryPage summaryPage = new SummaryPage(pagesSwitchControler, 0, dataModel);
        summaryPage.setIndex(pageIndex++);
        summaryPage.setTitle("Summary");
        summaryPage.setNextPage(false);
        summaryPage.addPageNavigateListener(gear);
        staticPageList.clear();
        staticPageList.add(welcomePage);
        staticPageList.add(initConfigureProjectPage);
        staticPageList.add(upgradePomPage);
        staticPageList.add(findBreakingChangesPage);
        staticPageList.add(descriptorsPage);
        staticPageList.add(buildServicePage);
        staticPageList.add(layoutTemplatePage);
        staticPageList.add(customJspPage);
        staticPageList.add(buildPage);
        staticPageList.add(summaryPage);
        UpgradeView.resetPages();
        NavigatorControl navigator = new NavigatorControl(composite, 0);
        navigator.addPageNavigateListener(gear);
        navigator.addPageActionListener(gear);
        navigator.setBackground(parent.getBackground());
        gear.addSelectionChangedListener(navigator);
        gear.addSelectionChangedListener(this);
        gear.addSelectionChangedListener(initConfigureProjectPage);
        gear.addSelectionChangedListener(descriptorsPage);
        gear.addSelectionChangedListener(upgradePomPage);
        gear.addSelectionChangedListener(layoutTemplatePage);
        gear.addSelectionChangedListener(summaryPage);
        GridData navData = new GridData(768);
        navData.grabExcessHorizontalSpace = true;
        navigator.setLayoutData(navData);
        scrolledComposite.setContent((Control)container);
        this.setSelectPage(0);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int pageNum = UpgradeView.getPageNumber();
                int i = 0;
                while (i < pageNum) {
                    Page page = UpgradeView.getPage(i);
                    String pageId = page.getPageId();
                    PageAction pageAction = page.getSelectedAction();
                    if (pageAction != null) {
                        UpgradeSettingsUtil.storeProperty(pageId, pageAction.getPageActionName());
                    }
                    ++i;
                }
            }
        });
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        Action restart = new Action("Restart Upgrade", ImageDescriptor.createFromURL((URL)ProjectUI.getDefault().getBundle().getEntry("icons/e16/restart.gif"))){

            public void run() {
                UpgradeView.this.restartUpgradeTool();
            }
        };
        Action showAllPages = new Action("Show All Pages", ImageDescriptor.createFromURL((URL)ProjectUI.getDefault().getBundle().getEntry("icons/e16/showall.gif"))){

            public void run() {
                Boolean openNewLiferayProjectWizard = MessageDialog.openQuestion((Shell)UIUtil.getActiveShell(), (String)"Show All Pages", (String)"If you fail to import projects, you can skip step 2 by doing following steps:\n   1.upgrade SDK 6.2 to SDK 7.0 manually\n   or use blade cli to create a Liferay workspace for your SDK\n   2.import projects you want to upgrade into Eclipse workspace\n   3.click \"yes\" to show all the steps");
                if (openNewLiferayProjectWizard.booleanValue()) {
                    UpgradeView.showAllPages();
                }
            }
        };
        mgr.add((IAction)restart);
        mgr.add((IAction)showAllPages);
    }

    public static void showAllPages() {
        UpgradeView.resumePages();
        PageNavigateEvent event = new PageNavigateEvent();
        event.setTargetPage(2);
        StackLayout stackLayout = (StackLayout)pagesSwitchControler.getLayout();
        Page currentPage = (Page)stackLayout.topControl;
        for (PageNavigatorListener listener : currentPage.naviListeners) {
            listener.onPageNavigate(event);
        }
        InitConfigureProjectPage importPage = UpgradeView.getPage(Page.INIT_CONFIGURE_PROJECT_PAGE_ID, InitConfigureProjectPage.class);
        importPage.setNextPage(true);
        dataModel.setImportFinished(true);
    }

    private void restartUpgradeTool() {
        boolean openNewLiferayProjectWizard = MessageDialog.openQuestion((Shell)UIUtil.getActiveShell(), (String)"Restart code upgrade?", (String)"All previous configuration files will be deleted. Do you want to restart the code upgrade tool?");
        if (openNewLiferayProjectWizard) {
            CustomJspConverter.clearConvertResults();
            try {
                MigrationProblemsContainer container = (MigrationProblemsContainer)UpgradeAssistantSettingsUtil.getObjectFromStore(MigrationProblemsContainer.class);
                if (container != null) {
                    UpgradeAssistantSettingsUtil.setObjectToStore(MigrationProblemsContainer.class, null);
                }
            }
            catch (IOException excepiton) {
                ProjectUI.logError(excepiton);
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            UpgradeView view = (UpgradeView)UIUtil.findView((String)ID);
            CustomJspConverter.clearConvertResults();
            page.hideView((IViewPart)view);
            UpgradeSettingsUtil.resetStoreProperties();
            try {
                page.showView(ID);
            }
            catch (PartInitException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void setFocus() {
    }

    @Override
    public void onSelectionChanged(int targetSelection) {
        StackLayout stackLayout = (StackLayout)pagesSwitchControler.getLayout();
        stackLayout.topControl = pages[targetSelection];
        pagesSwitchControler.layout();
    }

    private class LiferayUpgradeStoreListener
    extends Listener {
        private LiferayUpgradeStoreListener() {
        }

        public void handle(Event event) {
            if (event instanceof ValuePropertyContentEvent) {
                ValuePropertyContentEvent propertyEvetn = (ValuePropertyContentEvent)event;
                Property property = propertyEvetn.property();
                UpgradeSettingsUtil.storeProperty(property.name(), property.toString());
            }
        }
    }

    public static interface PageActionListener {
        public void onPageAction(PageActionEvent var1);
    }

    public static interface PageNavigatorListener {
        public void onPageNavigate(PageNavigateEvent var1);
    }

    public static interface PageValidationListener {
        public void onValidation(PageValidateEvent var1);
    }
}

