/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.jsf;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.portlet.core.dd.LiferayPortletDescriptorHelper;
import com.liferay.ide.portlet.core.jsf.INewJSFPortletClassDataModelProperties;
import com.liferay.ide.project.core.descriptor.IDescriptorOperation;
import com.liferay.ide.project.core.descriptor.LiferayDescriptorHelper;
import com.liferay.ide.project.core.descriptor.UpdateDescriptorVersionOperation;
import com.liferay.ide.server.util.ServerUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.osgi.framework.Version;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSFLiferayPortletDescriptorHelper
extends LiferayPortletDescriptorHelper
implements INewJSFPortletClassDataModelProperties {
    public JSFLiferayPortletDescriptorHelper() {
    }

    public JSFLiferayPortletDescriptorHelper(IProject project) {
        super(project);
    }

    @Override
    protected void addDescriptorOperations() {
        super.addDescriptorOperations();
        this.addDescriptorOperation((IDescriptorOperation)new UpdateDescriptorVersionOperation(){

            public IStatus update(Version preVersion, Version postVersion) {
                if (CoreUtil.compareVersions((Version)preVersion, (Version)ILiferayConstants.V620) >= 0 && CoreUtil.compareVersions((Version)postVersion, (Version)ILiferayConstants.V620) < 0) {
                    IFile descriptorFile = JSFLiferayPortletDescriptorHelper.this.getDescriptorFile();
                    IDOMModel domModel = null;
                    try {
                        domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(descriptorFile);
                        IDOMDocument document = domModel.getDocument();
                        IStatus status = JSFLiferayPortletDescriptorHelper.this.downgradeJSFLiferayPortletXMLTo61(document);
                        if (!status.isOK()) {
                            IStatus iStatus = status;
                            return iStatus;
                        }
                        try {
                            domModel.save();
                        }
                        catch (Exception e) {
                            PortletCore.logError("Error editing liferay-portlet.xml", e);
                        }
                    }
                    finally {
                        if (domModel != null) {
                            domModel.releaseFromEdit();
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        });
    }

    @Override
    protected boolean canAddNewPortlet(IDataModel model) {
        return model.getID().contains("NewJSFPortlet");
    }

    @Override
    protected IStatus doAddNewPortlet(IDOMDocument document, IDataModel model) {
        IFile descriptorFile;
        IStatus status = Status.OK_STATUS;
        status = super.doAddNewPortlet(document, model);
        if (!status.isOK()) {
            return status;
        }
        Version runtimeVersion = ServerUtil.getRuntimeVersion((IProject)this.project);
        if (CoreUtil.compareVersions((Version)runtimeVersion, (Version)ILiferayConstants.V620) >= 0 && (descriptorFile = this.getDescriptorFile()) != null) {
            LiferayDescriptorHelper.DOMModelEditOperation op = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

                protected void createDefaultFile() {
                }

                protected IStatus doExecute(IDOMDocument document) {
                    return JSFLiferayPortletDescriptorHelper.this.updateJSFLiferayPortletXMLTo62(document);
                }
            };
            status = op.execute();
        }
        return status;
    }

    private IStatus downgradeJSFLiferayPortletXMLTo61(IDOMDocument document) {
        Element rootElement = document.getDocumentElement();
        NodeList requiresELements = rootElement.getElementsByTagName("requires-namespaced-parameters");
        int i = 0;
        while (i < requiresELements.getLength()) {
            Node requiresElement = requiresELements.item(i);
            Node prevNode = requiresElement.getPreviousSibling();
            Node parentNode = requiresElement.getParentNode();
            if (prevNode != null && prevNode.getNodeType() == 3 && prevNode.getNodeValue().trim().length() == 0) {
                parentNode.removeChild(prevNode);
            }
            parentNode.removeChild(requiresElement);
            ++i;
        }
        new FormatProcessorXML().formatNode((Node)rootElement);
        return Status.OK_STATUS;
    }

    private IStatus updateJSFLiferayPortletXMLTo62(IDOMDocument document) {
        Element rootElement = document.getDocumentElement();
        NodeList portletNodes = rootElement.getElementsByTagName("portlet");
        if (portletNodes.getLength() > 1) {
            Element lastPortletElement = (Element)portletNodes.item(portletNodes.getLength() - 1);
            Node headerPortletClassElement = lastPortletElement.getElementsByTagName("header-portlet-css").item(0);
            NodeUtil.insertChildElement((Element)lastPortletElement, (Node)headerPortletClassElement, (String)"requires-namespaced-parameters", (String)"false");
            new FormatProcessorXML().formatNode((Node)lastPortletElement);
        }
        return Status.OK_STATUS;
    }
}

