/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.jsf;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.portlet.core.dd.PortletDescriptorHelper;
import com.liferay.ide.portlet.core.jsf.INewJSFPortletClassDataModelProperties;
import com.liferay.ide.portlet.core.operation.NewPortletClassDataModelProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.osgi.util.NLS;

public class NewJSFPortletClassDataModelProvider
extends NewPortletClassDataModelProvider
implements INewJSFPortletClassDataModelProperties {
    public NewJSFPortletClassDataModelProvider(boolean fragment) {
        super(fragment);
    }

    @Override
    protected Object getInitParams() {
        ArrayList initParams = new ArrayList();
        if (this.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_JSPS")) {
            String[] modes = ALL_JSF_PORTLET_MODES;
            String[] names = new String[]{"javax.portlet.faces.defaultViewId.view", "javax.portlet.faces.defaultViewId.edit", "javax.portlet.faces.defaultViewId.help"};
            String[] values = new String[]{"/view.xhtml", "/edit.xhtml", "/help.xhtml"};
            ParamValue[] paramVals = this.createDefaultParamValuesForModes(modes, names, values);
            Collections.addAll(initParams, paramVals);
        }
        return initParams;
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        if ("NewJavaClassDataModel.CLASS_NAME".equals(propertyName)) {
            return "NewJSFPortlet";
        }
        if ("INewJSFPortletClassDataModelProperties.JSF_PORTLET_CLASS".equals(propertyName)) {
            return "javax.portlet.faces.GenericFacesPortlet";
        }
        if ("NewServletClassDataModel.USE_EXISTING_CLASS".equals(propertyName)) {
            return true;
        }
        if ("INewPortletClassDataModelProperties.CREATE_JSPS_FOLDER".equals(propertyName)) {
            return "/WEB-INF/views/" + this.getProperty("INewPortletClassDataModelProperties.PORTLET_NAME").toString().toLowerCase();
        }
        if ("INewPortletClassDataModelProperties.SHOW_NEW_CLASS_OPTION".equals(propertyName)) {
            return false;
        }
        if ("INewJSFPortletClassDataModelProperties.ICE_FACES".equals(propertyName)) {
            return false;
        }
        if ("INewJSFPortletClassDataModelProperties.LIFERAY_FACES_ALLOY".equals(propertyName)) {
            return false;
        }
        if ("INewJSFPortletClassDataModelProperties.PRIME_FACES".equals(propertyName)) {
            return false;
        }
        if ("INewJSFPortletClassDataModelProperties.RICH_FACES".equals(propertyName)) {
            return false;
        }
        if ("INewJSFPortletClassDataModelProperties.STANDARD_JSF".equals(propertyName)) {
            return true;
        }
        return super.getDefaultProperty(propertyName);
    }

    @Override
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("INewJSFPortletClassDataModelProperties.ICE_FACES");
        propertyNames.add("INewJSFPortletClassDataModelProperties.JSF_PORTLET_CLASS");
        propertyNames.add("INewJSFPortletClassDataModelProperties.LIFERAY_FACES_ALLOY");
        propertyNames.add("INewJSFPortletClassDataModelProperties.PRIME_FACES");
        propertyNames.add("INewJSFPortletClassDataModelProperties.RICH_FACES");
        propertyNames.add("INewJSFPortletClassDataModelProperties.STANDARD_JSF");
        return propertyNames;
    }

    @Override
    public IStatus validate(String propertyName) {
        if ("INewPortletClassDataModelProperties.PORTLET_NAME".equals(propertyName)) {
            IStatus status = super.validate(propertyName);
            if (!status.isOK()) {
                return status;
            }
            String currentPortletName = this.getStringProperty("INewPortletClassDataModelProperties.PORTLET_NAME");
            PortletDescriptorHelper helper = new PortletDescriptorHelper(this.getTargetProject());
            String[] stringArray = helper.getAllPortletNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String portletName = stringArray[n2];
                if (currentPortletName.equals(portletName)) {
                    return PortletCore.createErrorStatus(Msgs.duplicatePortletName);
                }
                ++n2;
            }
        }
        if ("INewJSFPortletClassDataModelProperties.JSF_PORTLET_CLASS".equals(propertyName)) {
            String jsfPortletClass = this.getStringProperty(propertyName);
            if (CoreUtil.isNullOrEmpty((String)jsfPortletClass)) {
                return PortletCore.createErrorStatus(Msgs.specifyJSFPortletClass);
            }
            if (this.fragment) {
                return Status.OK_STATUS;
            }
            if (!this.isValidPortletClass(jsfPortletClass)) {
                return PortletCore.createErrorStatus(Msgs.jsfPortletClassValid);
            }
        }
        if ("NewJavaClassDataModel.SUPERCLASS".equals(propertyName)) {
            return Status.OK_STATUS;
        }
        if ("INewPortletClassDataModelProperties.CREATE_JSPS_FOLDER".equals(propertyName)) {
            if (!this.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_JSPS")) {
                return Status.OK_STATUS;
            }
            String jspsFolder = this.getStringProperty(propertyName);
            if (CoreUtil.isNullOrEmpty((String)jspsFolder)) {
                return PortletCore.createErrorStatus(Msgs.jspFolderNotEmpty);
            }
            if (!jspsFolder.startsWith("/WEB-INF/") && !jspsFolder.startsWith("WEB-INF/")) {
                return PortletCore.createErrorStatus(Msgs.jsfFolderValid);
            }
            IFolder viewFolder = CoreUtil.getDefaultDocrootFolder((IProject)this.getProject()).getFolder(jspsFolder);
            if (viewFolder.exists() && viewFolder.getFile("view.xhtml").exists()) {
                return PortletCore.createWarningStatus(Msgs.viewFileAlreadyExists);
            }
        }
        return super.validate(propertyName);
    }

    private static class Msgs
    extends NLS {
        public static String jspFolderNotEmpty;
        public static String viewFileAlreadyExists;
        public static String duplicatePortletName;
        public static String jsfFolderValid;
        public static String jsfPortletClassValid;
        public static String specifyJSFPortletClass;

        static {
            Msgs.initializeMessages((String)NewJSFPortletClassDataModelProvider.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

