/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.lfportlet.model.internal;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.modeling.annotations.FileExtensions;

public class LiferayScriptPossibleValuesService
extends PossibleValuesService {
    private String type;

    protected void compute(Set<String> values) {
        Element modeElement = (Element)this.context(Element.class);
        List exts = modeElement.parent().definition().getAnnotations(FileExtensions.class);
        if (exts != null && exts.size() > 0) {
            IPath location;
            IFolder webappRoot;
            this.type = ((FileExtensions)exts.get(0)).expr();
            IProject project = (IProject)modeElement.adapt(IProject.class);
            if (project != null && (webappRoot = CoreUtil.getDefaultDocrootFolder((IProject)project)) != null && (location = webappRoot.getLocation()) != null && location.toFile().exists()) {
                values.addAll(new PropertiesVisitor().visitScriptFiles((IResource)webappRoot, this.type, values));
            }
        }
    }

    public boolean strict() {
        return false;
    }

    private static class PropertiesVisitor
    implements IResourceProxyVisitor {
        IResource entryResource = null;
        String type = null;
        Set<String> values = null;

        private PropertiesVisitor() {
        }

        public boolean visit(IResourceProxy resourceProxy) {
            IResource resource;
            if (resourceProxy.getType() == 1 && resourceProxy.getName().endsWith(this.type) && (resource = resourceProxy.requestResource()).exists()) {
                String relativePath = resource.getLocation().makeRelativeTo(this.entryResource.getLocation()).toString();
                try {
                    if (!relativePath.startsWith("/")) {
                        this.values.add("/" + relativePath);
                    }
                }
                catch (Exception e) {
                    return true;
                }
            }
            return true;
        }

        public Set<String> visitScriptFiles(IResource container, String type, Set<String> values) {
            this.entryResource = container;
            this.type = type;
            this.values = values;
            try {
                container.accept((IResourceProxyVisitor)this, 4);
            }
            catch (CoreException e) {
                LiferayCore.logError((Throwable)e);
            }
            return values;
        }
    }
}

