/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.model.internal;

import com.liferay.ide.portlet.core.model.QName;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class NameOrQnameValidationService
extends ValidationService {
    private Listener listener;

    public Status compute() {
        Element element = (Element)this.context(Element.class);
        String elementLabel = element.type().getLabel(false, CapitalizationType.FIRST_WORD_ONLY, false);
        QName iqName = null;
        String name = null;
        String nsURI = null;
        String localPart = null;
        if (element instanceof QName) {
            iqName = (QName)element;
            nsURI = iqName.getNamespaceURI().text(false);
            localPart = iqName.getLocalPart().text(false);
        }
        if (this.isEmptyOrNull(name) && this.isEmptyOrNull(nsURI) && this.isEmptyOrNull(localPart)) {
            return Status.createErrorStatus((String)Resources.bind((String)Resources.message, (Object)elementLabel));
        }
        if (this.isEmptyOrNull(name) && (this.isEmptyOrNull(nsURI) || this.isEmptyOrNull(localPart))) {
            return Status.createErrorStatus((String)Resources.bind((String)Resources.invalidQname, (Object)elementLabel));
        }
        return Status.createOkStatus();
    }

    protected void initValidationService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                NameOrQnameValidationService.this.refresh();
            }
        };
        this.op().getLocalPart().attach(this.listener);
        this.op().getNamespaceURI().attach(this.listener);
    }

    private boolean isEmptyOrNull(String text) {
        return text == null || text.trim().length() == 0;
    }

    private QName op() {
        return (QName)this.context(QName.class);
    }

    private static final class Resources
    extends NLS {
        public static String message;
        public static String invalidQname;

        static {
            Resources.initializeMessages((String)NameOrQnameValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

