/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui;

import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.PluginsContent;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;

public class PluginsCustomLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        if (element instanceof PluginsContent) {
            return LiferayServerUI.imageDescriptorFromPlugin((String)"com.liferay.ide.server.ui", (String)"/icons/e16/plugin.png").createImage();
        }
        if (element instanceof ModuleServer) {
            try {
                ModuleServer server = (ModuleServer)element;
                IModule module = server.getModule()[server.module.length - 1];
                if ("jst.web".equals(module.getModuleType().getId())) {
                    IProject project = module.getProject();
                    IFacetedProject facetedProject = ProjectUtil.getFacetedProject((IProject)project);
                    String imageKey = null;
                    if (facetedProject != null) {
                        IProjectFacet liferayFacet = ProjectUtil.getLiferayFacet((IFacetedProject)facetedProject);
                        if (liferayFacet != null) {
                            String id = liferayFacet.getId();
                            imageKey = id.substring(id.indexOf(46) + 1, id.length());
                        }
                    } else {
                        imageKey = ProjectUtil.getLiferayPluginType((String)project.getLocation().toOSString());
                    }
                    return LiferayServerUI.getDefault().getImageRegistry().get(imageKey);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof PluginsContent) {
            return Msgs.liferayPlugins;
        }
        return null;
    }

    private static class Msgs
    extends NLS {
        public static String liferayPlugins;

        static {
            Msgs.initializeMessages((String)PluginsCustomLabelProvider.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

