/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.portal;

import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.ui.portal.PortalRuntimeComposite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class PortalRuntimeWizard
extends WizardFragment {
    private PortalRuntimeComposite composite;

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.composite = new PortalRuntimeComposite(parent, handle);
        return this.composite;
    }

    public boolean hasComposite() {
        return true;
    }

    public void enter() {
        if (this.composite != null) {
            IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
            this.composite.setRuntime(runtime);
        }
    }

    public void exit() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        IPath path = runtime.getLocation();
        if (runtime.validate(null).getSeverity() != 4) {
            LiferayServerCore.setPreference((String)("location." + runtime.getRuntimeType().getId()), (String)path.toPortableString());
        }
    }

    public boolean isComplete() {
        boolean retval = false;
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (runtime != null) {
            IStatus status = runtime.validate(null);
            retval = status == null || status.getSeverity() != 4;
        }
        return retval;
    }
}

