/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.util;

import com.liferay.ide.core.util.CoreUtil;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ServerUIUtil {
    private static final String VARIABLE_FOLDER = "${selected_resource_parent_loc}";
    private static final String VARIABLE_RESOURCE = "${selected_resource_loc}";
    private static final String VARIABLE_RESOURCE_URI = "${selected_resource_uri}";

    public static String getSystemExplorerCommand(File file) throws IOException {
        String retval = null;
        String command = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SYSTEM_EXPLORER");
        if (!CoreUtil.isNullOrEmpty((String)command)) {
            command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE, (String)ServerUIUtil.quotePath(file.getCanonicalPath()));
            command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE_URI, (String)file.getCanonicalFile().toURI().toString());
            File parent = file.getParentFile();
            if (parent != null) {
                retval = Util.replaceAll((String)command, (String)VARIABLE_FOLDER, (String)ServerUIUtil.quotePath(parent.getCanonicalPath()));
            }
        }
        return retval;
    }

    public static void openFileInSystemExplorer(IPath path) throws IOException {
        String launchCmd = ServerUIUtil.getSystemExplorerCommand(path.toFile());
        if (!CoreUtil.isNullOrEmpty((String)launchCmd)) {
            if (path.toFile().isFile()) {
                path = path.removeLastSegments(1);
            }
            ServerUIUtil.openInSystemExplorer(launchCmd, path.toFile());
        }
    }

    public static void openInSystemExplorer(String systemCommand, File file) throws IOException {
        if (Util.isLinux() || Util.isMac()) {
            Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", systemCommand}, null, file);
        } else {
            Runtime.getRuntime().exec(systemCommand, null, file);
        }
    }

    public static String quotePath(String path) {
        if (CoreUtil.isLinux() || CoreUtil.isMac()) {
            path = path.replaceAll("[\"$`]", "\\\\$0");
        }
        return path;
    }
}

