/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.asciidoc.core.token;

import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;

class XrefReplacementTokenProcessor
extends PatternBasedElementProcessor {
    private final int linkTextOffset;

    public XrefReplacementTokenProcessor(int linkTextOffset) {
        this.linkTextOffset = linkTextOffset;
    }

    public void emit() {
        this.builder.link(this.linkTarget(), this.linkText());
    }

    private String linkTarget() {
        String target = this.linkTargetCaptureGroup();
        if (!target.contains("#")) {
            target = "#" + target;
        } else if (target.charAt(target.length() - 1) == '#') {
            target = target.substring(0, target.length() - 1);
        }
        return target;
    }

    private String linkText() {
        String linkText = this.linkTextCaptureGroup();
        StringBuilder buffer = new StringBuilder();
        if (linkText != null && linkText.length() > this.linkTextOffset) {
            buffer.append(linkText.substring(this.linkTextOffset).trim());
        } else {
            buffer.append("[");
            String target = this.linkTargetCaptureGroup();
            int hashPosition = target.indexOf("#");
            if (hashPosition > 0) {
                int extStart = target.substring(0, hashPosition).lastIndexOf(".");
                if (extStart > 0) {
                    buffer.append(target.substring(0, extStart));
                } else {
                    buffer.append(target.substring(0, hashPosition));
                }
                if (hashPosition != target.length() - 1) {
                    buffer.append(target.substring(hashPosition));
                }
            } else {
                buffer.append(target);
            }
            buffer.append("]");
        }
        return buffer.toString();
    }

    private String linkTargetCaptureGroup() {
        return this.group(1);
    }

    private String linkTextCaptureGroup() {
        return this.group(2);
    }
}

