/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core;

import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractRegistryManager
implements IRegistryChangeListener {
    private boolean registryListenerIntialized = false;

    public void initialize() {
    }

    public void destroy() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    protected void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            registry.addRegistryChangeListener((IRegistryChangeListener)this, this.getPluginId());
        }
        this.registryListenerIntialized = true;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas(this.getPluginId(), this.getExtensionPoint());
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleExtensionDelta(delta);
                ++n2;
            }
        }
    }

    protected abstract void handleExtensionDelta(IExtensionDelta var1);

    protected abstract String getPluginId();

    protected abstract String getExtensionPoint();
}

