/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.queryspecifications;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.internal.Trace;
import org.eclipse.wst.xml.search.core.internal.queryspecifications.XMLQuerySpecification;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.util.StringUtils;

public class XMLQuerySpecificationManager
extends AbstractRegistryManager {
    private static final XMLQuerySpecificationManager INSTANCE = new XMLQuerySpecificationManager();
    private static final String XML_QUERY_SPECIFICATIONS_EXTENSION_POINT = "querySpecifications";
    private Map<String, IXMLQuerySpecification> querySpecificationsById = null;

    public static XMLQuerySpecificationManager getDefault() {
        return INSTANCE;
    }

    @Override
    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.querySpecificationsById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addQuerySpecifications(this.querySpecificationsById, cf);
        }
    }

    public IXMLQuerySpecification getQuerySpecification(String querySpecificationId) {
        IXMLQuerySpecification querySpecification;
        if (StringUtils.isEmpty(querySpecificationId)) {
            return XMLQuerySpecification.INSTANCE;
        }
        if (this.querySpecificationsById == null) {
            this.loadQuerySpecifications();
        }
        if ((querySpecification = this.querySpecificationsById.get(querySpecificationId)) == null) {
            querySpecification = XMLQuerySpecification.INSTANCE;
            this.querySpecificationsById.put(querySpecificationId, querySpecification);
        }
        return querySpecification;
    }

    private synchronized void loadQuerySpecifications() {
        if (this.querySpecificationsById != null) {
            return;
        }
        HashMap<String, IXMLQuerySpecification> querySpecificationsById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.core", XML_QUERY_SPECIFICATIONS_EXTENSION_POINT);
            querySpecificationsById = new HashMap(cf.length);
            this.addQuerySpecifications(querySpecificationsById, cf);
        } else {
            querySpecificationsById = new HashMap<String, IXMLQuerySpecification>();
        }
        this.querySpecificationsById = querySpecificationsById;
        super.addRegistryListenerIfNeeded();
    }

    private synchronized void addQuerySpecifications(Map<String, IXMLQuerySpecification> querySpecificationsById, IConfigurationElement[] cf) {
        String id = null;
        IXMLQuerySpecification querySpecification = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            id = ce.getAttribute("id");
            try {
                querySpecification = XMLQuerySpecification.newQuerySpecification(ce.createExecutableExtension("class"));
                querySpecificationsById.put(id, querySpecification);
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load querySpecification for id: " + id, t);
            }
            ++n2;
        }
    }

    @Override
    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.core";
    }

    @Override
    protected String getExtensionPoint() {
        return XML_QUERY_SPECIFICATIONS_EXTENSION_POINT;
    }
}

