/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.util.ListFactory;

public final class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static <E> E findPrecedingItem(List<E> list, E item) {
        E lastSeenItem = null;
        for (E x : list) {
            if (x == item) {
                return lastSeenItem;
            }
            lastSeenItem = x;
        }
        return null;
    }

    public static <E> E findTrailingItem(List<E> list, E item) {
        boolean takeNextItem = false;
        for (E x : list) {
            if (takeNextItem) {
                return x;
            }
            if (x != item) continue;
            takeNextItem = true;
        }
        return null;
    }

    public static <V> V findIgnoringCase(Map<?, V> map, String key) {
        V value = map.get(key);
        if (value == null) {
            for (Map.Entry<?, V> entry : map.entrySet()) {
                Object entryKey = entry.getKey();
                if (!(entryKey instanceof String) || !((String)entryKey).equalsIgnoreCase(key)) continue;
                value = entry.getValue();
                break;
            }
        }
        return value;
    }

    public static <T> boolean equalsBasedOnEntryIdentity(List<T> a, List<T> b) {
        int bSize;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int aSize = a.size();
        if (aSize == (bSize = b.size())) {
            int i = 0;
            while (i < aSize) {
                if (a.get(i) != b.get(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean containsBasedOnEntryIdentity(List<?> list, Object object) {
        for (Object obj : list) {
            if (obj != object) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> removedBasedOnEntryIdentity(List<? extends T> a, List<? extends T> b) {
        ListFactory<T> result = ListFactory.start();
        for (T obj : a) {
            if (CollectionsUtil.containsBasedOnEntryIdentity(b, obj)) continue;
            result.add(obj);
        }
        return result.result();
    }
}

