/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.core.debugger;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import tern.TernException;
import tern.eclipse.ide.server.nodejs.core.debugger.launchConfigurations.NodejsCliFileHelper;
import tern.server.nodejs.process.AbstractNodejsProcess;
import tern.server.nodejs.process.NodejsProcessException;
import tern.utils.TernModuleHelper;

public abstract class AbstractNodejsDebugProcess
extends AbstractNodejsProcess {
    private final IFile jsFile;
    private final String launchConfigId;
    private final List<StreamProcessor> streamProcessors;
    protected ILaunch launch;

    public AbstractNodejsDebugProcess(IFile jsFile, File workingDir, File nodejsInstallPath, String launchConfigId) throws TernException {
        super(nodejsInstallPath, workingDir);
        this.jsFile = jsFile;
        this.launchConfigId = launchConfigId;
        this.streamProcessors = new ArrayList<StreamProcessor>();
    }

    protected String getNodeInstallPath() {
        return TernModuleHelper.getPath((File)this.nodejsBaseDir);
    }

    protected String getWorkingDir() {
        return NodejsCliFileHelper.getWorkspaceLoc(this.getProjectDir());
    }

    protected void notifyStopProcess() {
        for (StreamProcessor proc : this.streamProcessors) {
            proc.close();
        }
        super.notifyStopProcess();
    }

    public void start() throws NodejsProcessException {
        if (this.isStarted()) {
            this.notifyErrorProcess("Nodejs tern Server is already started.");
            throw new NodejsProcessException("Nodejs tern Server is already started.");
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.launchConfigId);
            String launchName = this.generateConfigurationName();
            ILaunchConfigurationWorkingCopy workingCopy = null;
            ILaunchConfiguration configuration = this.getExistingLaunchConfiguration(type, launchName);
            workingCopy = configuration != null ? configuration.getWorkingCopy() : type.newInstance(null, manager.generateLaunchConfigurationName(launchName));
            this.start(workingCopy);
            if (this.isSaveLaunch()) {
                workingCopy.doSave();
            }
        }
        catch (Exception e) {
            if (e instanceof NodejsProcessException) {
                throw (NodejsProcessException)e;
            }
            throw new NodejsProcessException((Throwable)e);
        }
    }

    private ILaunchConfiguration getExistingLaunchConfiguration(ILaunchConfigurationType type, String launchName) throws CoreException {
        ILaunchConfiguration[] configs;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs = manager.getLaunchConfigurations(type);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (config.getName().startsWith(launchName)) {
                return config;
            }
            ++n2;
        }
        return null;
    }

    public boolean isStarted() {
        return this.launch != null && !this.launch.isTerminated();
    }

    public void kill() {
        if (this.launch != null && !this.launch.isTerminated()) {
            try {
                this.launch.terminate();
            }
            catch (DebugException e) {
                throw new RuntimeException(e);
            }
        }
        this.launch = null;
    }

    public void join() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public IFile getJsFile() {
        return this.jsFile;
    }

    protected String getMode() throws NodejsProcessException {
        return this.getLaunchConfiguration().getLaunchMode();
    }

    private boolean isSaveLaunch() throws NodejsProcessException {
        return this.getLaunchConfiguration().isSaveLaunch();
    }

    private boolean isWaitOnPort() {
        try {
            return this.getLaunchConfiguration().isWaitOnPort();
        }
        catch (NodejsProcessException nodejsProcessException) {
            return false;
        }
    }

    private String generateConfigurationName() throws NodejsProcessException {
        return this.getLaunchConfiguration().generateLaunchConfigurationName();
    }

    protected abstract void start(ILaunchConfigurationWorkingCopy var1) throws Exception;

    protected class StdErr
    extends StreamProcessor {
        public StdErr(IStreamMonitor monitor) {
            super(monitor);
        }

        @Override
        protected void processLine(String line) {
            if (!line.startsWith("debugger listening on port")) {
                AbstractNodejsDebugProcess.this.notifyErrorProcess(line);
            }
        }
    }

    protected class StdOut
    extends StreamProcessor {
        private long startTime;

        public StdOut(IStreamMonitor monitor) {
            super(monitor);
            this.startTime = System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processLine(String line) {
            if (AbstractNodejsDebugProcess.this.getPort() == null) {
                if (AbstractNodejsDebugProcess.this.isWaitOnPort()) {
                    if (line.length() > 0) {
                        Integer port = Integer.parseInt(line.substring("Listening on port ".length(), line.length()));
                        AbstractNodejsDebugProcess.this.setPort(port);
                        Object object = AbstractNodejsDebugProcess.this.lock;
                        synchronized (object) {
                            AbstractNodejsDebugProcess.this.lock.notifyAll();
                        }
                        if (this.startTime == 0L) {
                            this.startTime = System.nanoTime();
                        }
                        AbstractNodejsDebugProcess.this.notifyStartProcess(this.startTime);
                    }
                } else {
                    Object object = AbstractNodejsDebugProcess.this.lock;
                    synchronized (object) {
                        AbstractNodejsDebugProcess.this.lock.notifyAll();
                    }
                    if (this.startTime == 0L) {
                        this.startTime = System.nanoTime();
                    }
                    AbstractNodejsDebugProcess.this.notifyStartProcess(this.startTime);
                    AbstractNodejsDebugProcess.this.notifyDataProcess(line);
                }
            } else {
                AbstractNodejsDebugProcess.this.notifyDataProcess(line);
            }
        }
    }

    private abstract class StreamProcessor
    implements IStreamListener {
        private StringBuilder lineBuilder = new StringBuilder();
        private IStreamMonitor monitor;

        public StreamProcessor(IStreamMonitor monitor) {
            this.monitor = monitor;
            monitor.addListener((IStreamListener)this);
            AbstractNodejsDebugProcess.this.streamProcessors.add(this);
            this.streamAppended(monitor.getContents(), monitor);
        }

        public void close() {
            this.streamAppended("\n", this.monitor);
            this.monitor.removeListener((IStreamListener)this);
        }

        public synchronized void streamAppended(String text, IStreamMonitor monitor) {
            int pos = 0;
            int lastPos = 0;
            while ((pos = text.indexOf(10, pos)) >= 0) {
                this.lineBuilder.append(text.substring(0, pos++));
                lastPos = pos;
                if (this.lineBuilder.length() > 0) {
                    this.processLine(this.lineBuilder.toString());
                }
                this.lineBuilder.setLength(0);
            }
            this.lineBuilder.append(text.substring(lastPos));
        }

        protected abstract void processLine(String var1);
    }
}

