/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.sdk.core;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileListing;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.sdk.core.AntPropertyCopy;
import com.liferay.ide.sdk.core.CreateHelper;
import com.liferay.ide.sdk.core.ISDKConstants;
import com.liferay.ide.sdk.core.SDKCorePlugin;
import com.liferay.ide.sdk.core.SDKHelper;
import com.liferay.ide.sdk.core.SDKUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Dirname;
import org.apache.tools.ant.taskdefs.Property;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.internal.core.XMLMemento;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class SDK {
    public static final List<String> APP_SERVER_PROPERTIES_KEYS = Collections.unmodifiableList(Arrays.asList("app.server.type", "app.server.dir", "app.server.deploy.dir", "app.server.lib.global.dir", "app.server.parent.dir", "app.server.portal.dir"));
    public static final Map<String, Map<String, Object>> buildPropertiesCache = new HashMap<String, Map<String, Object>>();
    public static final List<String> SUPPORTED_SERVER_TYPES = Collections.unmodifiableList(Arrays.asList("tomcat", "jboss", "glassfish", "jetty", "wildfly"));
    protected boolean contributed;
    protected boolean defaultSDK;
    protected IPath location;
    protected String name;
    protected String version;

    public SDK() {
    }

    public SDK(IPath location) {
        this.location = location;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addOrUpdateServerProperties(IPath newServerPath) throws IOException {
        Project project = this.getSDKAntProject();
        String[] buildFileNames = new String[]{"build." + project.getProperty("user.name") + ".properties", "build." + project.getProperty("env.COMPUTERNAME") + ".properties", String.valueOf(project.getProperty("env.HOST")) + ".properties", String.valueOf(project.getProperty("env.HOSTNAME")) + ".properties"};
        File buildFile = null;
        String[] stringArray = buildFileNames;
        int n = buildFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (this.getLocation().append(name).toFile().exists()) {
                buildFile = this.getLocation().append(name).toFile();
                break;
            }
            ++n2;
        }
        if (buildFile == null) {
            buildFile = new File(this.getLocation().append("build." + project.getProperty("user.name") + ".properties").toString());
            buildFile.createNewFile();
        }
        Properties p = new Properties();
        Throwable throwable = null;
        Object var7_7 = null;
        try {
            FileInputStream in = new FileInputStream(buildFile);
            try {
                try (FileOutputStream out = new FileOutputStream(buildFile);){
                    p.load(in);
                    if (p.containsKey("app.server.parent.dir")) {
                        p.put("app.server.parent.dir", newServerPath.toPortableString());
                    } else {
                        p.put("app.server.parent.dir", newServerPath.toPortableString());
                    }
                    p.store(out, "");
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public IStatus buildLanguage(IProject project, IFile langFile, Map<String, String> overrideProperties, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            String langDirLocation = langFile.getParent().getRawLocation().toOSString();
            String langFileName = langFile.getFullPath().removeFileExtension().lastSegment();
            properties.put("lang.dir", langDirLocation);
            properties.put("lang.file", langFileName);
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "build-lang-cmd", properties, true, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public IStatus buildService(IProject project, IFile serviceXmlFile, Map<String, String> overrideProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            String serviceFile = serviceXmlFile.getRawLocation().toOSString();
            properties.put("service.file", serviceXmlFile.getRawLocation().toOSString());
            properties.put("service.input.file", serviceFile);
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "build-service", properties, true, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public IStatus buildWSDD(IProject project, IFile serviceXmlFile, Map<String, String> overrideProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            String serviceFile = serviceXmlFile.getRawLocation().toOSString();
            properties.put("service.file", serviceXmlFile.getRawLocation().toOSString());
            properties.put("service.input.file", serviceFile);
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "build-wsdd", properties, true, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public IStatus cleanAppServer(IProject project, String bundleZipLocation, String appServerDir, IProgressMonitor monitor) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            IPath workPath = new Path(appServerDir).removeLastSegments(2);
            properties.put("app.server.zip.name", bundleZipLocation);
            properties.put("ext.work.dir", workPath.toOSString());
            IStatus status = this.runTarget(project, properties, "clean-app-server", true, monitor);
            if (!status.isOK()) {
                return status;
            }
        }
        catch (Exception ex) {
            return SDKCorePlugin.createErrorStatus(ex);
        }
        return Status.OK_STATUS;
    }

    public IStatus compileThemePlugin(IProject project, Map<String, String> overrideProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "compile", properties, true, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public SDK copy() {
        SDK copy = new SDK(this.getLocation());
        copy.setContributed(this.isContributed());
        copy.setDefault(this.isDefault());
        copy.setName(this.getName());
        copy.setVersion(this.getVersion());
        return copy;
    }

    public IPath createNewExtProject(String extName, String extDisplayName, boolean separateJRE, String workingDir, String baseDir, IProgressMonitor monitor) {
        try {
            SDKHelper antHelper = new SDKHelper(this, monitor);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("ext.name", extName);
            properties.put("ext.display.name", extDisplayName);
            IPath tempPath = SDKCorePlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("ext.parent.dir", tempPath.toOSString());
            if (baseDir != null) {
                properties.put("plugin.type.dir", baseDir);
            }
            antHelper.runTarget(this.getLocation().append(ISDKConstants.EXT_PLUGIN_ANT_BUILD), "create", properties, separateJRE, workingDir);
            return tempPath;
        }
        catch (Exception e) {
            SDKCorePlugin.logError(e);
            return null;
        }
    }

    public IPath createNewHookProject(String hookName, String hookDisplayName, boolean separateJRE, String workingDir, String baseDir, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("hook.name", hookName);
            properties.put("hook.display.name", hookDisplayName);
            IPath newHookPath = SDKCorePlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("hook.parent.dir", newHookPath.toOSString());
            IPath buildLocation = this.getLocation().append(ISDKConstants.HOOK_PLUGIN_ANT_BUILD);
            if (baseDir != null) {
                properties.put("plugin.type.dir", baseDir);
            }
            antHelper.runTarget(buildLocation, "create", properties, separateJRE, workingDir);
            return newHookPath;
        }
        catch (Exception e) {
            SDKCorePlugin.logError(e);
            return null;
        }
    }

    public IPath createNewLayoutTplProject(String layoutTplName, String layoutTplDisplayName, boolean separateJRE, String workingDir, String baseDir, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("layouttpl.name", layoutTplName);
            properties.put("layouttpl.display.name", layoutTplDisplayName);
            IPath newLayoutTplPath = SDKCorePlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("layouttpl.parent.dir", newLayoutTplPath.toOSString());
            if (baseDir != null) {
                properties.put("plugin.type.dir", baseDir);
            }
            antHelper.runTarget(this.getLocation().append(ISDKConstants.LAYOUTTPL_PLUGIN_ANT_BUILD), "create", properties, separateJRE, workingDir);
            return newLayoutTplPath;
        }
        catch (Exception e) {
            SDKCorePlugin.logError(e);
            return null;
        }
    }

    public IPath createNewPortletProject(String portletName, String portletDisplayName, String portletFramework, boolean separateJRE, String workingDir, String baseDir, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("portlet.name", portletName);
            properties.put("portlet.display.name", portletDisplayName);
            properties.put("portlet.framework", portletFramework);
            IPath newPortletPath = SDKCorePlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("portlet.parent.dir", newPortletPath.toOSString());
            if (baseDir != null) {
                properties.put("plugin.type.dir", baseDir);
            }
            antHelper.runTarget(this.getLocation().append(ISDKConstants.PORTLET_PLUGIN_ANT_BUILD), "create", properties, separateJRE, workingDir);
            return newPortletPath;
        }
        catch (Exception e) {
            SDKCorePlugin.logError(e);
            return null;
        }
    }

    public IPath createNewProject(String projectName, ArrayList<String> arguments, String type, String workingDir, IProgressMonitor monitor) throws CoreException {
        CreateHelper createHelper = new CreateHelper(this, monitor);
        IPath pluginFolder = this.getLocation().append(this.getPluginFolder(type));
        IPath newPath = pluginFolder.append(String.valueOf(projectName) + this.getPluginSuffix(type));
        String createScript = "create.bat";
        if (!CoreUtil.isWindows()) {
            createScript = "create.sh";
        }
        IPath createFilePath = pluginFolder.append(createScript);
        File createFile = createFilePath.toFile();
        String originalCreateConetent = "";
        if (!CoreUtil.isWindows() && createFile.exists() && (originalCreateConetent = FileUtil.readContents((File)createFile, (boolean)true)).contains("DisplayName=\\\"$2\\\"")) {
            String createContent = originalCreateConetent.replace("DisplayName=\\\"$2\\\"", "DisplayName=\"$2\"");
            try {
                FileUtil.writeFile((File)createFile, (InputStream)new ByteArrayInputStream(createContent.toString().getBytes("UTF-8")), null);
            }
            catch (Exception e) {
                SDKCorePlugin.logError(e);
            }
        }
        createHelper.runTarget(createFilePath, arguments, workingDir);
        if (!newPath.toFile().exists()) {
            throw new CoreException(SDKCorePlugin.createErrorStatus("Create script did not complete successfully."));
        }
        if (!CoreUtil.isNullOrEmpty((String)originalCreateConetent)) {
            try {
                FileUtil.writeFile((File)createFile, (InputStream)new ByteArrayInputStream(originalCreateConetent.toString().getBytes("UTF-8")), null);
            }
            catch (Exception e) {
                SDKCorePlugin.logError(e);
            }
        }
        return newPath;
    }

    public IPath createNewThemeProject(String themeName, String themeDisplayName, boolean separateJRE, String workingDir, String baseDir, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("theme.name", themeName);
            properties.put("theme.display.name", themeDisplayName);
            IPath tempPath = SDKCorePlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("theme.parent.dir", tempPath.toOSString());
            if (baseDir != null) {
                properties.put("plugin.type.dir", baseDir);
            }
            antHelper.runTarget(this.getLocation().append(ISDKConstants.THEME_PLUGIN_ANT_BUILD), "create", properties, separateJRE, workingDir);
            return tempPath;
        }
        catch (CoreException e) {
            SDKCorePlugin.logError((Exception)((Object)e));
            return null;
        }
    }

    public IPath createNewWebProject(String webName, String webDisplayName, boolean separateJRE, String workingDir, String baseDir, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("web.name", webName);
            properties.put("web.display.name", webDisplayName);
            IPath newWebPath = SDKCorePlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("web.parent.dir", newWebPath.toOSString());
            IPath buildLocation = this.getLocation().append(ISDKConstants.WEB_PLUGIN_ANT_BUILD);
            if (baseDir != null) {
                properties.put("plugin.type.dir", baseDir);
            }
            antHelper.runTarget(buildLocation, "create", properties, separateJRE, workingDir);
            return newWebPath;
        }
        catch (Exception e) {
            SDKCorePlugin.logError(e);
            return null;
        }
    }

    public String createXMLNameValuePair(String name, String value) {
        return String.valueOf(name) + "=\"" + value + "\" ";
    }

    public IStatus directDeploy(IProject project, Map<String, String> overrideProperties, boolean separateJRE, IProgressMonitor monitor) {
        try {
            SDKHelper antHelper = new SDKHelper(this, monitor);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "direct-deploy", properties, separateJRE, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    private String[] getAntHomeVMArg() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        String antHome = prefs.getAntHome();
        if (!CoreUtil.isNullOrEmpty((String)antHome)) {
            return new String[]{"-Dant.home=\"" + antHome + "\""};
        }
        return null;
    }

    public IPath[] getAntLibraries() {
        ArrayList<IPath> antLibs = new ArrayList<IPath>();
        String[] stringArray = ISDKConstants.ANT_LIBRARIES;
        int n = ISDKConstants.ANT_LIBRARIES.length;
        int n2 = 0;
        while (n2 < n) {
            String antLib = stringArray[n2];
            IPath antLibPath = this.getLocation().append(antLib);
            if (antLibPath.toFile().exists()) {
                antLibs.add(antLibPath);
            }
            ++n2;
        }
        return antLibs.toArray(new IPath[0]);
    }

    public Map<String, Object> getBuildProperties() throws CoreException {
        return this.getBuildProperties(false);
    }

    private Project getSDKAntProject() {
        Project project = new Project();
        project.setBaseDir(new File(this.getLocation().toPortableString()));
        project.setSystemProperties();
        Dirname dirname = new Dirname();
        dirname.setProject(project);
        dirname.setFile(new File(this.getLocation().append("build-common.xml").toPortableString()));
        dirname.setProperty("sdk.dir");
        dirname.execute();
        Property envTask = new Property();
        envTask.setProject(project);
        envTask.setEnvironment("env");
        envTask.execute();
        return project;
    }

    public Map<String, Object> getBuildProperties(boolean reload) throws CoreException {
        Project project = this.getSDKAntProject();
        Hashtable sdkProperties = buildPropertiesCache.get(this.getLocation().toPortableString());
        try {
            if (sdkProperties == null || reload) {
                this.loadPropertiesFile(project, "build." + project.getProperty("user.name") + ".properties");
                this.loadPropertiesFile(project, "build." + project.getProperty("env.COMPUTERNAME") + ".properties");
                this.loadPropertiesFile(project, "build." + project.getProperty("env.HOST") + ".properties");
                this.loadPropertiesFile(project, "build." + project.getProperty("env.HOSTNAME") + ".properties");
                this.loadPropertiesFile(project, "build.properties");
                if (project.getProperty("app.server.type") == null) {
                    throw new CoreException(SDKCorePlugin.createErrorStatus("Missing ${app.server.type} setting in build.properties file."));
                }
                HashMap<String, String> propertyCopyList = new HashMap<String, String>();
                propertyCopyList.put("app.server." + project.getProperty("app.server.type") + ".dir", "app.server.dir");
                propertyCopyList.put("app.server." + project.getProperty("app.server.type") + ".deploy.dir", "app.server.deploy.dir");
                propertyCopyList.put("app.server." + project.getProperty("app.server.type") + ".lib.global.dir", "app.server.lib.global.dir");
                propertyCopyList.put("app.server." + project.getProperty("app.server.type") + ".portal.dir", "app.server.portal.dir");
                for (String key : propertyCopyList.keySet()) {
                    AntPropertyCopy propertyCopyTask = new AntPropertyCopy();
                    propertyCopyTask.setOverride(true);
                    propertyCopyTask.setProject(project);
                    String from = key;
                    String to = (String)propertyCopyList.get(from);
                    propertyCopyTask.setFrom(from);
                    propertyCopyTask.setName(to);
                    propertyCopyTask.execute();
                }
                sdkProperties = project.getProperties();
                for (String propertyKey : APP_SERVER_PROPERTIES_KEYS) {
                    if (sdkProperties.keySet().contains(propertyKey)) continue;
                    throw new CoreException(SDKCorePlugin.createErrorStatus("Missing ${" + propertyKey + "} setting in build.properties file."));
                }
                buildPropertiesCache.put(this.getLocation().toPortableString(), sdkProperties);
            }
        }
        catch (Exception e) {
            throw new CoreException(SDKCorePlugin.createErrorStatus(e.getMessage()));
        }
        return sdkProperties;
    }

    private String getDefaultWorkingDir(IPath buildFile) {
        return buildFile.removeLastSegments(1).toOSString();
    }

    public IPath[] getDependencyJarPaths() {
        ArrayList<Path> retval = new ArrayList<Path>();
        try {
            IPath sdkLibPath = this.getLocation().append("dependencies");
            int compareVersions = CoreUtil.compareVersions((Version)new Version(this.getVersion()), (Version)ILiferayConstants.V700);
            if (sdkLibPath.toFile().exists() && compareVersions >= 0) {
                List libFiles = FileListing.getFileListing((File)new File(sdkLibPath.toOSString()));
                for (File lib : libFiles) {
                    if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                    retval.add(new Path(lib.getPath()));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return retval.toArray(new IPath[0]);
    }

    public IPath getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getPluginFolder(String type) {
        if ("ext".equals(type)) {
            return "ext";
        }
        if ("portlet".equals(type)) {
            return "portlets";
        }
        if ("hook".equals(type)) {
            return "hooks";
        }
        if ("layouttpl".equals(type)) {
            return "layouttpl";
        }
        if ("theme".equals(type)) {
            return "themes";
        }
        if ("web".equals(type)) {
            return "webs";
        }
        return "";
    }

    private String getPluginSuffix(String type) {
        if ("ext".equals(type)) {
            return "-ext";
        }
        if ("portlet".equals(type)) {
            return "-portlet";
        }
        if ("hook".equals(type)) {
            return "-hook";
        }
        if ("layouttpl".equals(type)) {
            return "-layouttpl";
        }
        if ("theme".equals(type)) {
            return "-theme";
        }
        if ("web".equals(type)) {
            return "-web";
        }
        return "";
    }

    public IPath getPortletTemplatePath() {
        return this.getLocation().append(ISDKConstants.PORTLET_PLUGIN_ZIP_PATH);
    }

    protected IEclipsePreferences getPrefStore() {
        return InstanceScope.INSTANCE.getNode("com.liferay.ide.eclipse.sdk");
    }

    private Properties getProperties(File file) {
        Properties properties = new Properties();
        try {
            FileInputStream propertiesInput = new FileInputStream(file);
            properties.load(propertiesInput);
            ((InputStream)propertiesInput).close();
        }
        catch (Exception e) {
            SDKCorePlugin.logError(e);
        }
        return properties;
    }

    public String getVersion() {
        IPath sdkLocation;
        if (this.version == null && !(sdkLocation = this.getLocation().makeAbsolute()).isEmpty()) {
            try {
                Properties buildProperties;
                this.version = SDKUtil.readSDKVersion(sdkLocation.toOSString());
                if (this.version.equals(ILiferayConstants.V611.toString()) && this.hasAppServerSpecificProps(buildProperties = this.getProperties(sdkLocation.append("build.properties").toFile()))) {
                    this.version = ILiferayConstants.V612.toString();
                }
                if (this.version.equals(ILiferayConstants.V6120.toString()) && this.hasAppServerSpecificProps(buildProperties = this.getProperties(sdkLocation.append("build.properties").toFile()))) {
                    this.version = ILiferayConstants.V6130.toString();
                }
            }
            catch (Exception e) {
                SDKCorePlugin.logError("Could not detect the sdk version.", e);
            }
        }
        return this.version;
    }

    private boolean hasAppServerSpecificProps(Properties props) {
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            if (!name.matches("app.server.tomcat.*")) continue;
            return true;
        }
        return false;
    }

    public boolean hasProjectFile() {
        return this.location != null && this.location.append(".project").toFile().exists();
    }

    public boolean isContributed() {
        return this.contributed;
    }

    public boolean isDefault() {
        return this.defaultSDK;
    }

    public boolean isValid() {
        IPath sdkLocation = this.getLocation();
        if (sdkLocation == null) {
            return false;
        }
        if (!SDKUtil.isSDKSupported(sdkLocation.toOSString())) {
            return false;
        }
        return SDKUtil.isValidSDKLocation(sdkLocation.toOSString());
    }

    public void loadFromMemento(XMLMemento sdkElement) {
        this.setName(sdkElement.getString("name"));
        this.setLocation(Path.fromPortableString((String)sdkElement.getString("location")));
    }

    private void loadPropertiesFile(Project project, String fileName) {
        File propertiesFile;
        if (project != null && fileName != null && (propertiesFile = new File(this.getLocation().append(fileName).toPortableString())).exists()) {
            Property loadPropetiesTask = new Property();
            loadPropetiesTask.setProject(project);
            loadPropetiesTask.setFile(propertiesFile);
            loadPropetiesTask.execute();
        }
    }

    public IStatus runCommand(IProject project, IFile buildXmlFile, String command, Map<String, String> overrideProperties, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            IPath buildFile = buildXmlFile.getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.setVMArgs(this.getAntHomeVMArg());
            antHelper.runTarget(buildFile, command, properties, true, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    protected IStatus runTarget(IProject project, Map<String, String> properties, String target, boolean separateJRE, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, target, properties, separateJRE, workingDir);
        }
        catch (CoreException e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public void saveToMemento(XMLMemento child) {
        child.putString("name", this.getName());
        child.putString("location", this.getLocation().toPortableString());
        child.putString("version", this.getVersion());
    }

    public void setContributed(boolean contributed) {
        this.contributed = contributed;
    }

    public void setDefault(boolean defaultSDK) {
        this.defaultSDK = defaultSDK;
    }

    public void setLocation(IPath location) {
        this.location = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return String.valueOf(this.getName()) + (this.isDefault() ? " [default]" : "");
    }

    public String toXmlString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<sdk ");
        builder.append(this.createXMLNameValuePair("name", this.getName()));
        builder.append(this.createXMLNameValuePair("location", this.getLocation().toPortableString()));
        builder.append(this.createXMLNameValuePair("version", this.getVersion()));
        builder.append("/>");
        return builder.toString();
    }

    public IStatus validate() {
        return this.validate(false);
    }

    public IStatus validate(boolean reload) {
        MultiStatus status = new MultiStatus("com.liferay.ide.sdk.core", 0, "", null);
        boolean validLocation = SDKUtil.isValidSDKLocation(this.getLocation().toOSString());
        boolean buildXmlExists = this.getLocation().append("build.xml").toFile().exists();
        if (!validLocation) {
            status.add(SDKCorePlugin.createErrorStatus(Msgs.SDKLocationInvalid));
            return status;
        }
        if (!buildXmlExists) {
            status.add(SDKCorePlugin.createErrorStatus(Msgs.buildXmlFileNotExist));
            return status;
        }
        Map<String, Object> sdkProperties = null;
        try {
            sdkProperties = this.getBuildProperties(reload);
            if (sdkProperties == null) {
                status.add(SDKCorePlugin.createErrorStatus("Could not find any sdk settings."));
                return status;
            }
        }
        catch (Exception e) {
            status.add(SDKCorePlugin.createErrorStatus(e.getMessage()));
            return status;
        }
        for (String propertyKey : APP_SERVER_PROPERTIES_KEYS) {
            if (!status.isOK()) break;
            String propertyValue = (String)sdkProperties.get(propertyKey);
            if (propertyValue == null) {
                status.add(SDKCorePlugin.createErrorStatus(String.valueOf(propertyKey) + " is null."));
                continue;
            }
            switch (propertyKey) {
                case "app.server.type": {
                    if (SUPPORTED_SERVER_TYPES.contains(propertyValue)) break;
                    status.add(SDKCorePlugin.createErrorStatus("The " + propertyKey + "(" + propertyValue + ") server is not supported by Liferay IDE."));
                    break;
                }
                case "app.server.dir": 
                case "app.server.parent.dir": 
                case "app.server.portal.dir": 
                case "app.server.lib.global.dir": 
                case "app.server.deploy.dir": {
                    Path propertyPath = new Path(propertyValue);
                    if (propertyPath.toFile().exists()) break;
                    IStatus logStatus = SDKCorePlugin.createErrorStatus(String.valueOf(propertyKey) + " is invalid. Please reconfigure Plugins SDK setting: " + propertyKey + "=" + propertyValue);
                    SDKCorePlugin.getDefault().getLog().log(logStatus);
                    status.add(logStatus);
                }
            }
        }
        return status;
    }

    public IStatus war(IProject project, Map<String, String> overrideProperties, boolean separateJRE, IProgressMonitor monitor) {
        return this.war(project, overrideProperties, separateJRE, null, monitor);
    }

    public IStatus war(IProject project, Map<String, String> overrideProperties, boolean separateJRE, String[] vmargs, IProgressMonitor monitor) {
        try {
            SDKHelper antHelper = new SDKHelper(this, monitor);
            antHelper.setVMArgs(vmargs);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "war", properties, separateJRE, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    private static class Msgs
    extends NLS {
        public static String buildXmlFileNotExist;
        public static String SDKLocationInvalid;

        static {
            Msgs.initializeMessages((String)SDK.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

