/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.sdk.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.sdk.core.ISDKConstants;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKCorePlugin;
import com.liferay.ide.sdk.core.SDKManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class SDKUtil {
    public static int countPossibleWorkspaceSDKProjects() {
        IProject[] projects;
        int sdkCount = 0;
        IProject[] iProjectArray = projects = CoreUtil.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (SDKUtil.isValidSDKLocation(project.getLocation().toOSString())) {
                ++sdkCount;
            }
            ++n2;
        }
        return sdkCount;
    }

    public static SDK createSDKFromLocation(IPath path) {
        try {
            if (SDKUtil.isValidSDKLocation(path.toOSString())) {
                SDK sdk = new SDK(path);
                sdk.setName(path.lastSegment());
                return sdk;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static SDK getSDK(IProject project) {
        SDK retval = null;
        IPath projectLocation = project.getRawLocation();
        if (projectLocation == null) {
            projectLocation = project.getLocation();
        }
        if (projectLocation != null) {
            IPath sdkLocation = projectLocation.removeLastSegments(2);
            retval = SDKManager.getInstance().getSDK(sdkLocation);
            if (retval == null && (retval = SDKUtil.createSDKFromLocation(sdkLocation)) != null) {
                SDK newSDK = retval;
                SDKManager.getInstance().addSDK(newSDK);
            }
        }
        if (retval == null) {
            IScopeContext[] context = new IScopeContext[]{new ProjectScope(project)};
            String sdkName = Platform.getPreferencesService().getString("com.liferay.ide.sdk.core", "sdk-name", null, context);
            retval = SDKManager.getInstance().getSDK(sdkName);
        }
        return retval;
    }

    public static SDK getSDKFromProjectDir(File projectDir) {
        File sdkDir = projectDir.getParentFile().getParentFile();
        if (sdkDir.exists() && SDKUtil.isValidSDKLocation(sdkDir.getPath())) {
            Path sdkLocation = new Path(sdkDir.getPath());
            SDK existingSDK = SDKManager.getInstance().getSDK((IPath)sdkLocation);
            if (existingSDK != null) {
                return existingSDK;
            }
            return SDKUtil.createSDKFromLocation((IPath)sdkLocation);
        }
        return null;
    }

    public static IProject getWorkspaceSDKProject() throws CoreException {
        IProject[] projects;
        IProject retval = null;
        IProject[] iProjectArray = projects = CoreUtil.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (SDKUtil.isValidSDKLocation(project.getLocation().toOSString())) {
                if (retval != null) {
                    throw new CoreException(SDKCorePlugin.createErrorStatus(new IllegalStateException("Workspace can't have more than one SDK project open")));
                }
                retval = project;
            }
            ++n2;
        }
        return retval;
    }

    public static boolean hasGradleTools(IPath path) {
        return path.append("tools").append("gradle").toFile().exists();
    }

    public static boolean isIvyProject(IProject project) {
        try {
            return SDKUtil.isSDKProject(project) && project.hasNature("org.apache.ivyde.eclipse.ivynature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isSDKProject(IProject project) {
        if (project == null || !project.exists() || !project.isAccessible()) {
            return false;
        }
        return SDKUtil.getSDK(project) != null;
    }

    public static boolean isSDKSupported(String location) {
        boolean retval = false;
        try {
            String version = SDKUtil.readSDKVersion(location);
            retval = CoreUtil.compareVersions((Version)new Version(version), (Version)ISDKConstants.LEAST_SUPPORTED_SDK_VERSION) >= 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public static boolean isValidSDKLocation(String loc) {
        boolean retval = false;
        try {
            File sdkDir = new File(loc);
            File buildProperties = new File(sdkDir, "build.properties");
            File portletsBuildXml = new File(sdkDir, ISDKConstants.PORTLET_PLUGIN_ANT_BUILD);
            File hooksBuildXml = new File(sdkDir, ISDKConstants.HOOK_PLUGIN_ANT_BUILD);
            retval = buildProperties.exists() && portletsBuildXml.exists() && hooksBuildXml.exists();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public static boolean isValidSDKVersion(String sdkVersion, Version lowestValidVersion) {
        Version sdkVersionValue = null;
        try {
            sdkVersionValue = new Version(sdkVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sdkVersionValue != null && CoreUtil.compareVersions((Version)sdkVersionValue, (Version)lowestValidVersion) >= 0;
    }

    public static void openAsProject(SDK sdk) throws CoreException {
        SDKUtil.openAsProject(sdk, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void openAsProject(SDK sdk, IProgressMonitor monitor) throws CoreException {
        IProject sdkProject = CoreUtil.getProject((String)sdk.getName());
        if (sdkProject == null || !sdkProject.exists()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription description = workspace.newProjectDescription(sdk.getLocation().lastSegment());
            description.setLocationURI(sdk.getLocation().toFile().toURI());
            sdkProject.create(description, monitor);
            IPath settingFolderPath = sdkProject.getLocation().append(".settings");
            File settingFolder = settingFolderPath.toFile();
            if (!settingFolder.exists()) {
                settingFolder.mkdir();
            }
            if (!settingFolderPath.append("org.eclipse.wst.validation.prefs").toFile().exists()) {
                try {
                    URL url = FileLocator.toFileURL((URL)SDKCorePlugin.getDefault().getBundle().getEntry("files/org.eclipse.wst.validation.prefs"));
                    File file = new File(url.getFile());
                    FileUtil.copyFileToDir((File)file, (File)settingFolder);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            sdkProject.open(monitor);
        }
    }

    static String readSDKVersion(String path) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream in = new FileInputStream(new Path(path).append("build.properties").toFile());){
                properties.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties.getProperty("lp.version");
    }

    public static void saveSDKNameSetting(IProject project, String sdkName) {
        try {
            IEclipsePreferences prefs = new ProjectScope(project).getNode("com.liferay.ide.sdk.core");
            prefs.put("sdk-name", sdkName);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            SDKCorePlugin.logError("Unable to persist sdk name to project " + project, e);
        }
    }

    public static SDK getWorkspaceSDK() throws CoreException {
        SDK sdk = null;
        IProject workspaceSDKProject = SDKUtil.getWorkspaceSDKProject();
        if (workspaceSDKProject != null) {
            sdk = SDKUtil.createSDKFromLocation(workspaceSDKProject.getLocation());
        }
        return sdk;
    }

    public static IProject[] getWorkspaceSDKs() {
        IProject[] projects;
        ArrayList<IProject> sdkProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = CoreUtil.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (SDKUtil.isValidSDKLocation(project.getLocation().toOSString())) {
                sdkProjects.add(project);
            }
            ++n2;
        }
        return sdkProjects.toArray(new IProject[sdkProjects.size()]);
    }
}

