/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.core.portal.PortalJBossBundleFactory;
import com.liferay.ide.server.core.portal.PortalWildFlyBundle;
import com.liferay.ide.server.util.JavaUtil;
import com.liferay.ide.server.util.LayeredModulePathFactory;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PortalWildFlyBundleFactory
extends PortalJBossBundleFactory {
    private static final String WF_100_RELEASE_MANIFEST_KEY = "JBoss-Product-Release-Version";

    @Override
    public PortalBundle create(Map<String, String> appServerProperties) {
        return new PortalWildFlyBundle(appServerProperties);
    }

    @Override
    public PortalBundle create(IPath location) {
        return new PortalWildFlyBundle(location);
    }

    @Override
    protected boolean detectBundleDir(IPath path) {
        String vers;
        if (!path.toFile().exists()) {
            return false;
        }
        return path.append("modules").toFile().exists() && path.append("standalone").toFile().exists() && path.append("bin").toFile().exists() && (vers = this.getManifestPropFromJBossModulesFolder(new File[]{new File(path.toPortableString(), "modules")}, "org.jboss.as.product", "wildfly-full/dir/META-INF", WF_100_RELEASE_MANIFEST_KEY)) != null && vers.startsWith("10.");
    }

    protected String getManifestPropFromJBossModulesFolder(File[] moduleRoots, String moduleId, String slot, String property) {
        File[] layeredRoots = LayeredModulePathFactory.resolveLayeredModulePath(moduleRoots);
        int i = 0;
        while (i < layeredRoots.length) {
            IPath[] manifests = PortalWildFlyBundleFactory.getFilesForModule(layeredRoots[i], moduleId, slot, PortalWildFlyBundleFactory.manifestFilter());
            if (manifests.length > 0) {
                String value = JavaUtil.getManifestProperty(manifests[0].toFile(), property);
                if (value != null) {
                    return value;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private static FileFilter manifestFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().toLowerCase().equals("manifest.mf");
            }
        };
    }

    private static IPath[] getFilesForModule(File modulesFolder, String moduleName, String slot, FileFilter filter) {
        String slashed = moduleName.replaceAll("\\.", "/");
        slot = slot == null ? "main" : slot;
        return PortalWildFlyBundleFactory.getFiles(modulesFolder, new Path(slashed).append(slot), filter);
    }

    private static IPath[] getFiles(File modulesFolder, IPath moduleRelativePath, FileFilter filter) {
        File[] layeredPaths = LayeredModulePathFactory.resolveLayeredModulePath(modulesFolder);
        int i = 0;
        while (i < layeredPaths.length) {
            Path lay = new Path(layeredPaths[i].getAbsolutePath());
            File layeredPath = new File(lay.append(moduleRelativePath).toOSString());
            if (layeredPath.exists()) {
                return PortalWildFlyBundleFactory.getFilesFrom(layeredPath, filter);
            }
            ++i;
        }
        return new IPath[0];
    }

    private static IPath[] getFilesFrom(File layeredPath, FileFilter filter) {
        ArrayList<Path> list = new ArrayList<Path>();
        File[] children = layeredPath.listFiles();
        int i = 0;
        while (i < children.length) {
            if (filter.accept(children[i])) {
                list.add(new Path(children[i].getAbsolutePath()));
            }
            ++i;
        }
        return list.toArray(new IPath[list.size()]);
    }
}

