/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.draw2d;

import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Rectangle;

public class PortletLayoutPanel
extends Panel {
    protected boolean top = false;
    protected boolean bottom = false;

    public PortletLayoutPanel() {
    }

    public PortletLayoutPanel(boolean top, boolean bottom) {
        this.top = top;
        this.bottom = bottom;
    }

    protected void setup() {
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setAntialias(1);
            if (!this.top && !this.bottom) {
                graphics.fillRectangle(this.getBounds());
            } else {
                Rectangle normalFillRectangle = new Rectangle(this.getBounds());
                Rectangle roundedFillRectangle = new Rectangle(this.getBounds());
                int remainder = normalFillRectangle.height % 2;
                int halfHeight = normalFillRectangle.height / 2;
                if (this.top && !this.bottom) {
                    roundedFillRectangle.height = roundedFillRectangle.height / 2 + remainder;
                    normalFillRectangle.y = normalFillRectangle.y + halfHeight - 10;
                    normalFillRectangle.height = halfHeight + remainder + 10;
                    graphics.fillRectangle(normalFillRectangle);
                } else if (!this.top && this.bottom) {
                    roundedFillRectangle.height = roundedFillRectangle.height / 2 + remainder;
                    roundedFillRectangle.y += halfHeight;
                    normalFillRectangle.height = halfHeight + remainder + 10;
                    graphics.fillRectangle(normalFillRectangle);
                }
                graphics.fillRoundRectangle(roundedFillRectangle, 10, 10);
            }
        }
        if (this.getBorder() instanceof AbstractBackground) {
            ((AbstractBackground)this.getBorder()).paintBackground((IFigure)this, graphics, NO_INSETS);
        }
    }

    public boolean isTop() {
        return this.top;
    }

    public void setTop(boolean top) {
        this.top = top;
    }

    public boolean isBottom() {
        return this.bottom;
    }

    public void setBottom(boolean bottom) {
        this.bottom = bottom;
    }
}

