/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.ValuePropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.TextOverlayPainter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

public final class ScalePropertyEditorPresentation
extends ValuePropertyEditorPresentation {
    private int minimum;
    private int maximum;
    private int offset;
    private Scale scale;
    private Text textField;

    public ScalePropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    protected void createContents(Composite parent) {
        NumericRange rangeAnnotation = (NumericRange)this.property().definition().getAnnotation(NumericRange.class);
        try {
            this.minimum = Integer.parseInt(rangeAnnotation.min());
            this.maximum = Integer.parseInt(rangeAnnotation.max());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        if (this.minimum < 0) {
            this.offset = this.minimum * -1;
            this.minimum += this.offset;
            this.maximum += this.offset;
        } else {
            this.offset = 0;
        }
        Composite composite = this.createMainComposite(parent);
        composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
        Composite textFieldComposite = new Composite(composite, 0);
        textFieldComposite.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gd(), 60));
        textFieldComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
        PropertyEditorAssistDecorator decorator = this.createDecorator(textFieldComposite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
        this.textField = new Text(textFieldComposite, 2048);
        this.textField.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ScalePropertyEditorPresentation.this.setPropertyValue(ScalePropertyEditorPresentation.this.textField.getText());
            }
        });
        TextOverlayPainter.install(this.textField, this.property());
        this.scale = new Scale(composite, 256);
        this.scale.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.scale.setMinimum(this.minimum);
        this.scale.setMaximum(this.maximum);
        this.scale.setIncrement(1);
        this.scale.setPageIncrement(1);
        this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int value = ScalePropertyEditorPresentation.this.scale.getSelection() - ScalePropertyEditorPresentation.this.offset;
                ScalePropertyEditorPresentation.this.setPropertyValue(String.valueOf(value));
            }
        });
        decorator.addEditorControl((Control)composite);
        this.addControl((Control)this.textField);
        this.addControl((Control)this.scale);
    }

    @Override
    protected void handlePropertyChangedEvent() {
        Integer newValueInteger;
        int newValueForScale;
        super.handlePropertyChangedEvent();
        Value<?> value = this.property();
        String existingValueInTextField = this.textField.getText();
        String newValueForTextField = value.text(false);
        if (!existingValueInTextField.equals(newValueForTextField)) {
            this.textField.setText(newValueForTextField == null ? "" : newValueForTextField);
        }
        int n = newValueForScale = (newValueInteger = (Integer)value.content(true)) == null ? this.scale.getMinimum() : newValueInteger + this.offset;
        if (newValueForScale < this.minimum) {
            newValueForScale = this.minimum;
        } else if (newValueForScale > this.maximum) {
            newValueForScale = this.maximum;
        }
        if (this.scale.getSelection() != newValueForScale) {
            this.scale.setSelection(newValueForScale);
        }
    }

    @Override
    protected void handleFocusReceivedEvent() {
        this.scale.setFocus();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.scale = null;
        this.textField = null;
    }

    public static final class Factory
    extends PropertyEditorPresentationFactory {
        @Override
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            NumericRange rangeAnnotation;
            PropertyDef property;
            String style = (String)part.definition().getStyle().content();
            if (style != null && style.startsWith("Sapphire.PropertyEditor.Scale") && (property = part.property().definition()).isOfType(Integer.class) && (rangeAnnotation = (NumericRange)property.getAnnotation(NumericRange.class)) != null) {
                String minStr = rangeAnnotation.min();
                String maxStr = rangeAnnotation.max();
                if (minStr.length() > 0 && maxStr.length() > 0) {
                    return new ScalePropertyEditorPresentation(part, parent, composite);
                }
            }
            return null;
        }
    }
}

