/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.ui.DragAndDropService;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;

public class DndObjectCommand
extends Command {
    private DiagramModel diagramModel;
    private DragAndDropService dndService;
    private List<Object> droppedObjs;
    private org.eclipse.draw2d.geometry.Point location;

    public DndObjectCommand(DiagramModel diagramModel, ISelection sel, org.eclipse.draw2d.geometry.Point location) {
        this.diagramModel = diagramModel;
        this.dndService = (DragAndDropService)this.diagramModel.getSapphirePart().service(DragAndDropService.class);
        this.location = location;
        this.droppedObjs = new ArrayList<Object>();
        IStructuredSelection s = (IStructuredSelection)sel;
        if (s == null) {
            s = StructuredSelection.EMPTY;
        }
        for (Object next : s) {
            this.droppedObjs.add(next);
        }
    }

    public boolean canExecute() {
        if (this.dndService == null) {
            return false;
        }
        boolean canDrop = true;
        for (Object droppedObj : this.droppedObjs) {
            if (this.dndService.droppable(new DragAndDropService.DropContext(droppedObj, null))) continue;
            canDrop = false;
            break;
        }
        return canDrop;
    }

    public void execute() {
        int currX = this.location.x;
        int currY = this.location.y;
        for (Object droppedObj : this.droppedObjs) {
            DragAndDropService.DropContext context = new DragAndDropService.DropContext(droppedObj, new Point(currX, currY));
            this.dndService.drop(context);
            currX += 20;
            currY += 20;
        }
    }
}

