/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.gradle.core.GradleProjectCreatedListener;
import com.liferay.ide.gradle.core.GradleTooling;
import java.io.File;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.event.EventListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class GradleCore
extends Plugin {
    private static GradleCore plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.gradle.core";
    public static final String JobFamilyId = "CheckingGradleConfiguration";
    public static final File customModelCache;
    private final GradleProjectCreatedListener gradleProjectCreatedListener = new GradleProjectCreatedListener();

    static {
        customModelCache = LiferayCore.GLOBAL_SETTINGS_PATH.toFile();
    }

    public static IStatus createErrorStatus(Exception ex) {
        return new Status(4, PLUGIN_ID, ex.getMessage(), (Throwable)ex);
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, PLUGIN_ID, msg);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, msg, (Throwable)e);
    }

    public static IStatus createWarningStatus(String msg) {
        return new Status(2, PLUGIN_ID, msg);
    }

    public static GradleCore getDefault() {
        return plugin;
    }

    public static <T> T getToolingModel(Class<T> modelClass, File projectDir) {
        T retval = null;
        try {
            retval = GradleTooling.getModel(modelClass, customModelCache, projectDir);
        }
        catch (Exception e) {
            GradleCore.logError("Error getting tooling model", e);
        }
        return retval;
    }

    public static <T> T getToolingModel(Class<T> modelClass, IProject gradleProject) {
        return GradleCore.getToolingModel(modelClass, gradleProject.getLocation().toFile());
    }

    public static void logError(Exception ex) {
        GradleCore.getDefault().getLog().log(GradleCore.createErrorStatus(ex));
    }

    public static void logError(String msg) {
        GradleCore.getDefault().getLog().log(GradleCore.createErrorStatus(msg));
    }

    public static void logError(String msg, Exception e) {
        GradleCore.getDefault().getLog().log(GradleCore.createErrorStatus(msg, e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        CorePlugin.listenerRegistry().addEventListener((EventListener)this.gradleProjectCreatedListener);
    }

    public void stop(BundleContext context) throws Exception {
        CorePlugin.listenerRegistry().removeEventListener((EventListener)this.gradleProjectCreatedListener);
        plugin = null;
        super.stop(context);
    }
}

