/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.blade.gradle.model.CustomModel;
import com.liferay.ide.core.LiferayNature;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.gradle.core.GradleCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.event.Event;
import org.eclipse.buildship.core.event.EventListener;
import org.eclipse.buildship.core.workspace.ProjectCreatedEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class GradleProjectCreatedListener
implements EventListener {
    public void onEvent(Event event) {
        if (event instanceof ProjectCreatedEvent) {
            ProjectCreatedEvent createEvent = (ProjectCreatedEvent)event;
            IProject project = createEvent.getProject();
            try {
                this.configureIfLiferayProject(project);
            }
            catch (CoreException e) {
                GradleCore.logError("config project " + project.getName() + "error", (Exception)((Object)e));
            }
        }
    }

    private void configureIfLiferayProject(final IProject project) throws CoreException {
        if (GradleProjectNature.isPresentOn((IProject)project) && !LiferayNature.hasNature((IProject)project)) {
            final boolean[] needAddNature = new boolean[]{false};
            IFile bndFile = project.getFile("bnd.bnd");
            if (bndFile != null && bndFile.exists()) {
                needAddNature[0] = true;
            } else if (ProjectUtil.isWorkspaceWars((IProject)project)) {
                needAddNature[0] = true;
            } else {
                IFile gulpFile = project.getFile("gulpfile.js");
                if (gulpFile != null && gulpFile.exists()) {
                    try {
                        String gulpFileContent = new String(Files.readAllBytes(gulpFile.getLocation().toFile().toPath()), StandardCharsets.UTF_8);
                        if (gulpFileContent.contains("require('liferay-theme-tasks')")) {
                            needAddNature[0] = true;
                        }
                    }
                    catch (IOException e) {
                        GradleCore.logError("read gulpfile.js file fail", e);
                    }
                }
            }
            WorkspaceJob job = new WorkspaceJob("Checking gradle configuration"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        if (needAddNature[0]) {
                            LiferayNature.addLiferayNature((IProject)project, (IProgressMonitor)monitor);
                            return Status.OK_STATUS;
                        }
                        CustomModel customModel = GradleCore.getToolingModel(CustomModel.class, project);
                        if (customModel == null) {
                            throw new CoreException(GradleCore.createErrorStatus("Unable to get read gradle configuration"));
                        }
                        if (customModel.isLiferayModule() || customModel.hasPlugin("org.gradle.api.plugins.WarPlugin") || customModel.hasPlugin("com.liferay.gradle.plugins.theme.builder.ThemeBuilderPlugin")) {
                            LiferayNature.addLiferayNature((IProject)project, (IProgressMonitor)monitor);
                        }
                    }
                    catch (Exception e) {
                        GradleCore.logError("Unable to get tooling model", e);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family != null && family.toString().equals("CheckingGradleConfiguration");
                }
            };
            job.setRule((ISchedulingRule)CoreUtil.getWorkspaceRoot());
            job.schedule();
        }
    }
}

