/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.core.AbstractLiferayProjectProvider;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayNature;
import com.liferay.ide.gradle.core.FacetedGradleBundleProject;
import com.liferay.ide.gradle.core.GradleCore;
import com.liferay.ide.gradle.core.GradleUtil;
import com.liferay.ide.gradle.core.LiferayGradleProject;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.model.ProjectName;
import com.liferay.ide.project.core.modules.BladeCLI;
import com.liferay.ide.project.core.modules.NewLiferayModuleProjectOp;
import com.liferay.ide.project.core.modules.PropertyKey;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

public class GradleProjectProvider
extends AbstractLiferayProjectProvider
implements NewLiferayProjectProvider<NewLiferayModuleProjectOp> {
    public GradleProjectProvider() {
        super(new Class[]{IProject.class});
    }

    public synchronized ILiferayProject provide(Object adaptable) {
        ILiferayProject retval = null;
        if (adaptable instanceof IProject) {
            IProject project = (IProject)adaptable;
            try {
                if (LiferayNature.hasNature((IProject)project) && GradleProjectNature.isPresentOn((IProject)project)) {
                    if (ProjectUtil.isFacetedGradleBundleProject((IProject)project)) {
                        return new FacetedGradleBundleProject(project);
                    }
                    return new LiferayGradleProject(project);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public IStatus createNewProject(NewLiferayModuleProjectOp op, IProgressMonitor monitor) throws CoreException {
        IStatus retval = Status.OK_STATUS;
        String projectName = (String)op.getProjectName().content();
        IPath location = PathBridge.create((Path)((Path)op.getLocation().content()));
        String className = (String)op.getComponentName().content();
        String serviceName = (String)op.getServiceName().content();
        String packageName = (String)op.getPackageName().content();
        ElementList propertyKeys = op.getPropertyKeys();
        ArrayList<String> properties = new ArrayList<String>();
        for (PropertyKey propertyKey : propertyKeys) {
            properties.add(String.valueOf((String)propertyKey.getName().content(true)) + "=" + (String)propertyKey.getValue().content(true));
        }
        File targetDir = location.toFile();
        targetDir.mkdirs();
        String projectTemplateName = (String)op.getProjectTemplateName().content();
        StringBuilder sb = new StringBuilder();
        sb.append("create ");
        sb.append("-d \"" + targetDir.getAbsolutePath() + "\" ");
        sb.append("-t " + projectTemplateName + " ");
        if (className != null) {
            sb.append("-c " + className + " ");
        }
        if (serviceName != null) {
            sb.append("-s " + serviceName + " ");
        }
        if (packageName != null) {
            sb.append("-p " + packageName + " ");
        }
        sb.append("\"" + projectName + "\" ");
        try {
            IPath workspaceLocation;
            BladeCLI.execute((String)sb.toString());
            ElementList projectNames = op.getProjectNames();
            ((ProjectName)projectNames.insert()).setName(projectName);
            if (projectTemplateName.equals("service-builder")) {
                ((ProjectName)projectNames.insert()).setName(String.valueOf(projectName) + "-api");
                ((ProjectName)projectNames.insert()).setName(String.valueOf(projectName) + "-service");
            }
            IPath projectLocation = location;
            String lastSegment = location.lastSegment();
            if (location != null && location.segmentCount() > 0 && !lastSegment.equals(projectName)) {
                projectLocation = location.append(projectName);
            }
            boolean hasGradleWorkspace = LiferayWorkspaceUtil.hasGradleWorkspace();
            boolean useDefaultLocation = (Boolean)op.getUseDefaultLocation().content(true);
            boolean inWorkspacePath = false;
            IProject liferayWorkspaceProject = LiferayWorkspaceUtil.getWorkspaceProject();
            if (hasGradleWorkspace && liferayWorkspaceProject != null && !useDefaultLocation && (workspaceLocation = liferayWorkspaceProject.getLocation()) != null) {
                inWorkspacePath = workspaceLocation.isPrefixOf(projectLocation);
            }
            if (hasGradleWorkspace && useDefaultLocation || inWorkspacePath) {
                GradleUtil.refreshGradleProject(liferayWorkspaceProject);
            } else {
                GradleUtil.importGradleProject(projectLocation.toFile(), monitor);
            }
        }
        catch (Exception e) {
            retval = GradleCore.createErrorStatus("can't create module project.", e);
        }
        return retval;
    }

    public IStatus validateProjectLocation(String projectName, IPath path) {
        IStatus retval = Status.OK_STATUS;
        if (path != null && LiferayWorkspaceUtil.isValidGradleWorkspaceLocation((String)path.toOSString())) {
            retval = GradleCore.createErrorStatus(" Can't set WorkspaceProject root folder as project directory. ");
        }
        return retval;
    }
}

