/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core.parser;

import com.liferay.ide.gradle.core.parser.GradleDependency;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;

public class FindDependenciesVisitor
extends CodeVisitorSupport {
    private int dependenceLineNum = -1;
    private int columnNum = -1;
    private List<GradleDependency> dependencies = new ArrayList<GradleDependency>();

    public void visitMethodCallExpression(MethodCallExpression call) {
        if (!call.getMethodAsString().equals("buildscript")) {
            if (call.getMethodAsString().equals("dependencies") && this.dependenceLineNum == -1) {
                this.dependenceLineNum = call.getLastLineNumber();
            }
            super.visitMethodCallExpression(call);
        }
    }

    public void visitArgumentlistExpression(ArgumentListExpression ale) {
        String depStr;
        String[] deps;
        List expressions = ale.getExpressions();
        if (expressions.size() == 1 && expressions.get(0) instanceof ConstantExpression && (deps = (depStr = ((Expression)expressions.get(0)).getText()).split(":")).length == 3) {
            this.dependencies.add(new GradleDependency(deps[0], deps[1], deps[2]));
        }
        super.visitArgumentlistExpression(ale);
    }

    public void visitClosureExpression(ClosureExpression expression) {
        if (this.dependenceLineNum != -1 && expression.getLineNumber() == expression.getLastLineNumber()) {
            this.columnNum = expression.getLastColumnNumber();
        }
        super.visitClosureExpression(expression);
    }

    public void visitMapExpression(MapExpression expression) {
        List mapEntryExpressions = expression.getMapEntryExpressions();
        HashMap<String, String> dependenceMap = new HashMap<String, String>();
        for (MapEntryExpression mapEntryExpression : mapEntryExpressions) {
            String key = mapEntryExpression.getKeyExpression().getText();
            String value = mapEntryExpression.getValueExpression().getText();
            dependenceMap.put(key, value);
        }
        this.dependencies.add(new GradleDependency(dependenceMap));
        super.visitMapExpression(expression);
    }

    public int getDependenceLineNum() {
        return this.dependenceLineNum;
    }

    public int getColumnNum() {
        return this.columnNum;
    }

    public List<GradleDependency> getDependencies() {
        return this.dependencies;
    }
}

