/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.model.internal;

import com.liferay.ide.hook.core.HookCore;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.services.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StrutsActionPathPossibleValuesCacheService
extends Service {
    private final Map<IPath, TreeSet<String>> possibleValuesMap = new HashMap<IPath, TreeSet<String>>();

    public TreeSet<String> getPossibleValuesForPath(IPath strutsConfigPath) {
        File strutsConfigFile;
        TreeSet<String> retval = this.possibleValuesMap.get(strutsConfigPath);
        if (retval == null && (strutsConfigFile = strutsConfigPath.toFile()).exists()) {
            TreeSet<String> possibleValues = new TreeSet<String>();
            try {
                DocumentBuilderFactory newInstance = DocumentBuilderFactory.newInstance();
                newInstance.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                newInstance.setValidating(false);
                Document doc = newInstance.newDocumentBuilder().parse(strutsConfigFile);
                NodeList actions = doc.getElementsByTagName("action");
                if (actions != null) {
                    int i = 0;
                    while (i < actions.getLength()) {
                        Node action = actions.item(i);
                        Node path = action.getAttributes().getNamedItem("path");
                        if (path != null) {
                            possibleValues.add(path.getNodeValue());
                        }
                        ++i;
                    }
                }
                this.possibleValuesMap.put(strutsConfigPath, possibleValues);
                retval = possibleValues;
            }
            catch (Exception e) {
                HookCore.logError("Unable to parse struts config: " + strutsConfigPath, e);
            }
        }
        if (retval == null) {
            retval = new TreeSet();
        }
        return retval;
    }
}

