/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.core.model.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.service.core.model.Column;
import com.liferay.ide.service.core.model.Entity;
import com.liferay.ide.service.core.model.Relationship;
import com.liferay.ide.service.core.model.ServiceBuilder;
import com.liferay.ide.service.core.model.internal.EntityRelationshipService;
import com.liferay.ide.service.core.model.internal.RelationshipObject;
import com.liferay.ide.service.core.model.internal.RelationshipResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Resource;

public class RelationshipsBindingImpl
extends LayeredListPropertyBinding {
    private List<RelationshipObject> relationships = new ArrayList<RelationshipObject>();

    private Column findPrimaryKey(Entity entity) {
        if (entity != null) {
            for (Column column : entity.getColumns()) {
                if (!((Boolean)column.isPrimary().content()).booleanValue()) continue;
                return column;
            }
        }
        return null;
    }

    public void init(Property property) {
        super.init(property);
        this.serviceBuilder().attach((Listener)new FilteredListener<PropertyEvent>(){

            public void handleTypedEvent(PropertyEvent event) {
                if (event != null) {
                    RelationshipsBindingImpl.this.refreshRelationships();
                }
            }
        }, "Entities/*");
        this.refreshRelationships();
    }

    protected Object insertUnderlyingObject(ElementType type, int position) {
        RelationshipObject newRelationship = new RelationshipObject();
        if (position > this.relationships.size()) {
            this.relationships.add(newRelationship);
        } else {
            this.relationships.add(position, newRelationship);
        }
        return newRelationship;
    }

    protected List<?> readUnderlyingList() {
        return this.relationships;
    }

    private void refreshRelationships() {
        this.relationships.clear();
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        for (Entity entity : this.serviceBuilder().getEntities()) {
            Column primaryKeyColumn = this.findPrimaryKey(entity);
            if (primaryKeyColumn == null || CoreUtil.empty((String)((String)primaryKeyColumn.getName().content()))) continue;
            primaryKeys.put((String)primaryKeyColumn.getName().content(), (String)entity.getName().content());
        }
        for (Entity entity : this.serviceBuilder().getEntities()) {
            for (Column column : entity.getColumns()) {
                String columnName;
                String entityName;
                if (((Boolean)column.isPrimary().content()).booleanValue() || (entityName = (String)primaryKeys.get(columnName = (String)column.getName().content())) == null) continue;
                this.relationships.add(new RelationshipObject((String)entity.getName().content(), entityName));
            }
        }
    }

    public void remove(Resource resource) {
        RelationshipObject relObject = ((RelationshipResource)((Object)resource.adapt(RelationshipResource.class))).getRelationshipObject();
        this.relationships.remove(relObject);
        this.removeRelationship(relObject);
    }

    private void removeRelationship(RelationshipObject relObject) {
        String primaryKeyName;
        String fromName = relObject.getFromName();
        String toName = relObject.getToName();
        Entity fromEntity = EntityRelationshipService.findEntity(fromName, this.serviceBuilder());
        Entity toEntity = EntityRelationshipService.findEntity(toName, this.serviceBuilder());
        Column primaryKeyColumn = this.findPrimaryKey(toEntity);
        if (primaryKeyColumn != null && !CoreUtil.empty((String)(primaryKeyName = (String)primaryKeyColumn.getName().content()))) {
            Column columnToRemove = null;
            for (Column column : fromEntity.getColumns()) {
                if (!primaryKeyName.equals(column.getName().content())) continue;
                columnToRemove = column;
                break;
            }
            if (columnToRemove != null) {
                fromEntity.getColumns().remove(columnToRemove);
            }
        }
    }

    protected Resource resource(Object obj) {
        return new RelationshipResource((RelationshipObject)obj, this.property().element().resource());
    }

    private ServiceBuilder serviceBuilder() {
        return (ServiceBuilder)this.property().nearest(ServiceBuilder.class);
    }

    public ElementType type(Resource resource) {
        return Relationship.TYPE;
    }
}

