/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import aQute.remote.api.Agent;
import aQute.remote.api.Event;
import aQute.remote.api.Supervisor;
import aQute.remote.util.AgentSupervisor;
import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.jmx.PortalBundleDeployer;
import com.liferay.ide.server.core.portal.BundleDTOWithStatus;
import com.liferay.ide.server.core.portal.GogoTelnetClient;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.dto.BundleDTO;

public class BundleSupervisor
extends AgentSupervisor<Supervisor, Agent>
implements Supervisor {
    private String lastOutput;
    private final int jmxPort;
    private PortalBundleDeployer bundleDeployer;

    public BundleSupervisor(int jmxPort) {
        this.jmxPort = jmxPort;
    }

    public void close() throws IOException {
        super.close();
        this.bundleDeployer.close();
    }

    public void connect(String host, int port) throws Exception {
        GogoTelnetClient gogoShell = new GogoTelnetClient(host, 11311);
        this.makeSureBundlesStarted(gogoShell, "biz.aQute.remote.agent");
        this.makeSureBundlesStarted(gogoShell, "org.apache.aries.jmx.api");
        this.makeSureBundlesStarted(gogoShell, "org.apache.aries.jmx.core");
        this.makeSureBundlesStarted(gogoShell, "org.apache.aries.util");
        gogoShell.close();
        super.connect(Agent.class, (Object)this, host, port, 600);
        this.bundleDeployer = new PortalBundleDeployer(host, this.jmxPort);
    }

    public BundleDTO deploy(String bsn, File bundleFile, String bundleUrl) throws Exception {
        BundleDTO retval = null;
        boolean isFragment = false;
        String fragmentHostName = null;
        if (!bundleUrl.contains("webbundle:")) {
            fragmentHostName = ServerUtil.getFragemtHostName(bundleFile);
            isFragment = fragmentHostName != null;
        }
        Agent agent = (Agent)this.getAgent();
        long bundleId = this.getBundleId(bsn);
        if (bundleId > 0L) {
            String startStatus;
            if (!isFragment) {
                agent.stop(new long[]{bundleId});
            }
            if (bundleUrl.contains("webbundle:")) {
                this.bundleDeployer.updateBundleFromURL(bundleId, bundleUrl);
            } else {
                this.bundleDeployer.updateBundleFromURL(bundleId, bundleFile.toURI().toURL().toExternalForm());
            }
            if (!isFragment && (startStatus = agent.start(new long[]{bundleId})) != null) {
                retval = new BundleDTO();
                retval.id = bundleId;
                retval = new BundleDTOWithStatus(retval, startStatus);
            }
            if (retval == null) {
                retval = new BundleDTO();
                retval.id = bundleId;
            }
        } else {
            if (bundleUrl.contains("webbundle:")) {
                retval = this.bundleDeployer.installBundleFromURL(bundleUrl);
            } else {
                String url = bundleFile.toURI().toURL().toExternalForm();
                retval = this.bundleDeployer.installBundleFromURL(url);
            }
            if (!isFragment) {
                String startStatus = agent.start(new long[]{retval.id});
                if (startStatus != null) {
                    retval = new BundleDTOWithStatus(retval, startStatus);
                }
            } else {
                this.refreshHostBundle(fragmentHostName);
            }
        }
        return retval;
    }

    public void event(Event e) throws Exception {
    }

    private BundleDTOWithStatus getBundleDTOwithStatus(String result, String bsn) {
        String[] lines;
        BundleDTOWithStatus bundleDTOWithStatus = null;
        String status = null;
        String[] stringArray = lines = result.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] bundleAttris;
            String bsnTemp;
            String line = stringArray[n2];
            if (line.contains("(") && line.contains(")") && bsn.equals(bsnTemp = (bundleAttris = line.split("\\|"))[3].substring(0, bundleAttris[3].indexOf("(")).trim())) {
                status = bundleAttris[1].trim();
                long id = Long.parseLong(bundleAttris[0].trim());
                bundleDTOWithStatus = new BundleDTOWithStatus(id, status, bsn);
                return bundleDTOWithStatus;
            }
            ++n2;
        }
        return bundleDTOWithStatus;
    }

    public long getBundleId(String bsn) throws Exception {
        long id = -1L;
        try {
            String[] lines;
            String result = ((Agent)this.getAgent()).shell("lb -s " + bsn);
            String[] stringArray = lines = result.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String[] bundleAttris;
                String bsnTemp;
                String line = stringArray[n2];
                if (line.contains("(") && line.contains(")") && bsn.equals(bsnTemp = (bundleAttris = line.split("\\|"))[3].substring(0, bundleAttris[3].indexOf("(")).trim())) {
                    id = Long.parseLong(bundleAttris[0].trim());
                    break;
                }
                ++n2;
            }
            return id;
        }
        catch (Exception e) {
            LiferayServerCore.logError("Get result error when executing shell(lb -s " + bsn + ")", e);
            return id;
        }
    }

    public String getOutInfo() {
        return this.lastOutput;
    }

    private void makeSureBundlesStarted(GogoTelnetClient gogoShell, String bsn) throws Exception {
        String result = gogoShell.send("lb -s " + bsn);
        BundleDTOWithStatus bundleDTO = this.getBundleDTOwithStatus(result, bsn);
        if (bundleDTO == null) {
            throw new Exception("can't find " + bsn + " in running liferay instance");
        }
        if (bundleDTO._status.equals("Active")) {
            return;
        }
        if (bundleDTO._status.equals("Resolved")) {
            gogoShell.send("start " + bundleDTO.id);
            result = gogoShell.send("lb -s " + bsn);
            bundleDTO = this.getBundleDTOwithStatus(result, bsn);
            if (bundleDTO == null) {
                throw new Exception("can't find " + bsn + " in running liferay instance");
            }
            if (bundleDTO._status.equals("Active")) {
                return;
            }
            throw new Exception("can't start " + bsn + " in running liferay instance");
        }
        throw new Exception("unknow status of " + bsn + " in running liferay instance");
    }

    public void refreshHostBundle(String fragmentHostName) throws Exception {
        long fragmentHostId = this.getBundleId(fragmentHostName);
        if (fragmentHostId > 0L) {
            Agent agent = (Agent)this.getAgent();
            agent.redirect(-1);
            agent.stdin("refresh " + fragmentHostId);
            agent.redirect(0);
        }
    }

    public boolean stderr(String out) throws Exception {
        return true;
    }

    public boolean stdout(String out) throws Exception {
        if (!("".equals(out) || out == null || "".equals(out = out.replaceAll("^>.*$", "")) || out.startsWith("true"))) {
            this.lastOutput = out;
        }
        return true;
    }

    public String uninstall(IBundleProject bundleProject, IPath outputJar) throws Exception {
        long bundleId;
        String retVal = null;
        String fragmentHostName = ServerUtil.getFragemtHostName(outputJar.toFile());
        boolean isFragment = fragmentHostName != null;
        String symbolicName = bundleProject.getSymbolicName();
        if (symbolicName != null && (bundleId = this.getBundleId(symbolicName)) > 0L) {
            retVal = ((Agent)this.getAgent()).uninstall(new long[]{bundleId});
            if (isFragment) {
                this.refreshHostBundle(fragmentHostName);
            }
        }
        return retVal;
    }
}

