/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class GogoTelnetClient
implements AutoCloseable {
    private final Socket _socket;
    private final DataInputStream _inputStream;
    private final DataOutputStream _outputStream;

    public GogoTelnetClient() throws IOException {
        this("localhost", 11311);
    }

    public GogoTelnetClient(String host, int port) throws IOException {
        this._socket = new Socket(host, port);
        this._inputStream = new DataInputStream(this._socket.getInputStream());
        this._outputStream = new DataOutputStream(this._socket.getOutputStream());
        this.doHandshake();
    }

    private static void assertCond(boolean condition) {
        if (!condition) {
            throw new AssertionError();
        }
    }

    private void doHandshake() throws IOException {
        this.readOneCommand();
        this.readOneCommand();
        this.readOneCommand();
        this.readOneCommand();
        this.sendCommand(255, 251, 24);
        this.readOneCommand();
        this.sendCommand(255, 250, 24, 0, 86, 84, 50, 50, 48, 255, 240);
        this.readUntilNextGogoPrompt();
    }

    private String readUntilNextGogoPrompt() throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = this._inputStream.read();
        while (c != -1) {
            sb.append((char)c);
            if (sb.toString().endsWith("g! ")) break;
            c = this._inputStream.read();
        }
        String output = sb.substring(0, sb.length() - 3);
        return output.trim();
    }

    public String send(String command) throws IOException {
        byte[] bytes = command.getBytes();
        int[] codes = new int[bytes.length + 2];
        int i = 0;
        while (i < bytes.length) {
            codes[i] = bytes[i];
            ++i;
        }
        codes[bytes.length] = 13;
        codes[bytes.length + 1] = 10;
        this.sendCommand(codes);
        return this.readUntilNextGogoPrompt();
    }

    private void sendCommand(int ... codes) throws IOException {
        int[] nArray = codes;
        int n = codes.length;
        int n2 = 0;
        while (n2 < n) {
            int code = nArray[n2];
            this._outputStream.write(code);
            ++n2;
        }
    }

    private int[] readOneCommand() throws IOException {
        ArrayList<Integer> bytes = new ArrayList<Integer>();
        int iac = this._inputStream.read();
        GogoTelnetClient.assertCond(iac == 255);
        bytes.add(iac);
        int second = this._inputStream.read();
        bytes.add(second);
        if (second == 250) {
            int option = this._inputStream.read();
            bytes.add(option);
            int code = this._inputStream.read();
            GogoTelnetClient.assertCond(code == 0 || code == 1);
            bytes.add(code);
            if (code == 0) {
                throw new IllegalStateException();
            }
            if (code == 1) {
                iac = this._inputStream.read();
                GogoTelnetClient.assertCond(iac == 255);
                bytes.add(iac);
                int se = this._inputStream.read();
                GogoTelnetClient.assertCond(se == 240);
                bytes.add(se);
            }
        } else {
            bytes.add(this._inputStream.read());
        }
        return GogoTelnetClient.toIntArray(bytes);
    }

    static int[] toIntArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        int i = 0;
        for (Integer e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    @Override
    public void close() {
        try {
            this._socket.close();
            this._inputStream.close();
            this._outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

