/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import aQute.remote.api.Agent;
import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.LiferayRuntimeClasspathEntry;
import com.liferay.ide.core.properties.PortalPropertiesConfiguration;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.server.core.ILiferayServerBehavior;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.BundleSupervisor;
import com.liferay.ide.server.core.portal.PortalRuntime;
import com.liferay.ide.server.core.portal.PortalServer;
import com.liferay.ide.server.util.PingThread;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.osgi.framework.Version;

public class PortalServerBehavior
extends ServerBehaviourDelegate
implements ILiferayServerBehavior,
IJavaLaunchConfigurationConstants {
    public static final String ATTR_STOP = "stop-server";
    private static final String[] JMX_EXCLUDE_ARGS = new String[]{"-Dcom.sun.management.jmxremote", "-Dcom.sun.management.jmxremote.port=", "-Dcom.sun.management.jmxremote.ssl=", "-Dcom.sun.management.jmxremote.authenticate="};
    private IAdaptable info;
    private transient PingThread ping = null;
    private transient IDebugEventSetListener processListener;

    public void addProcessListener(final IProcess newProcess) {
        if (this.processListener != null || newProcess == null) {
            return;
        }
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    DebugEvent[] debugEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugEvent event = debugEventArray[n2];
                        if (newProcess != null && newProcess.equals(event.getSource()) && event.getKind() == 8) {
                            PortalServerBehavior.this.cleanup();
                        }
                        ++n2;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    public boolean canRestartModule(IModule[] modules) {
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            IProject project = module.getProject();
            if (project == null) {
                return false;
            }
            IBundleProject bundleProject = (IBundleProject)LiferayCore.create(IBundleProject.class, (Object)project);
            if (bundleProject != null && !bundleProject.isFragmentBundle()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void cleanup() {
        if (this.ping != null) {
            this.ping.stop();
            this.ping = null;
        }
        if (this.processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
            this.processListener = null;
        }
        this.setServerState(4);
    }

    public String getClassToLaunch() {
        return this.getPortalRuntime().getPortalBundle().getMainClass();
    }

    @Override
    public IPath getDeployedPath(IModule[] module) {
        return null;
    }

    public IAdaptable getInfo() {
        return this.info;
    }

    private int getNextToken(String s, int start) {
        int i = start;
        int length = s.length();
        int lookFor = 32;
        while (i < length) {
            int c = s.charAt(i);
            if (lookFor == c) {
                if (lookFor == 34) {
                    return i + 1;
                }
                return i;
            }
            if (c == 34) {
                lookFor = 34;
            }
            ++i;
        }
        return -1;
    }

    private PortalRuntime getPortalRuntime() {
        PortalRuntime retval = null;
        if (this.getServer().getRuntime() != null) {
            retval = (PortalRuntime)this.getServer().getRuntime().loadAdapter(PortalRuntime.class, null);
        }
        return retval;
    }

    private PortalServer getPortalServer() {
        PortalServer retval = null;
        if (this.getServer() != null) {
            retval = (PortalServer)this.getServer().loadAdapter(PortalServer.class, null);
        }
        return retval;
    }

    private String[] getRuntimeStartProgArgs() {
        return this.getPortalRuntime().getPortalBundle().getRuntimeStartProgArgs();
    }

    private String[] getRuntimeStartVMArguments() {
        if (!this.getPortalServer().getLaunchSettings()) {
            File portalext = this.getPortalRuntime().getLiferayHome().append("portal-ext.properties").toFile();
            if (this.getPortalServer().getDeveloperMode()) {
                try {
                    if (!portalext.exists()) {
                        portalext.createNewFile();
                    }
                    PortalPropertiesConfiguration config = new PortalPropertiesConfiguration();
                    FileInputStream in = new FileInputStream(portalext);
                    config.load((InputStream)in);
                    ((InputStream)in).close();
                    String[] p = config.getStringArray("include-and-override");
                    boolean existing = false;
                    String[] stringArray = p;
                    int n = p.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String prop = stringArray[n2];
                        if (prop.equals("portal-developer.properties")) {
                            existing = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!existing) {
                        config.addProperty("include-and-override", (Object)"portal-developer.properties");
                    }
                    config.save(portalext);
                }
                catch (Exception e) {
                    LiferayServerCore.logError(e);
                }
            } else if (portalext.exists()) {
                String contents = FileUtil.readContents((File)portalext, (boolean)true);
                contents = contents.replace("include-and-override=portal-developer.properties", "");
                try {
                    FileUtils.write((File)portalext, (CharSequence)contents);
                }
                catch (IOException e) {
                    LiferayServerCore.logError(e);
                }
            }
        }
        ArrayList<String> retval = new ArrayList<String>();
        Collections.addAll(retval, this.getPortalServer().getMemoryArgs());
        Collections.addAll(retval, this.getPortalRuntime().getPortalBundle().getRuntimeStartVMArgs());
        int agentPort = this.getServer().getAttribute("AGENT_PORT", 29998);
        retval.add("-DaQute.agent.server.port=" + agentPort);
        return retval.toArray(new String[0]);
    }

    private String[] getRuntimeStopProgArgs() {
        return this.getPortalRuntime().getPortalBundle().getRuntimeStopProgArgs();
    }

    private String[] getRuntimeStopVMArguments() {
        ArrayList retval = new ArrayList();
        Collections.addAll(retval, this.getPortalServer().getMemoryArgs());
        Collections.addAll(retval, this.getPortalRuntime().getPortalBundle().getRuntimeStopVMArgs());
        return retval.toArray(new String[0]);
    }

    public void launchServer(ILaunch launch, String mode, IProgressMonitor monitor) throws CoreException {
        if ("true".equals(launch.getLaunchConfiguration().getAttribute(ATTR_STOP, "false"))) {
            return;
        }
        IStatus status = this.getPortalRuntime().validate();
        if (status != null && status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        this.setServerRestartState(false);
        this.setServerState(1);
        this.setMode(mode);
        try {
            String url = "http://" + this.getServer().getHost();
            int port = Integer.parseInt(this.getPortalRuntime().getPortalBundle().getHttpPort());
            if (port != 80) {
                url = String.valueOf(url) + ":" + port;
            }
            this.ping = new PingThread(this.getServer(), url, -1, this);
        }
        catch (Exception e) {
            LiferayServerCore.logError("Can't ping for portal startup.");
        }
    }

    private String mergeArguments(String orgArgsString, String[] newArgs, String[] excludeArgs, boolean keepActionLast) {
        String retval = null;
        if (CoreUtil.isNullOrEmpty((Object[])newArgs) && CoreUtil.isNullOrEmpty((Object[])excludeArgs)) {
            retval = orgArgsString;
        } else {
            int index;
            int ind2;
            int ind;
            retval = orgArgsString == null ? "" : orgArgsString;
            String xbootClasspath = "";
            int size = newArgs.length;
            int i = 0;
            while (i < size) {
                if (newArgs[i].startsWith("-Xbootclasspath")) {
                    xbootClasspath = String.valueOf(xbootClasspath) + newArgs[i] + " ";
                    newArgs[i] = null;
                } else {
                    ind = newArgs[i].indexOf(" ");
                    ind2 = newArgs[i].indexOf("=");
                    if (ind >= 0 && (ind2 == -1 || ind < ind2)) {
                        index = retval.indexOf(newArgs[i].substring(0, ind + 1));
                        if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                            newArgs[i] = null;
                        }
                    } else if (ind2 >= 0) {
                        index = retval.indexOf(newArgs[i].substring(0, ind2 + 1));
                        if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                            newArgs[i] = null;
                        }
                    } else {
                        index = retval.indexOf(newArgs[i]);
                        if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                            newArgs[i] = null;
                        }
                    }
                }
                ++i;
            }
            if (excludeArgs != null && excludeArgs.length > 0) {
                i = 0;
                while (i < excludeArgs.length) {
                    int index2;
                    String s;
                    ind = excludeArgs[i].indexOf(" ");
                    ind2 = excludeArgs[i].indexOf("=");
                    if (ind >= 0 && (ind2 == -1 || ind < ind2)) {
                        index = retval.indexOf(excludeArgs[i].substring(0, ind + 1));
                        if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                            s = retval.substring(0, index);
                            index2 = this.getNextToken(retval, index + ind + 1);
                            if (index2 >= 0) {
                                while (index2 < retval.length() && Character.isWhitespace(retval.charAt(index2))) {
                                    ++index2;
                                }
                                retval = String.valueOf(s) + retval.substring(index2);
                            } else {
                                retval = s;
                            }
                        }
                    } else if (ind2 >= 0) {
                        index = retval.indexOf(excludeArgs[i].substring(0, ind2 + 1));
                        if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                            s = retval.substring(0, index);
                            index2 = this.getNextToken(retval, index);
                            if (index2 >= 0) {
                                while (index2 < retval.length() && Character.isWhitespace(retval.charAt(index2))) {
                                    ++index2;
                                }
                                retval = String.valueOf(s) + retval.substring(index2);
                            } else {
                                retval = s;
                            }
                        }
                    } else {
                        index = retval.indexOf(excludeArgs[i]);
                        if (index == 0 || index > 0 && Character.isWhitespace(retval.charAt(index - 1))) {
                            s = retval.substring(0, index);
                            index2 = this.getNextToken(retval, index);
                            if (index2 >= 0) {
                                while (index2 < retval.length() && Character.isWhitespace(retval.charAt(index2))) {
                                    ++index2;
                                }
                                retval = String.valueOf(s) + retval.substring(index2);
                            } else {
                                retval = s;
                            }
                        }
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < size) {
                if (newArgs[i] != null) {
                    if (retval.length() > 0 && !retval.endsWith(" ")) {
                        retval = String.valueOf(retval) + " ";
                    }
                    retval = String.valueOf(retval) + newArgs[i];
                }
                ++i;
            }
            if (!CoreUtil.isNullOrEmpty((String)xbootClasspath)) {
                int xbootIndex = retval.lastIndexOf("-Xbootclasspath");
                while (xbootIndex != -1) {
                    String head = retval.substring(0, xbootIndex);
                    int tailIndex = this.getNextToken(retval, xbootIndex);
                    String tail = retval.substring(tailIndex == retval.length() ? retval.length() : tailIndex + 1);
                    retval = String.valueOf(head) + tail;
                    xbootIndex = retval.lastIndexOf("-Xbootclasspath");
                }
                retval = String.valueOf(retval) + " " + xbootClasspath;
            }
        }
        return retval;
    }

    private void mergeClasspath(List<IRuntimeClasspathEntry> oldCpEntries, IRuntimeClasspathEntry cpEntry) {
        for (IRuntimeClasspathEntry oldCpEntry : oldCpEntries) {
            if (!oldCpEntry.getPath().equals((Object)cpEntry.getPath())) continue;
            return;
        }
        oldCpEntries.add(cpEntry);
    }

    public synchronized void publish(int kind, List<IModule[]> modules, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        this.info = info;
        super.publish(kind, modules, monitor, info);
        this.info = null;
    }

    protected void publishModule(int kind, int deltaKind, IModule[] modules, IProgressMonitor monitor) throws CoreException {
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        this.setServerPublishState(0);
    }

    @Override
    public void redeployModule(final IModule[] module) throws CoreException {
        this.setModulePublishState(module, 3);
        IAdaptable info = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (String.class.equals((Object)adapter)) {
                    return "user";
                }
                if (IModule.class.equals((Object)adapter)) {
                    return module[0];
                }
                return null;
            }
        };
        ArrayList<IModule[]> modules = new ArrayList<IModule[]>();
        modules.add(module);
        this.publish(2, modules, null, info);
    }

    private void replaceJREConatiner(List<IRuntimeClasspathEntry> oldCp, IRuntimeClasspathEntry newJRECp) {
        int size = oldCp.size();
        int i = 0;
        while (i < size) {
            IRuntimeClasspathEntry entry2 = oldCp.get(i);
            if (entry2.getPath().uptoSegment(2).isPrefixOf(newJRECp.getPath())) {
                oldCp.set(i, newJRECp);
                return;
            }
            ++i;
        }
        oldCp.add(0, newJRECp);
    }

    public void setModulePublishState2(IModule[] module, int state) {
        super.setModulePublishState(module, state);
    }

    public void setModuleState2(IModule[] modules, int state) {
        super.setModuleState(modules, state);
    }

    public void setServerStarted() {
        this.setServerState(2);
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy launch, IProgressMonitor monitor) throws CoreException {
        String existingProgArgs = launch.getAttribute(ATTR_PROGRAM_ARGUMENTS, null);
        launch.setAttribute(ATTR_PROGRAM_ARGUMENTS, this.mergeArguments(existingProgArgs, this.getRuntimeStartProgArgs(), null, true));
        String existingVMArgs = launch.getAttribute(ATTR_VM_ARGUMENTS, null);
        String[] configVMArgs = this.getRuntimeStartVMArguments();
        launch.setAttribute(ATTR_VM_ARGUMENTS, this.mergeArguments(existingVMArgs, configVMArgs, null, false));
        PortalRuntime portalRuntime = this.getPortalRuntime();
        IVMInstall vmInstall = portalRuntime.getVMInstall();
        if (vmInstall != null) {
            launch.setAttribute(ATTR_JRE_CONTAINER_PATH, JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString());
        }
        IRuntimeClasspathEntry[] orgClasspath = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)launch);
        int orgClasspathSize = orgClasspath.length;
        ArrayList<IRuntimeClasspathEntry> oldCp = new ArrayList<IRuntimeClasspathEntry>(orgClasspathSize);
        Collections.addAll(oldCp, orgClasspath);
        List<IRuntimeClasspathEntry> runCpEntries = portalRuntime.getRuntimeClasspathEntries();
        for (IRuntimeClasspathEntry cpEntry : runCpEntries) {
            this.mergeClasspath(oldCp, cpEntry);
        }
        if (vmInstall != null) {
            IPath toolsPath;
            try {
                String typeId = vmInstall.getVMInstallType().getId();
                IRuntimeClasspathEntry newJRECp = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append(typeId).append(vmInstall.getName()), (int)2);
                this.replaceJREConatiner(oldCp, newJRECp);
            }
            catch (Exception typeId) {
                // empty catch block
            }
            Path jrePath = new Path(vmInstall.getInstallLocation().getAbsolutePath());
            if (jrePath != null && (toolsPath = jrePath.append("lib/tools.jar")).toFile().exists()) {
                IRuntimeClasspathEntry toolsJar = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)toolsPath);
                int toolsIndex = 0;
                while (toolsIndex < oldCp.size()) {
                    IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)oldCp.get(toolsIndex);
                    if (entry.getType() == 2 && entry.getPath().lastSegment().equals("tools.jar")) break;
                    ++toolsIndex;
                }
                if (toolsIndex < oldCp.size()) {
                    oldCp.set(toolsIndex, toolsJar);
                } else {
                    this.mergeClasspath(oldCp, toolsJar);
                }
            }
        }
        ArrayList<String> cp = new ArrayList<String>();
        for (IRuntimeClasspathEntry entry : oldCp) {
            try {
                if (entry.getClasspathEntry().getEntryKind() != 5) {
                    entry = new LiferayRuntimeClasspathEntry(entry.getClasspathEntry());
                }
                cp.add(entry.getMemento());
            }
            catch (Exception e) {
                LiferayServerCore.logError("Could not resolve cp entry " + entry, e);
            }
        }
        launch.setAttribute(ATTR_CLASSPATH, cp);
        launch.setAttribute(ATTR_DEFAULT_CLASSPATH, false);
        this.setupAgent();
        this.setupAriesJmxBundles();
    }

    private void setupAgent() {
        Throwable throwable;
        IPath staticPath = this.getPortalRuntime().getPortalBundle().getLiferayHome().append("osgi/static");
        if (staticPath.append("biz.aQute.remote.agent.jar").toFile().exists()) {
            try {
                Files.delete(Paths.get(staticPath.append("biz.aQute.remote.agent.jar").toOSString(), new String[0]));
            }
            catch (IOException e) {
                LiferayServerCore.logError("Unable to remove old remote agent bundle", e);
            }
        }
        IPath modulesPath = this.getPortalRuntime().getPortalBundle().getLiferayHome().append("osgi/modules");
        IPath agentInstalledPath = modulesPath.append("biz.aQute.remote.agent.jar");
        File modulesDir = modulesPath.toFile();
        if (!modulesDir.exists()) {
            modulesDir.mkdirs();
        }
        File agentFile = agentInstalledPath.toFile();
        File embeddedAgentFile = null;
        String embeddedAgentVersion = null;
        try {
            embeddedAgentFile = new File(FileLocator.toFileURL((URL)LiferayServerCore.getDefault().getBundle().getEntry("bundles/biz.aQute.remote.agent.jar")).getFile());
        }
        catch (IOException e) {
            LiferayServerCore.logError("Unable to get embedded biz.aQute.remote.agent.jar", e);
        }
        try {
            Throwable e = null;
            throwable = null;
            try (JarFile embededJarFile = new JarFile(embeddedAgentFile);){
                embeddedAgentVersion = embededJarFile.getManifest().getMainAttributes().getValue("Bundle-Version");
            }
            catch (Throwable throwable2) {
                if (e == null) {
                    e = throwable2;
                } else if (e != throwable2) {
                    e.addSuppressed(throwable2);
                }
                throw e;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (agentFile.exists()) {
            boolean shouldDelete = true;
            try {
                throwable = null;
                Object var10_19 = null;
                try (JarFile jarFile = new JarFile(agentFile);){
                    Version atLeastVersion;
                    Version version;
                    String bundleVersion = jarFile.getManifest().getMainAttributes().getValue("Bundle-Version");
                    if (!CoreUtil.empty((String)bundleVersion) && (version = new Version(bundleVersion)).compareTo(atLeastVersion = new Version(embeddedAgentVersion)) >= 0) {
                        shouldDelete = false;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (shouldDelete) {
                try {
                    Files.delete(agentFile.toPath());
                }
                catch (IOException e) {
                    LiferayServerCore.logError("Unable to remove old remote agent bundle", e);
                }
            }
        }
        if (!agentFile.exists()) {
            FileUtil.copyFile((File)embeddedAgentFile, (File)agentFile);
        }
    }

    private void setupAriesJmxBundles() {
        File bundleFile;
        String[] ariesJmxBundleNames = new String[]{"org.apache.aries.jmx.api.jar", "org.apache.aries.jmx.core.jar", "org.apache.aries.util.jar"};
        String[] ariesJxmBundleFullNames = new String[]{"org.apache.aries.jmx.api-1.1.5.jar", "org.apache.aries.jmx.core-1.1.7.jar", "org.apache.aries.util-1.1.3.jar"};
        IPath staticPath = this.getPortalRuntime().getPortalBundle().getLiferayHome().append("osgi/static");
        String[] stringArray = ariesJmxBundleNames;
        int n = ariesJmxBundleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleName = stringArray[n2];
            bundleFile = staticPath.append(bundleName).toFile();
            if (bundleFile.exists()) {
                try {
                    Files.delete(bundleFile.toPath());
                }
                catch (IOException e) {
                    LiferayServerCore.logError("Unable to remove " + bundleName + " in liferay home osgi/static", e);
                }
            }
            ++n2;
        }
        if (!this.shouldSetUpAriesJmxBundles()) {
            return;
        }
        IPath modulesPath = this.getPortalRuntime().getPortalBundle().getLiferayHome().append("osgi/modules");
        File modulesDir = modulesPath.toFile();
        if (!modulesDir.exists()) {
            modulesDir.mkdirs();
        }
        int i = 0;
        while (i < ariesJmxBundleNames.length) {
            IPath agentInstalledPath = modulesPath.append(ariesJmxBundleNames[i]);
            bundleFile = agentInstalledPath.toFile();
            if (!bundleFile.exists()) {
                try {
                    File file = new File(FileLocator.toFileURL((URL)LiferayServerCore.getDefault().getBundle().getEntry("bundles/" + ariesJxmBundleFullNames[i])).getFile());
                    FileUtil.copyFile((File)file, (File)bundleFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shouldSetUpAriesJmxBundles() {
        portalImplFile = this.getPortalRuntime().getAppServerPortalDir().append("WEB-INF/lib/portal-impl.jar").toFile();
        if (!portalImplFile.exists()) {
            return true;
        }
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                jarFile = new JarFile(portalImplFile);
                try {
                    manifest = jarFile.getManifest().getMainAttributes();
                    buildNumber = manifest.getValue("Liferay-Portal-Build-Number").trim();
                    patchAttr = manifest.getValue("Liferay-Portal-Installed-Patches");
                    if (buildNumber.equals("7010")) {
                        if (CoreUtil.empty((String)patchAttr)) {
                            return false;
                        }
                        result = patchAttr.trim().split("-");
                        if (result == null) return false;
                        if (result.length < 3) {
                            return false;
                        }
                        patchVersion = Integer.parseInt(result[1]);
                        if (patchVersion >= 9) {
                            v0 = true;
                            return v0;
                        }
                        v0 = false;
                        return v0;
                    }
                    if (buildNumber.startsWith("700") == false) return true;
                    currentCEVersion = new Version(buildNumber);
                    lp70ga3 = new Version("7002");
                    v1 = currentCEVersion.compareTo(lp70ga3) > 0;
                    ** try [egrp 6[TRYBLOCK] [4 : 236->237)] { 
                }
lbl32:
                // 1 sources

                catch (Throwable var2_3) {
                    throw var2_3;
                }
                finally {
                    if (jarFile == null) return false;
                    jarFile.close();
                }
lbl31:
                // 1 sources

                return v1;
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                    throw var2_2;
                }
                if (var2_2 == var3_6) throw var2_2;
                var2_2.addSuppressed(var3_6);
                throw var2_2;
            }
        }
        catch (Exception e) {
            LiferayServerCore.logError("get portal version and patch info error", e);
        }
        return true;
    }

    public void startModule(IModule[] modules, IProgressMonitor monitor) throws CoreException {
        this.startOrStopModules(modules, "start", monitor);
    }

    public void stopModule(IModule[] modules, IProgressMonitor monitor) throws CoreException {
        this.startOrStopModules(modules, "stop", monitor);
    }

    private void startOrStopModules(IModule[] modules, String action, IProgressMonitor monitor) {
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            block24: {
                IBundleProject bundleProject;
                IModule module = iModuleArray[n2];
                IProject project = module.getProject();
                if (project != null && (bundleProject = (IBundleProject)LiferayCore.create(IBundleProject.class, (Object)project)) != null) {
                    BundleSupervisor supervisor = null;
                    try {
                        try {
                            String symbolicName = bundleProject.getSymbolicName();
                            supervisor = this.createBundleSupervisor();
                            long bundleId = supervisor.getBundleId(symbolicName);
                            if (bundleId > 0L) {
                                String error;
                                if (action.equals("start")) {
                                    error = ((Agent)supervisor.getAgent()).start(new long[]{bundleId});
                                    if (error == null) {
                                        this.setModuleState(new IModule[]{module}, 2);
                                    } else {
                                        LiferayServerCore.logError("Unable to start this bundle");
                                    }
                                } else if (action.equals("stop")) {
                                    error = ((Agent)supervisor.getAgent()).stop(new long[]{bundleId});
                                    if (error == null) {
                                        this.setModuleState(new IModule[]{module}, 4);
                                    } else {
                                        LiferayServerCore.logError("Unable to stop this bundle");
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            LiferayServerCore.logError("Unable to " + action + " module", e);
                            if (supervisor != null) {
                                try {
                                    supervisor.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        if (supervisor != null) {
                            try {
                                supervisor.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (supervisor != null) {
                        try {
                            supervisor.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public void stop(boolean force) {
        if (force) {
            this.terminate();
            return;
        }
        int state = this.getServer().getServerState();
        if (state == 4 || state == 3) {
            return;
        }
        if (state == 1) {
            this.terminate();
            return;
        }
        try {
            if (state != 4) {
                this.setServerState(3);
            }
            ILaunchConfiguration launchConfig = ((Server)this.getServer()).getLaunchConfiguration(false, null);
            ILaunchConfigurationWorkingCopy wc = launchConfig.getWorkingCopy();
            String args = PortalServerBehavior.renderCommandLine(this.getRuntimeStopProgArgs(), " ");
            String existingVMArgs = wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
            if (existingVMArgs.indexOf(JMX_EXCLUDE_ARGS[0]) >= 0) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.mergeArguments(existingVMArgs, this.getRuntimeStopVMArguments(), JMX_EXCLUDE_ARGS, false));
            } else {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.mergeArguments(existingVMArgs, this.getRuntimeStopVMArguments(), null, true));
            }
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
            wc.setAttribute("org.eclipse.debug.ui.private", true);
            wc.setAttribute(ATTR_STOP, "true");
            wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            LiferayServerCore.logError("Error stopping portal", e);
        }
    }

    protected void terminate() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        try {
            this.setServerState(3);
            ILaunch launch = this.getServer().getLaunch();
            if (launch != null) {
                launch.terminate();
                this.cleanup();
            }
        }
        catch (Exception e) {
            LiferayServerCore.logError("Error killing the process", e);
        }
    }

    protected static String renderCommandLine(String[] commandLine, String separator) {
        if (commandLine == null || commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(separator);
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    public BundleSupervisor createBundleSupervisor() throws Exception {
        return ServerUtil.createBundleSupervisor(this.getPortalRuntime(), this.getServer());
    }
}

