/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.dd;

import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.portlet.core.operation.INewPortletClassDataModelProperties;
import com.liferay.ide.project.core.descriptor.AddNewPortletOperation;
import com.liferay.ide.project.core.descriptor.IDescriptorOperation;
import com.liferay.ide.project.core.descriptor.LiferayDescriptorHelper;
import com.liferay.ide.project.core.descriptor.RemoveAllPortletsOperation;
import com.liferay.ide.project.core.descriptor.RemoveSampleElementsOperation;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LiferayDisplayDescriptorHelper
extends LiferayDescriptorHelper
implements INewPortletClassDataModelProperties {
    public static final String DESCRIPTOR_FILE = "liferay-display.xml";
    private static final String DESCRIPTOR_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE display PUBLIC \"-//Liferay//DTD Display {0}//EN\" \"http://www.liferay.com/dtd/liferay-display_{1}.dtd\">\n\n<display>\n</display>";

    public LiferayDisplayDescriptorHelper() {
    }

    public LiferayDisplayDescriptorHelper(IProject project) {
        super(project);
    }

    protected void addDescriptorOperations() {
        this.addDescriptorOperation((IDescriptorOperation)new AddNewPortletOperation(){

            public IStatus addNewPortlet(final IDataModel model) {
                IStatus status = Status.OK_STATUS;
                IFile descriptorFile = LiferayDisplayDescriptorHelper.this.getDescriptorFile();
                if (descriptorFile != null) {
                    LiferayDescriptorHelper.DOMModelEditOperation domModelOperation = new LiferayDescriptorHelper.DOMModelEditOperation(LiferayDisplayDescriptorHelper.this, descriptorFile){

                        protected void createDefaultFile() {
                            this.createDefaultDescriptor(LiferayDisplayDescriptorHelper.DESCRIPTOR_TEMPLATE, LiferayDisplayDescriptorHelper.this.getDescriptorVersion());
                        }

                        protected IStatus doExecute(IDOMDocument document) {
                            return LiferayDisplayDescriptorHelper.this.doAddNewPortlet(document, model);
                        }
                    };
                    status = domModelOperation.execute();
                }
                return status;
            }
        });
        this.addDescriptorOperation((IDescriptorOperation)new RemoveAllPortletsOperation(){

            public IStatus removeAllPortlets() {
                return this.removeAllPortlets();
            }
        });
        this.addDescriptorOperation((IDescriptorOperation)new RemoveSampleElementsOperation(){

            public IStatus removeSampleElements() {
                return LiferayDisplayDescriptorHelper.this.removeAllPortlets();
            }
        });
    }

    public IStatus configureLiferayDisplayXml(final String newPortletName) {
        IStatus status = new LiferayDescriptorHelper.DOMModelEditOperation(this, this.getDescriptorFile()){

            protected IStatus doExecute(IDOMDocument document) {
                Element rootElement = document.getDocumentElement();
                NodeList portletNodes = rootElement.getElementsByTagName("category");
                if (portletNodes.getLength() > 0) {
                    Element lastPortletElement = (Element)portletNodes.item(portletNodes.getLength() - 1);
                    Element portletName = NodeUtil.findChildElement((Element)lastPortletElement, (String)"portlet");
                    portletName.setAttribute("id", newPortletName);
                }
                return Status.OK_STATUS;
            }
        }.execute();
        return status;
    }

    protected IStatus doAddNewPortlet(IDOMDocument document, IDataModel model) {
        Element rootElement = document.getDocumentElement();
        Element category = null;
        String modelCategory = model.getStringProperty("INewPortletClassDataModelProperties.CATEGORY");
        for (Element child : this.getChildElements(rootElement)) {
            if (!child.getNodeName().equals("category") || !modelCategory.equals(child.getAttribute("name"))) continue;
            category = child;
            break;
        }
        Element id = null;
        String modelId = model.getStringProperty("INewPortletClassDataModelProperties.ID");
        if (category != null) {
            for (Element child : this.getChildElements(category)) {
                if (!child.getNodeName().equals("portlet") || !modelId.equals(child.getAttribute("id"))) continue;
                id = child;
                break;
            }
        } else {
            category = document.createElement("category");
            category.setAttribute("name", modelCategory);
            rootElement.appendChild(category);
            Text newline = document.createTextNode(System.getProperty("line.separator"));
            rootElement.appendChild(newline);
        }
        if (id == null) {
            NodeUtil.appendChildElement((Element)category, (String)"portlet").setAttribute("id", modelId);
        }
        FormatProcessorXML processor = new FormatProcessorXML();
        processor.formatNode((Node)category);
        return Status.OK_STATUS;
    }

    public String[] getAllPortletCategories() {
        final ArrayList allPortletCategories = new ArrayList();
        IFile descriptorFile = this.getDescriptorFile();
        if (descriptorFile != null) {
            LiferayDescriptorHelper.DOMModelReadOperation op = new LiferayDescriptorHelper.DOMModelReadOperation(this, descriptorFile){

                protected IStatus doExecute(IDOMDocument document) {
                    NodeList nodeList = document.getElementsByTagName("category");
                    if (nodeList != null && nodeList.getLength() > 0) {
                        int i = 0;
                        while (i < nodeList.getLength()) {
                            Element categoryElemnt = (Element)nodeList.item(i);
                            String categoryName = categoryElemnt.getAttribute("name");
                            if (categoryName != null && !categoryName.matches("\\s*")) {
                                allPortletCategories.add(categoryName);
                            }
                            ++i;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            op.execute();
        }
        return allPortletCategories.toArray(new String[0]);
    }

    public IFile getDescriptorFile() {
        return super.getDescriptorFile(DESCRIPTOR_FILE);
    }

    protected IStatus removeAllPortlets() {
        String categoryTagName = "category";
        LiferayDescriptorHelper.DOMModelEditOperation domModelOperation = new LiferayDescriptorHelper.DOMModelEditOperation(this, this.getDescriptorFile()){

            protected IStatus doExecute(IDOMDocument document) {
                return LiferayDisplayDescriptorHelper.this.removeAllElements(document, "category");
            }
        };
        IStatus status = domModelOperation.execute();
        return status;
    }
}

