/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.dd;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.portlet.core.operation.INewPortletClassDataModelProperties;
import com.liferay.ide.project.core.descriptor.AddNewPortletOperation;
import com.liferay.ide.project.core.descriptor.IDescriptorOperation;
import com.liferay.ide.project.core.descriptor.LiferayDescriptorHelper;
import com.liferay.ide.project.core.descriptor.RemoveAllPortletsOperation;
import com.liferay.ide.project.core.descriptor.RemoveSampleElementsOperation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortletDescriptorHelper
extends LiferayDescriptorHelper
implements INewPortletClassDataModelProperties {
    public static final String DESCRIPTOR_FILE = "portlet.xml";
    private static final String DESCRIPTOR_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<portlet-app xmlns=\"http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd\" version=\"2.0\">\n</portlet-app>";

    public PortletDescriptorHelper() {
    }

    public PortletDescriptorHelper(IProject project) {
        super(project);
    }

    protected void addDescriptorOperations() {
        this.addDescriptorOperation((IDescriptorOperation)new RemoveSampleElementsOperation(){

            public IStatus removeSampleElements() {
                return PortletDescriptorHelper.this.doRemoveAllPortlets();
            }
        });
        this.addDescriptorOperation((IDescriptorOperation)new AddNewPortletOperation(){

            public IStatus addNewPortlet(final IDataModel model) {
                IFile descriptorFile;
                IStatus status = Status.OK_STATUS;
                if (PortletDescriptorHelper.this.canAddNewPortlet(model) && (descriptorFile = PortletDescriptorHelper.this.getDescriptorFile()) != null) {
                    LiferayDescriptorHelper.DOMModelEditOperation domModelOperation = new LiferayDescriptorHelper.DOMModelEditOperation(PortletDescriptorHelper.this, descriptorFile){

                        protected void createDefaultFile() {
                            this.createDefaultDescriptor(PortletDescriptorHelper.DESCRIPTOR_TEMPLATE, "");
                        }

                        protected IStatus doExecute(IDOMDocument document) {
                            return PortletDescriptorHelper.this.doAddNewPortlet(document, model);
                        }
                    };
                    status = domModelOperation.execute();
                }
                return status;
            }
        });
        this.addDescriptorOperation((IDescriptorOperation)new RemoveAllPortletsOperation(){

            public IStatus removeAllPortlets() {
                return PortletDescriptorHelper.this.doRemoveAllPortlets();
            }
        });
    }

    public IStatus addResourceBundle(final String resourceBundle, final String portletName) {
        IFile descriptorFile = this.getDescriptorFile();
        LiferayDescriptorHelper.DOMModelEditOperation operation = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

            protected IStatus doExecute(IDOMDocument document) {
                return PortletDescriptorHelper.this.doAddResourceBundle(document, resourceBundle, portletName);
            }
        };
        return operation.execute();
    }

    public boolean canAddNewPortlet(IDataModel model) {
        return model.getID().contains("NewPortlet");
    }

    public IStatus configurePortletXml(final String newPortletName) {
        IFile descriptorFile = this.getDescriptorFile();
        IStatus status = new LiferayDescriptorHelper.DOMModelEditOperation(this, descriptorFile){

            protected IStatus doExecute(IDOMDocument document) {
                Element rootElement = document.getDocumentElement();
                NodeList portletNodes = rootElement.getElementsByTagName("portlet");
                if (portletNodes.getLength() > 0) {
                    Element lastPortletElement = (Element)portletNodes.item(portletNodes.getLength() - 1);
                    Element portletName = NodeUtil.findChildElement((Element)lastPortletElement, (String)"portlet-name");
                    portletName.replaceChild(document.createTextNode(newPortletName), portletName.getFirstChild());
                }
                return Status.OK_STATUS;
            }
        }.execute();
        return status;
    }

    public IStatus doAddNewPortlet(IDOMDocument document, IDataModel model) {
        Element rootElement = document.getDocumentElement();
        Element newPortletElement = document.createElement("portlet");
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"portlet-name", (String)model.getStringProperty("INewPortletClassDataModelProperties.PORTLET_NAME"));
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"display-name", (String)model.getStringProperty("INewPortletClassDataModelProperties.DISPLAY_NAME"));
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"portlet-class", (String)this.getPortletClassText(model));
        List initParams = (List)model.getProperty("INewPortletClassDataModelProperties.INIT_PARAMS");
        for (ParamValue initParam : initParams) {
            Element newInitParamElement = NodeUtil.appendChildElement((Element)newPortletElement, (String)"init-param");
            NodeUtil.appendChildElement((Element)newInitParamElement, (String)"name", (String)initParam.getName());
            NodeUtil.appendChildElement((Element)newInitParamElement, (String)"value", (String)initParam.getValue());
        }
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"expiration-cache", (String)"0");
        Element newSupportsElement = NodeUtil.appendChildElement((Element)newPortletElement, (String)"supports");
        NodeUtil.appendChildElement((Element)newSupportsElement, (String)"mime-type", (String)"text/html");
        String[] stringArray = ALL_PORTLET_MODES;
        int n = ALL_PORTLET_MODES.length;
        int newInitParamElement = 0;
        while (newInitParamElement < n) {
            String portletMode = stringArray[newInitParamElement];
            if (model.getBooleanProperty(portletMode)) {
                NodeUtil.appendChildElement((Element)newSupportsElement, (String)"portlet-mode", (String)model.getPropertyDescriptor(portletMode).getPropertyDescription());
            }
            ++newInitParamElement;
        }
        if (model.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE")) {
            String bundlePath = model.getStringProperty("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE_PATH");
            String bundleValue = bundlePath.replaceAll("\\.properties$", "");
            String validBuildValue = bundleValue.replaceAll("\\/", ".");
            NodeUtil.appendChildElement((Element)newPortletElement, (String)"resource-bundle", (String)validBuildValue);
        }
        Element newPortletInfoElement = NodeUtil.appendChildElement((Element)newPortletElement, (String)"portlet-info");
        NodeUtil.appendChildElement((Element)newPortletInfoElement, (String)"title", (String)model.getStringProperty("INewPortletClassDataModelProperties.TITLE"));
        NodeUtil.appendChildElement((Element)newPortletInfoElement, (String)"short-title", (String)model.getStringProperty("INewPortletClassDataModelProperties.SHORT_TITLE"));
        NodeUtil.appendChildElement((Element)newPortletInfoElement, (String)"keywords", (String)model.getStringProperty("INewPortletClassDataModelProperties.KEYWORDS"));
        String[] stringArray2 = DEFAULT_SECURITY_ROLE_NAMES;
        int n2 = DEFAULT_SECURITY_ROLE_NAMES.length;
        int validBuildValue = 0;
        while (validBuildValue < n2) {
            String roleName = stringArray2[validBuildValue];
            NodeUtil.appendChildElement((Element)NodeUtil.appendChildElement((Element)newPortletElement, (String)"security-role-ref"), (String)"role-name", (String)roleName);
            ++validBuildValue;
        }
        Node refNode = null;
        String[] refElementNames = new String[]{"custom-portlet-mode", "custom-window-state", "user-attribute", "security-constraint", "resource-bundle", "filter", "filter-mapping", "default-namespace", "event-definition", "public-render-parameter", "listener", "container-runtime-option"};
        int i = 0;
        while (i < refElementNames.length) {
            refNode = NodeUtil.findFirstChild((Element)rootElement, (String)refElementNames[i]);
            if (refNode != null) break;
            ++i;
        }
        rootElement.insertBefore(newPortletElement, refNode);
        rootElement.appendChild(document.createTextNode(System.getProperty("line.separator")));
        FormatProcessorXML processor = new FormatProcessorXML();
        processor.formatNode((Node)newPortletElement);
        return Status.OK_STATUS;
    }

    protected IStatus doAddResourceBundle(IDOMDocument document, String resourceBundle, String portletName) {
        FormatProcessorXML processor = new FormatProcessorXML();
        NodeList portletNameList = document.getElementsByTagName("portlet-name");
        if (portletNameList != null && portletNameList.getLength() > 0 && !CoreUtil.isNullOrEmpty((String)resourceBundle)) {
            Node portletNameNode = null;
            int i = 0;
            while (i < portletNameList.getLength()) {
                if (NodeUtil.getTextContent((Node)portletNameList.item(i)).equals(portletName)) {
                    portletNameNode = portletNameList.item(i);
                }
                ++i;
            }
            if (portletNameNode == null) {
                return Status.CANCEL_STATUS;
            }
            Element newResourceBundleElement = null;
            Node portlet = portletNameNode.getParentNode();
            Node refNode = null;
            Node supports = NodeUtil.findLastChild((Element)((Element)portlet), (String)"supports");
            if (supports != null) {
                Node supportedLocale = NodeUtil.findLastChild((Element)((Element)portlet), (String)"supported-locale");
                refNode = supportedLocale != null ? supportedLocale : supports;
            } else {
                return Status.CANCEL_STATUS;
            }
            newResourceBundleElement = NodeUtil.insertChildElementAfter((Element)((Element)portlet), (Node)refNode, (String)"resource-bundle", (String)resourceBundle);
            processor.formatNode((Node)newResourceBundleElement);
        }
        return Status.OK_STATUS;
    }

    public IStatus doRemoveAllPortlets() {
        String portletTagName = "portlet";
        LiferayDescriptorHelper.DOMModelEditOperation domModelOperation = new LiferayDescriptorHelper.DOMModelEditOperation(this, this.getDescriptorFile()){

            protected IStatus doExecute(IDOMDocument document) {
                return PortletDescriptorHelper.this.removeAllElements(document, "portlet");
            }
        };
        IStatus status = domModelOperation.execute();
        return status;
    }

    public String[] getAllPortletNames() {
        final ArrayList allPortletNames = new ArrayList();
        IFile descriptorFile = this.getDescriptorFile();
        if (descriptorFile != null) {
            LiferayDescriptorHelper.DOMModelReadOperation op = new LiferayDescriptorHelper.DOMModelReadOperation(this, descriptorFile){

                protected IStatus doExecute(IDOMDocument document) {
                    NodeList nodeList = document.getElementsByTagName("portlet-name");
                    int i = 0;
                    while (i < nodeList.getLength()) {
                        Element portletName = (Element)nodeList.item(i);
                        allPortletNames.add(NodeUtil.getTextContent((Node)portletName));
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            op.execute();
        }
        return allPortletNames.toArray(new String[0]);
    }

    public String[] getAllResourceBundles() {
        final ArrayList allResourceBundles = new ArrayList();
        IFile descriptorFile = this.getDescriptorFile();
        if (descriptorFile != null) {
            LiferayDescriptorHelper.DOMModelReadOperation op = new LiferayDescriptorHelper.DOMModelReadOperation(this, descriptorFile){

                protected IStatus doExecute(IDOMDocument document) {
                    NodeList nodeList = document.getElementsByTagName("resource-bundle");
                    int i = 0;
                    while (i < nodeList.getLength()) {
                        Element resourceBundle = (Element)nodeList.item(i);
                        allResourceBundles.add(NodeUtil.getTextContent((Node)resourceBundle));
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            op.execute();
        }
        return allResourceBundles.toArray(new String[0]);
    }

    public IFile getDescriptorFile() {
        return super.getDescriptorFile(DESCRIPTOR_FILE);
    }

    protected String getPortletClassText(IDataModel model) {
        return model.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
    }
}

