/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.model.internal;

import com.liferay.ide.portlet.core.util.PortletModelUtil;
import com.liferay.ide.portlet.core.util.PortletUtil;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public final class QNameTextNodeValueBinding
extends XmlValueBindingImpl {
    private XmlPath path;
    private String[] params;

    public void init(Property property) {
        super.init(property);
        this.params = ((CustomXmlValueBinding)property.definition().getAnnotation(CustomXmlValueBinding.class)).params();
        this.path = new XmlPath(this.params[0], this.resource().getXmlNamespaceResolver());
    }

    public String read() {
        XmlElement qNamedElement;
        String value = null;
        XmlElement parent = this.xml(false);
        if (parent != null && (qNamedElement = parent.getChildElement(this.params[0], false)) != null) {
            String prefix;
            Attr attrib;
            Element domNode = qNamedElement.getDomNode();
            value = qNamedElement.getText();
            if (value != null && (attrib = domNode.getAttributeNode(String.format("xmlns:%s", prefix = PortletUtil.stripSuffix(value.trim())))) != null) {
                QName qname = new QName(attrib.getValue(), PortletUtil.stripPrefix(value));
                value = qname.toString();
            }
        }
        return value;
    }

    public void write(String value) {
        String qNameAsString = value;
        XmlElement parent = this.xml(true);
        if (qNameAsString != null && !"Q_NAME".equals(qNameAsString)) {
            qNameAsString = value.trim();
            QName qName = QName.valueOf(qNameAsString);
            XmlElement qNamedElement = parent.getChildElement(this.params[0], true);
            String qualifiedNodeValue = PortletModelUtil.defineNS(qNamedElement, qName);
            qNamedElement.setText(qualifiedNodeValue);
        } else {
            parent.remove();
        }
    }

    public XmlNode getXmlNode() {
        XmlElement element = this.xml(false);
        if (element != null) {
            return element.getChildNode(this.path, false);
        }
        return null;
    }
}

