/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.JEEPackaging;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RarPluginConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RarPluginConfiguration.class);
    private static final String RAR_DEFAULT_CONTENT_DIR = "src/main/rar";
    private static final String RA_XML = "META-INF/ra.xml";
    private static final int JCA_1_6_ID = 16;
    private static final int JCA_1_7_ID = 17;
    final Plugin plugin;
    final IMavenProjectFacade rarFacade;

    public RarPluginConfiguration(IMavenProjectFacade facade) throws CoreException {
        Assert.isNotNull((Object)facade);
        if (JEEPackaging.RAR != JEEPackaging.getValue(facade.getPackaging())) {
            throw new IllegalArgumentException(Messages.RarPluginConfiguration_Project_Must_Have_rar_Packaging);
        }
        this.rarFacade = facade;
        this.plugin = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor()).getPlugin("org.apache.maven.plugins:maven-rar-plugin");
    }

    private Xpp3Dom getConfiguration() {
        if (this.plugin == null) {
            return null;
        }
        return (Xpp3Dom)this.plugin.getConfiguration();
    }

    public boolean isJarIncluded() {
        Xpp3Dom includeJarDom;
        Xpp3Dom config = this.getConfiguration();
        if (config != null && (includeJarDom = config.getChild("includeJar")) != null) {
            return Boolean.parseBoolean(includeJarDom.getValue().trim());
        }
        return true;
    }

    public String getRarContentDirectory() {
        Xpp3Dom contentDirDom;
        IProject project = this.rarFacade.getProject();
        Xpp3Dom config = this.getConfiguration();
        if (config != null && (contentDirDom = config.getChild("rarSourceDirectory")) != null && contentDirDom.getValue() != null) {
            String contentDir = contentDirDom.getValue().trim();
            contentDir = (contentDir = ProjectUtils.getRelativePath(project, contentDir)).length() == 0 ? RAR_DEFAULT_CONTENT_DIR : contentDir;
            return contentDir;
        }
        return RAR_DEFAULT_CONTENT_DIR;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProjectFacetVersion getConnectorFacetVersion() {
        IFile raXml = this.getRaXml();
        if (raXml != null && raXml.isAccessible()) {
            try (InputStream is = raXml.getContents();){
                JavaEEQuickPeek jqp = new JavaEEQuickPeek(is);
                switch (jqp.getVersion()) {
                    case 10: {
                        IProjectFacetVersion iProjectFacetVersion = IJ2EEFacetConstants.JCA_10;
                        return iProjectFacetVersion;
                    }
                    case 15: {
                        IProjectFacetVersion iProjectFacetVersion = IJ2EEFacetConstants.JCA_15;
                        return iProjectFacetVersion;
                    }
                    case 16: {
                        IProjectFacetVersion iProjectFacetVersion = IJ2EEFacetConstants.JCA_FACET.getVersion("1.6");
                        return iProjectFacetVersion;
                    }
                    case 17: {
                        IProjectFacetVersion iProjectFacetVersion = IJ2EEFacetConstants.JCA_FACET.getVersion("1.7");
                        return iProjectFacetVersion;
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        IProject project = this.rarFacade.getProject();
        try {
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
            if (fProject == null) return IJ2EEFacetConstants.JCA_FACET.getVersion("1.6");
            if (!fProject.hasProjectFacet(IJ2EEFacetConstants.JCA_FACET)) return IJ2EEFacetConstants.JCA_FACET.getVersion("1.6");
            return fProject.getProjectFacetVersion(IJ2EEFacetConstants.JCA_FACET);
        }
        catch (Exception e) {
            LOG.warn(NLS.bind((String)Messages.Error_Reading_Project_Facet, (Object)project.getName()), (Throwable)e);
        }
        return IJ2EEFacetConstants.JCA_FACET.getVersion("1.6");
    }

    public String getCustomRaXml() {
        Xpp3Dom raXmlFileDom;
        Xpp3Dom config = this.getConfiguration();
        if (config != null && (raXmlFileDom = config.getChild("raXmlFile")) != null && raXmlFileDom.getValue() != null) {
            String raXmlFile = raXmlFileDom.getValue().trim();
            raXmlFile = ProjectUtils.getRelativePath(this.rarFacade.getProject(), raXmlFile);
            return raXmlFile;
        }
        return null;
    }

    public IFile getRaXml() {
        IProject project = this.rarFacade.getProject();
        String customRaXmlPath = this.getCustomRaXml();
        IFile raXml = null;
        if (customRaXmlPath != null) {
            raXml = project.getFile(customRaXmlPath);
        }
        if (raXml == null || !raXml.isAccessible()) {
            raXml = project.getFolder(this.getRarContentDirectory()).getFile(RA_XML);
        }
        if (!raXml.isAccessible()) {
            IPath[] iPathArray = this.rarFacade.getResourceLocations();
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath resourcePath = iPathArray[n2];
                raXml = project.getFolder(resourcePath).getFile(RA_XML);
                if (raXml.isAccessible()) break;
                ++n2;
            }
        }
        return raXml;
    }
}

