/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.ILiferayProjectAdapter;
import com.liferay.ide.core.ILiferayProjectImporter;
import com.liferay.ide.core.ILiferayProjectProvider;
import com.liferay.ide.core.LiferayLanguagePropertiesListener;
import com.liferay.ide.core.LiferayProjectAdapterReader;
import com.liferay.ide.core.LiferayProjectImporterReader;
import com.liferay.ide.core.LiferayProjectProviderReader;
import com.liferay.ide.core.util.CoreUtil;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class LiferayCore
extends Plugin {
    private static final LiferayProjectAdapterReader adapterReader = new LiferayProjectAdapterReader();
    public static final IPath GLOBAL_SETTINGS_PATH = new Path(String.valueOf(System.getProperty("user.home", "")) + "/.liferay-ide");
    private static LiferayLanguagePropertiesListener liferayLanguagePropertiesListener;
    private static LiferayCore plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.core";
    private static LiferayProjectProviderReader providerReader;
    private static LiferayProjectImporterReader importerReader;

    public static ILiferayProject create(Object adaptable) {
        Object[] providers;
        ILiferayProject project = null;
        if (adaptable != null && !CoreUtil.isNullOrEmpty(providers = LiferayCore.getProviders(adaptable.getClass()))) {
            Object currentProvider = null;
            Object[] objectArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                ILiferayProject lrp;
                Object provider = objectArray[n2];
                if ((currentProvider == null || provider.getPriority() > currentProvider.getPriority()) && (lrp = provider.provide(adaptable)) != null) {
                    currentProvider = provider;
                    project = lrp;
                }
                ++n2;
            }
        }
        return project;
    }

    public static <T> T create(Class<T> type, Object adaptable) {
        T retval = null;
        if (type != null) {
            ILiferayProject lrproject = LiferayCore.create(adaptable);
            if (lrproject != null && type.isAssignableFrom(lrproject.getClass())) {
                retval = type.cast(lrproject);
            }
            if (retval == null && lrproject != null) {
                retval = lrproject.adapt(type);
            }
        }
        return retval;
    }

    public static IStatus createErrorStatus(Exception e) {
        return LiferayCore.createErrorStatus(PLUGIN_ID, e);
    }

    public static IStatus createErrorStatus(String msg) {
        return LiferayCore.createErrorStatus(PLUGIN_ID, msg);
    }

    public static IStatus createErrorStatus(String pluginId, String msg) {
        return new Status(4, pluginId, msg);
    }

    public static IStatus createErrorStatus(String pluginId, String msg, Throwable e) {
        return new Status(4, pluginId, msg, e);
    }

    public static IStatus createErrorStatus(String pluginId, Throwable t) {
        return new Status(4, pluginId, t.getMessage(), t);
    }

    public static IStatus createInfoStatus(String msg) {
        return LiferayCore.createInfoStatus(PLUGIN_ID, msg);
    }

    public static IStatus createInfoStatus(String pluginId, String msg) {
        return new Status(1, pluginId, msg);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, message);
    }

    public static IStatus createWarningStatus(String message, String id) {
        return new Status(2, id, message);
    }

    public static IStatus createWarningStatus(String message, String id, Exception e) {
        return new Status(2, id, message, (Throwable)e);
    }

    public static LiferayCore getDefault() {
        return plugin;
    }

    public static synchronized ILiferayProjectImporter[] getImporters() {
        if (importerReader == null) {
            importerReader = new LiferayProjectImporterReader();
        }
        return importerReader.getImporters();
    }

    public static synchronized ILiferayProjectImporter getImporter(String buildType) {
        if (importerReader == null) {
            importerReader = new LiferayProjectImporterReader();
        }
        return importerReader.getImporter(buildType);
    }

    public static synchronized ILiferayProjectAdapter[] getProjectAdapters() {
        return adapterReader.getExtensions().toArray(new ILiferayProjectAdapter[0]);
    }

    public static synchronized ILiferayProjectProvider getProvider(String shortName) {
        ILiferayProjectProvider[] iLiferayProjectProviderArray = LiferayCore.getProviders();
        int n = iLiferayProjectProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILiferayProjectProvider provider = iLiferayProjectProviderArray[n2];
            if (provider.getShortName().equals(shortName)) {
                return provider;
            }
            ++n2;
        }
        return null;
    }

    public static synchronized ILiferayProjectProvider[] getProviders() {
        if (providerReader == null) {
            providerReader = new LiferayProjectProviderReader();
        }
        return providerReader.getProviders();
    }

    public static synchronized ILiferayProjectProvider[] getProviders(String projectType) {
        if (providerReader == null) {
            providerReader = new LiferayProjectProviderReader();
        }
        return providerReader.getProviders(projectType);
    }

    public static synchronized ILiferayProjectProvider[] getProviders(Class<?> type) {
        if (providerReader == null) {
            providerReader = new LiferayProjectProviderReader();
        }
        return providerReader.getProviders(type);
    }

    public static IProxyService getProxyService() {
        ServiceTracker proxyTracker = new ServiceTracker(LiferayCore.getDefault().getBundle().getBundleContext(), IProxyService.class.getName(), null);
        proxyTracker.open();
        IProxyService proxyService = (IProxyService)proxyTracker.getService();
        proxyTracker.close();
        return proxyService;
    }

    public static void logError(IStatus status) {
        LiferayCore.getDefault().getLog().log(status);
    }

    public static void logError(String msg) {
        LiferayCore.logError(LiferayCore.createErrorStatus(msg));
    }

    public static void logError(String msg, Throwable t) {
        LiferayCore.getDefault().getLog().log(LiferayCore.createErrorStatus(PLUGIN_ID, msg, t));
    }

    public static void logError(Throwable t) {
        LiferayCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static void logInfo(String msg) {
        LiferayCore.logError(LiferayCore.createInfoStatus(msg));
    }

    public static void logWarning(Throwable t) {
        LiferayCore.getDefault().getLog().log((IStatus)new Status(2, PLUGIN_ID, t.getMessage(), t));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (liferayLanguagePropertiesListener == null) {
            liferayLanguagePropertiesListener = new LiferayLanguagePropertiesListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)liferayLanguagePropertiesListener, 1);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (liferayLanguagePropertiesListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)liferayLanguagePropertiesListener);
            liferayLanguagePropertiesListener = null;
        }
    }
}

